/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.event;

import de.ellpeck.actuallyadditions.mod.config.values.ConfigBoolValues;
import de.ellpeck.actuallyadditions.mod.data.PlayerData;
import de.ellpeck.actuallyadditions.mod.data.WorldData;
import de.ellpeck.actuallyadditions.mod.inventory.ContainerBag;
import de.ellpeck.actuallyadditions.mod.items.InitItems;
import de.ellpeck.actuallyadditions.mod.items.ItemBag;
import de.ellpeck.actuallyadditions.mod.items.ItemDrill;
import de.ellpeck.actuallyadditions.mod.items.metalists.TheMiscItems;
import de.ellpeck.actuallyadditions.mod.misc.DungeonLoot;
import de.ellpeck.actuallyadditions.mod.network.PacketHandlerHelper;
import de.ellpeck.actuallyadditions.mod.tile.FilterSettings;
import de.ellpeck.actuallyadditions.mod.util.ItemStackHandlerCustom;
import de.ellpeck.actuallyadditions.mod.util.ItemUtil;
import de.ellpeck.actuallyadditions.mod.util.ModUtil;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import java.util.Locale;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class CommonEvents {
    public CommonEvents() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new DungeonLoot());
    }

    @SubscribeEvent
    public void onBlockBreakEvent(BlockEvent.HarvestDropsEvent event) {
        IBlockState state = event.getState();
        if (state != null && state.func_177230_c() == Blocks.field_150474_ac) {
            event.getDrops().add(new ItemStack(InitItems.itemMisc, 1, TheMiscItems.SPAWNER_SHARD.ordinal()));
        }
    }

    @SubscribeEvent
    public void onItemPickup(EntityItemPickupEvent event) {
        if (event.isCanceled() || event.getResult() == Event.Result.ALLOW) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        EntityItem item = event.getItem();
        if (item != null && !item.field_70128_L) {
            ItemStack stack = item.func_92059_d();
            if (StackUtil.isValid(stack)) {
                for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                    ItemStack invStack;
                    if (i != player.field_71071_by.field_70461_c && StackUtil.isValid(invStack = player.field_71071_by.func_70301_a(i)) && invStack.func_77973_b() instanceof ItemBag && invStack.func_77942_o() && invStack.func_77978_p().func_74767_n("AutoInsert")) {
                        boolean changed = false;
                        boolean isVoid = ((ItemBag)invStack.func_77973_b()).isVoid;
                        ItemStackHandlerCustom inv = new ItemStackHandlerCustom(ContainerBag.getSlotAmount(isVoid));
                        ItemDrill.loadSlotsFromNBT(inv, invStack);
                        FilterSettings filter = new FilterSettings(4, false, false, false, false, 0, 0);
                        filter.readFromNBT(invStack.func_77978_p(), "Filter");
                        if (filter.check(stack)) {
                            if (isVoid) {
                                stack = StackUtil.setStackSize(stack, 0);
                                changed = true;
                            } else {
                                for (int j = 0; j < inv.getSlots(); ++j) {
                                    ItemStack bagStack = inv.getStackInSlot(j);
                                    if (StackUtil.isValid(bagStack)) {
                                        int maxTransfer;
                                        if (ItemUtil.canBeStacked(bagStack, stack) && (maxTransfer = Math.min(StackUtil.getStackSize(stack), stack.func_77976_d() - StackUtil.getStackSize(bagStack))) > 0) {
                                            inv.setStackInSlot(j, StackUtil.addStackSize(bagStack, maxTransfer));
                                            stack = StackUtil.addStackSize(stack, -maxTransfer);
                                            changed = true;
                                        }
                                    } else {
                                        inv.setStackInSlot(j, stack.func_77946_l());
                                        stack = StackUtil.setStackSize(stack, 0);
                                        changed = true;
                                    }
                                    if (!StackUtil.isValid(stack)) break;
                                }
                            }
                        }
                        if (changed) {
                            if (!isVoid) {
                                ItemDrill.writeSlotsToNBT(inv, invStack);
                            }
                            event.setResult(Event.Result.ALLOW);
                        }
                    }
                    if (!StackUtil.isValid(stack)) break;
                }
            }
            item.func_92058_a(stack);
        }
    }

    @SubscribeEvent
    public void onEntityDropEvent(LivingDropsEvent event) {
        if (event.getEntityLiving().field_70170_p != null && !event.getEntityLiving().field_70170_p.field_72995_K && event.getSource().func_76346_g() instanceof EntityPlayer && ConfigBoolValues.DO_SPIDER_DROPS.isEnabled() && event.getEntityLiving() instanceof EntitySpider && event.getEntityLiving().field_70170_p.field_73012_v.nextInt(20) <= event.getLootingLevel() * 2) {
            event.getDrops().add(new EntityItem(event.getEntityLiving().field_70170_p, event.getEntityLiving().field_70165_t, event.getEntityLiving().field_70163_u, event.getEntityLiving().field_70161_v, new ItemStack(Blocks.field_150321_G, event.getEntityLiving().field_70170_p.field_73012_v.nextInt(2 + event.getLootingLevel()) + 1)));
        }
    }

    @SubscribeEvent
    public void onLogInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.player.field_70170_p.field_72995_K && event.player instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.player;
            PacketHandlerHelper.syncPlayerData((EntityPlayer)player, true);
            ModUtil.LOGGER.info("Sending Player Data to player " + player.func_70005_c_() + " with UUID " + player.func_110124_au() + ".");
        }
    }

    @SubscribeEvent
    public void onCraftedEvent(PlayerEvent.ItemCraftedEvent event) {
        PlayerData.PlayerSave save;
        String name;
        if (ConfigBoolValues.GIVE_BOOKLET_ON_FIRST_CRAFT.isEnabled() && !event.player.field_70170_p.field_72995_K && StackUtil.isValid(event.crafting) && event.crafting.func_77973_b() != InitItems.itemBooklet && (name = event.crafting.func_77973_b().getRegistryName().toString()) != null && name.toLowerCase(Locale.ROOT).contains("actuallyadditions") && (save = PlayerData.getDataFromPlayer(event.player)) != null && !save.bookGottenAlready) {
            save.bookGottenAlready = true;
            WorldData.get(event.player.func_130014_f_()).func_76185_a();
            EntityItem entityItem = new EntityItem(event.player.field_70170_p, event.player.field_70165_t, event.player.field_70163_u, event.player.field_70161_v, new ItemStack(InitItems.itemBooklet));
            entityItem.func_174867_a(0);
            event.player.field_70170_p.func_72838_d((Entity)entityItem);
        }
    }

    @SubscribeEvent
    public void onSmeltedEvent(PlayerEvent.ItemSmeltedEvent event) {
    }

    @SubscribeEvent
    public void onPickupEvent(EntityItemPickupEvent event) {
    }

    @SubscribeEvent
    public void onLoad(WorldEvent.Load event) {
        WorldData.loadLegacy(event.getWorld());
    }
}

