/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.items;

import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.inventory.ContainerBag;
import de.ellpeck.actuallyadditions.mod.inventory.GuiHandler;
import de.ellpeck.actuallyadditions.mod.items.ItemDrill;
import de.ellpeck.actuallyadditions.mod.items.base.ItemBase;
import de.ellpeck.actuallyadditions.mod.util.ItemStackHandlerCustom;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import de.ellpeck.actuallyadditions.mod.util.StringUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ItemBag
extends ItemBase {
    public final boolean isVoid;

    public ItemBag(String name, boolean isVoid) {
        super(name);
        this.isVoid = isVoid;
        this.func_77625_d(1);
    }

    public void func_77624_a(ItemStack stack, @Nullable World playerIn, List<String> tooltip, ITooltipFlag advanced) {
        ItemStackHandlerCustom inv = new ItemStackHandlerCustom(ContainerBag.getSlotAmount(this.isVoid));
        ItemDrill.loadSlotsFromNBT(inv, stack);
        int slotsTotal = inv.getSlots();
        int slotsFilled = 0;
        for (int i = 0; i < inv.getSlots(); ++i) {
            if (!StackUtil.isValid(inv.getStackInSlot(i))) continue;
            ++slotsFilled;
        }
        tooltip.add(TextFormatting.ITALIC + String.format("%d/%d %s", slotsFilled, slotsTotal, StringUtil.localize("item.actuallyadditions.item_bag.storage")));
    }

    public EnumActionResult func_180614_a(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tile;
        ItemStack stack = playerIn.func_184586_b(hand);
        if (!this.isVoid && (tile = worldIn.func_175625_s(pos)) != null && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing)) {
            IItemHandler handler;
            if (!worldIn.field_72995_K && (handler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing)) != null) {
                boolean changed = false;
                ItemStackHandlerCustom inv = new ItemStackHandlerCustom(ContainerBag.getSlotAmount(this.isVoid));
                ItemDrill.loadSlotsFromNBT(inv, stack);
                block0: for (int j = 0; j < inv.getSlots(); ++j) {
                    ItemStack invStack = inv.getStackInSlot(j);
                    if (!StackUtil.isValid(invStack)) continue;
                    for (int i = 0; i < handler.getSlots(); ++i) {
                        ItemStack remain = handler.insertItem(i, invStack, false);
                        if (ItemStack.func_77989_b((ItemStack)remain, (ItemStack)invStack)) continue;
                        inv.setStackInSlot(j, StackUtil.validateCopy(remain));
                        changed = true;
                        if (!StackUtil.isValid(remain)) continue block0;
                    }
                }
                if (changed) {
                    ItemDrill.writeSlotsToNBT(inv, stack);
                }
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (!world.field_72995_K && hand == EnumHand.MAIN_HAND) {
            player.openGui((Object)ActuallyAdditions.instance, (this.isVoid ? GuiHandler.GuiTypes.VOID_BAG : GuiHandler.GuiTypes.BAG).ordinal(), world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return this.isVoid ? EnumRarity.RARE : EnumRarity.UNCOMMON;
    }
}

