/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.items;

import de.ellpeck.actuallyadditions.mod.config.values.ConfigBoolValues;
import de.ellpeck.actuallyadditions.mod.items.InitItems;
import de.ellpeck.actuallyadditions.mod.items.base.ItemBase;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ItemWaterBowl
extends ItemBase {
    public ItemWaterBowl(String name) {
        super(name);
        this.func_77625_d(1);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onPlayerInteractEvent(PlayerInteractEvent.RightClickItem event) {
        if (event.getWorld() != null && ConfigBoolValues.WATER_BOWL.isEnabled() && StackUtil.isValid(event.getItemStack()) && event.getItemStack().func_77973_b() == Items.field_151054_z) {
            IBlockState state;
            Block block;
            RayTraceResult trace = WorldUtil.getNearestBlockWithDefaultReachDistance(event.getWorld(), event.getEntityPlayer(), true, false, false);
            ActionResult result = ForgeEventFactory.onBucketUse((EntityPlayer)event.getEntityPlayer(), (World)event.getWorld(), (ItemStack)event.getItemStack(), (RayTraceResult)trace);
            if (result == null && trace != null && trace.func_178782_a() != null && event.getEntityPlayer().func_175151_a(trace.func_178782_a().func_177972_a(trace.field_178784_b), trace.field_178784_b, event.getItemStack()) && ((block = (state = event.getWorld().func_180495_p(trace.func_178782_a())).func_177230_c()) == Blocks.field_150355_j || block == Blocks.field_150358_i) && (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0) {
                event.getEntityPlayer().func_184185_a(SoundEvents.field_187630_M, 1.0f, 1.0f);
                if (!event.getWorld().field_72995_K) {
                    event.getWorld().func_180501_a(trace.func_178782_a(), Blocks.field_150350_a.func_176223_P(), 11);
                    ItemStack reduced = StackUtil.addStackSize(event.getItemStack(), -1);
                    ItemStack bowl = new ItemStack(InitItems.itemWaterBowl);
                    if (!StackUtil.isValid(reduced)) {
                        event.getEntityPlayer().func_184611_a(event.getHand(), bowl);
                    } else if (!event.getEntityPlayer().field_71071_by.func_70441_a(bowl.func_77946_l())) {
                        EntityItem entityItem = new EntityItem(event.getWorld(), event.getEntityPlayer().field_70165_t, event.getEntityPlayer().field_70163_u, event.getEntityPlayer().field_70161_v, bowl.func_77946_l());
                        entityItem.func_174867_a(0);
                        event.getWorld().func_72838_d((Entity)entityItem);
                    }
                }
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        BlockPos pos1;
        RayTraceResult trace;
        ItemStack stack = player.func_184586_b(hand);
        ActionResult result = ForgeEventFactory.onBucketUse((EntityPlayer)player, (World)world, (ItemStack)stack, (RayTraceResult)(trace = WorldUtil.getNearestBlockWithDefaultReachDistance(world, player)));
        if (result != null) {
            return result;
        }
        if (trace == null) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        if (trace.field_72313_a != RayTraceResult.Type.BLOCK) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        BlockPos pos = trace.func_178782_a();
        if (!world.func_175660_a(player, pos)) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        BlockPos blockPos = pos1 = world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos) && trace.field_178784_b == EnumFacing.UP ? pos : pos.func_177972_a(trace.field_178784_b);
        if (!player.func_175151_a(pos1, trace.field_178784_b, stack)) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        if (this.tryPlaceContainedLiquid(player, world, pos1, false)) {
            return !player.field_71075_bZ.field_75098_d ? new ActionResult(EnumActionResult.SUCCESS, (Object)new ItemStack(Items.field_151054_z)) : new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (!world.field_72995_K && ConfigBoolValues.WATER_BOWL_LOSS.isEnabled() && world.func_82737_E() % 10L == 0L && world.field_73012_v.nextFloat() >= 0.5f) {
            int lastX = 0;
            int lastY = 0;
            if (stack.func_77942_o()) {
                NBTTagCompound compound = stack.func_77978_p();
                lastX = compound.func_74762_e("lastX");
                lastY = compound.func_74762_e("lastY");
            }
            boolean change = false;
            if (lastX != 0 && lastX != (int)entity.field_70165_t || lastY != 0 && lastY != (int)entity.field_70163_u) {
                EntityPlayer player;
                if (!entity.func_70093_af() && entity instanceof EntityPlayer && this.tryPlaceContainedLiquid(player = (EntityPlayer)entity, world, player.func_180425_c(), true)) {
                    player.field_71071_by.func_70299_a(itemSlot, new ItemStack(Items.field_151054_z));
                }
                change = true;
            }
            if (change || lastX == 0 || lastY == 0) {
                if (!stack.func_77942_o()) {
                    stack.func_77982_d(new NBTTagCompound());
                }
                NBTTagCompound compound = stack.func_77978_p();
                compound.func_74768_a("lastX", (int)entity.field_70165_t);
                compound.func_74768_a("lastY", (int)entity.field_70163_u);
            }
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !ItemStack.func_179545_c((ItemStack)oldStack, (ItemStack)newStack);
    }

    public boolean tryPlaceContainedLiquid(EntityPlayer player, World world, BlockPos pos, boolean finite) {
        IBlockState state = world.func_180495_p(pos);
        Material material = state.func_185904_a();
        boolean nonSolid = !material.func_76220_a();
        boolean replaceable = state.func_177230_c().func_176200_f((IBlockAccess)world, pos);
        if (!(world.func_175623_d(pos) || nonSolid || replaceable)) {
            return false;
        }
        if (world.field_73011_w.func_177500_n()) {
            world.func_184133_a(player, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
            for (int k = 0; k < 8; ++k) {
                world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)pos.func_177958_n() + Math.random(), (double)pos.func_177956_o() + Math.random(), (double)pos.func_177952_p() + Math.random(), 0.0, 0.0, 0.0, new int[0]);
            }
        } else {
            if (!world.field_72995_K && (nonSolid || replaceable) && !material.func_76224_d()) {
                world.func_175655_b(pos, true);
            }
            world.func_184133_a(player, pos, SoundEvents.field_187624_K, SoundCategory.BLOCKS, 1.0f, 1.0f);
            IBlockState placeState = finite ? Blocks.field_150358_i.func_176223_P() : Blocks.field_150358_i.func_176223_P();
            world.func_180501_a(pos, placeState, 3);
        }
        return true;
    }
}

