/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.blocks.BlockFurnaceDouble;
import de.ellpeck.actuallyadditions.mod.network.gui.IButtonReactor;
import de.ellpeck.actuallyadditions.mod.tile.CustomEnergyStorage;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.ItemStackHandlerCustom;
import de.ellpeck.actuallyadditions.mod.util.ItemUtil;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityFurnaceDouble
extends TileEntityInventoryBase
implements IButtonReactor {
    public static final int SLOT_INPUT_1 = 0;
    public static final int SLOT_OUTPUT_1 = 1;
    public static final int SLOT_INPUT_2 = 2;
    public static final int SLOT_OUTPUT_2 = 3;
    public static final int ENERGY_USE = 25;
    private static final int SMELT_TIME = 80;
    public final CustomEnergyStorage storage = new CustomEnergyStorage(30000, 150, 0);
    public int firstSmeltTime;
    public int secondSmeltTime;
    public boolean isAutoSplit;
    private int lastEnergy;
    private int lastFirstSmelt;
    private int lastSecondSmelt;
    private boolean lastAutoSplit;
    private boolean lastSmelted;

    public TileEntityFurnaceDouble() {
        super(4, "furnaceDouble");
    }

    public static void autoSplit(ItemStackHandlerCustom slots, int slot1, int slot2) {
        ItemStack first = slots.getStackInSlot(slot1);
        ItemStack second = slots.getStackInSlot(slot2);
        if (StackUtil.isValid(first) || StackUtil.isValid(second)) {
            ItemStack toSplit = StackUtil.getEmpty();
            if (!StackUtil.isValid(first) && StackUtil.isValid(second) && StackUtil.getStackSize(second) > 1) {
                toSplit = second;
            } else if (!StackUtil.isValid(second) && StackUtil.isValid(first) && StackUtil.getStackSize(first) > 1) {
                toSplit = first;
            } else if (!(!ItemUtil.canBeStacked(first, second) || StackUtil.getStackSize(first) >= first.func_77976_d() && StackUtil.getStackSize(second) >= second.func_77976_d() || StackUtil.getStackSize(first) <= StackUtil.getStackSize(second) + 1 && StackUtil.getStackSize(first) >= StackUtil.getStackSize(second) - 1 || StackUtil.getStackSize(second) <= StackUtil.getStackSize(first) + 1 && StackUtil.getStackSize(second) >= StackUtil.getStackSize(first) - 1)) {
                toSplit = first;
                toSplit = StackUtil.addStackSize(toSplit, StackUtil.getStackSize(second));
            }
            if (StackUtil.isValid(toSplit)) {
                ItemStack splitFirst = toSplit.func_77946_l();
                ItemStack secondSplit = splitFirst.func_77979_a(StackUtil.getStackSize(splitFirst) / 2);
                slots.setStackInSlot(slot1, StackUtil.validateCheck(splitFirst));
                slots.setStackInSlot(slot2, StackUtil.validateCheck(secondSplit));
            }
        }
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.func_74768_a("FirstSmeltTime", this.firstSmeltTime);
            compound.func_74768_a("SecondSmeltTime", this.secondSmeltTime);
            compound.func_74757_a("IsAutoSplit", this.isAutoSplit);
        }
        this.storage.writeToNBT(compound);
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.firstSmeltTime = compound.func_74762_e("FirstSmeltTime");
            this.secondSmeltTime = compound.func_74762_e("SecondSmeltTime");
            this.isAutoSplit = compound.func_74767_n("IsAutoSplit");
        }
        this.storage.readFromNBT(compound);
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!this.field_145850_b.field_72995_K) {
            if (this.isAutoSplit) {
                TileEntityFurnaceDouble.autoSplit(this.slots, 0, 2);
            }
            boolean smelted = false;
            boolean canSmeltOnFirst = this.canSmeltOn(0, 1);
            boolean canSmeltOnSecond = this.canSmeltOn(2, 3);
            if (canSmeltOnFirst) {
                if (this.storage.getEnergyStored() >= 25) {
                    ++this.firstSmeltTime;
                    if (this.firstSmeltTime >= 80) {
                        this.finishBurning(0, 1);
                        this.firstSmeltTime = 0;
                    }
                    this.storage.extractEnergyInternal(25, false);
                }
                smelted = true;
            } else {
                this.firstSmeltTime = 0;
            }
            if (canSmeltOnSecond) {
                if (this.storage.getEnergyStored() >= 25) {
                    ++this.secondSmeltTime;
                    if (this.secondSmeltTime >= 80) {
                        this.finishBurning(2, 3);
                        this.secondSmeltTime = 0;
                    }
                    this.storage.extractEnergyInternal(25, false);
                }
                smelted = true;
            } else {
                this.secondSmeltTime = 0;
            }
            if (smelted != this.lastSmelted) {
                IBlockState currState = this.field_145850_b.func_180495_p(this.field_174879_c);
                if ((Boolean)currState.func_177229_b((IProperty)BlockFurnaceDouble.IS_ON) != smelted) {
                    this.field_145850_b.func_175656_a(this.field_174879_c, currState.func_177226_a((IProperty)BlockFurnaceDouble.IS_ON, (Comparable)Boolean.valueOf(smelted)));
                }
                this.lastSmelted = smelted;
            }
            if ((this.lastEnergy != this.storage.getEnergyStored() || this.lastFirstSmelt != this.firstSmeltTime || this.lastSecondSmelt != this.secondSmeltTime || this.isAutoSplit != this.lastAutoSplit) && this.sendUpdateWithInterval()) {
                this.lastEnergy = this.storage.getEnergyStored();
                this.lastFirstSmelt = this.firstSmeltTime;
                this.lastAutoSplit = this.isAutoSplit;
                this.lastSecondSmelt = this.secondSmeltTime;
            }
        }
    }

    @Override
    public boolean isItemValidForSlot(int i, ItemStack stack) {
        return (i == 0 || i == 2) && StackUtil.isValid(FurnaceRecipes.func_77602_a().func_151395_a(stack));
    }

    public boolean canSmeltOn(int theInput, int theOutput) {
        ItemStack output;
        return StackUtil.isValid(this.slots.getStackInSlot(theInput)) && StackUtil.isValid(output = FurnaceRecipes.func_77602_a().func_151395_a(this.slots.getStackInSlot(theInput))) && (!StackUtil.isValid(this.slots.getStackInSlot(theOutput)) || this.slots.getStackInSlot(theOutput).func_77969_a(output) && StackUtil.getStackSize(this.slots.getStackInSlot(theOutput)) <= this.slots.getStackInSlot(theOutput).func_77976_d() - StackUtil.getStackSize(output));
    }

    public void finishBurning(int theInput, int theOutput) {
        ItemStack output = FurnaceRecipes.func_77602_a().func_151395_a(this.slots.getStackInSlot(theInput));
        if (!StackUtil.isValid(this.slots.getStackInSlot(theOutput))) {
            this.slots.setStackInSlot(theOutput, output.func_77946_l());
        } else if (this.slots.getStackInSlot(theOutput).func_77973_b() == output.func_77973_b()) {
            this.slots.setStackInSlot(theOutput, StackUtil.addStackSize(this.slots.getStackInSlot(theOutput), StackUtil.getStackSize(output)));
        }
        this.slots.setStackInSlot(theInput, StackUtil.addStackSize(this.slots.getStackInSlot(theInput), -1));
    }

    @SideOnly(value=Side.CLIENT)
    public int getFirstTimeToScale(int i) {
        return this.firstSmeltTime * i / 80;
    }

    @SideOnly(value=Side.CLIENT)
    public int getSecondTimeToScale(int i) {
        return this.secondSmeltTime * i / 80;
    }

    @Override
    public boolean canExtractItem(int slot, ItemStack stack) {
        return slot == 1 || slot == 3;
    }

    @Override
    public void onButtonPressed(int buttonID, EntityPlayer player) {
        if (buttonID == 0) {
            this.isAutoSplit = !this.isAutoSplit;
            this.func_70296_d();
        }
    }

    @Override
    public IEnergyStorage getEnergyStorage(EnumFacing facing) {
        return this.storage;
    }
}

