/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.blocks.BlockFurnaceDouble;
import de.ellpeck.actuallyadditions.mod.misc.SoundHandler;
import de.ellpeck.actuallyadditions.mod.network.gui.IButtonReactor;
import de.ellpeck.actuallyadditions.mod.recipe.CrusherRecipeRegistry;
import de.ellpeck.actuallyadditions.mod.tile.CustomEnergyStorage;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityFurnaceDouble;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityGrinder
extends TileEntityInventoryBase
implements IButtonReactor {
    public static final int SLOT_INPUT_1 = 0;
    public static final int SLOT_OUTPUT_1_1 = 1;
    public static final int SLOT_OUTPUT_1_2 = 2;
    public static final int SLOT_INPUT_2 = 3;
    public static final int SLOT_OUTPUT_2_1 = 4;
    public static final int SLOT_OUTPUT_2_2 = 5;
    public static final int ENERGY_USE = 40;
    public final CustomEnergyStorage storage = new CustomEnergyStorage(60000, 100, 0);
    public int firstCrushTime;
    public int secondCrushTime;
    public boolean isDouble;
    public boolean isAutoSplit;
    private int lastEnergy;
    private int lastFirstCrush;
    private int lastSecondCrush;
    private boolean lastAutoSplit;
    private boolean lastCrushed;

    public TileEntityGrinder(int slots, String name) {
        super(slots, name);
    }

    public TileEntityGrinder() {
        super(3, "grinder");
        this.isDouble = false;
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.func_74768_a("FirstCrushTime", this.firstCrushTime);
            compound.func_74768_a("SecondCrushTime", this.secondCrushTime);
            compound.func_74757_a("IsAutoSplit", this.isAutoSplit);
        }
        this.storage.writeToNBT(compound);
        super.writeSyncableNBT(compound, type);
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.firstCrushTime = compound.func_74762_e("FirstCrushTime");
            this.secondCrushTime = compound.func_74762_e("SecondCrushTime");
            this.isAutoSplit = compound.func_74767_n("IsAutoSplit");
        }
        this.storage.readFromNBT(compound);
        super.readSyncableNBT(compound, type);
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!this.field_145850_b.field_72995_K) {
            if (this.isDouble && this.isAutoSplit) {
                TileEntityFurnaceDouble.autoSplit(this.slots, 0, 3);
            }
            boolean crushed = false;
            boolean canCrushOnFirst = this.canCrushOn(0, 1, 2);
            boolean canCrushOnSecond = false;
            if (this.isDouble) {
                canCrushOnSecond = this.canCrushOn(3, 4, 5);
            }
            boolean shouldPlaySound = false;
            if (canCrushOnFirst) {
                if (this.storage.getEnergyStored() >= 40) {
                    if (this.firstCrushTime % 20 == 0) {
                        shouldPlaySound = true;
                    }
                    ++this.firstCrushTime;
                    if (this.firstCrushTime >= this.getMaxCrushTime()) {
                        this.finishCrushing(0, 1, 2);
                        this.firstCrushTime = 0;
                    }
                    this.storage.extractEnergyInternal(40, false);
                }
                crushed = true;
            } else {
                this.firstCrushTime = 0;
            }
            if (this.isDouble) {
                if (canCrushOnSecond) {
                    if (this.storage.getEnergyStored() >= 40) {
                        if (this.secondCrushTime % 20 == 0) {
                            shouldPlaySound = true;
                        }
                        ++this.secondCrushTime;
                        if (this.secondCrushTime >= this.getMaxCrushTime()) {
                            this.finishCrushing(3, 4, 5);
                            this.secondCrushTime = 0;
                        }
                        this.storage.extractEnergyInternal(40, false);
                    }
                    crushed = true;
                } else {
                    this.secondCrushTime = 0;
                }
            }
            if (crushed != this.lastCrushed) {
                IBlockState currState = this.field_145850_b.func_180495_p(this.field_174879_c);
                if ((Boolean)currState.func_177229_b((IProperty)BlockFurnaceDouble.IS_ON) != crushed) {
                    this.field_145850_b.func_175656_a(this.field_174879_c, currState.func_177226_a((IProperty)BlockFurnaceDouble.IS_ON, (Comparable)Boolean.valueOf(crushed)));
                }
                this.lastCrushed = crushed;
            }
            if ((this.lastEnergy != this.storage.getEnergyStored() || this.lastFirstCrush != this.firstCrushTime || this.lastSecondCrush != this.secondCrushTime || this.isAutoSplit != this.lastAutoSplit) && this.sendUpdateWithInterval()) {
                this.lastEnergy = this.storage.getEnergyStored();
                this.lastFirstCrush = this.firstCrushTime;
                this.lastSecondCrush = this.secondCrushTime;
                this.lastAutoSplit = this.isAutoSplit;
            }
            if (shouldPlaySound) {
                this.field_145850_b.func_184148_a(null, (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), SoundHandler.crusher, SoundCategory.BLOCKS, 0.025f, 1.0f);
            }
        }
    }

    @Override
    public boolean isItemValidForSlot(int i, ItemStack stack) {
        return (i == 0 || i == 3) && CrusherRecipeRegistry.getRecipeFromInput(stack) != null;
    }

    public boolean canCrushOn(int theInput, int theFirstOutput, int theSecondOutput) {
        if (StackUtil.isValid(this.slots.getStackInSlot(theInput))) {
            ItemStack outputOne = CrusherRecipeRegistry.getOutputOnes(this.slots.getStackInSlot(theInput));
            ItemStack outputTwo = CrusherRecipeRegistry.getOutputTwos(this.slots.getStackInSlot(theInput));
            if (StackUtil.isValid(outputOne)) {
                if (outputOne.func_77952_i() == Short.MAX_VALUE) {
                    outputOne.func_77964_b(0);
                }
                if (StackUtil.isValid(outputTwo) && outputTwo.func_77952_i() == Short.MAX_VALUE) {
                    outputTwo.func_77964_b(0);
                }
                if ((!StackUtil.isValid(this.slots.getStackInSlot(theFirstOutput)) || this.slots.getStackInSlot(theFirstOutput).func_77969_a(outputOne) && StackUtil.getStackSize(this.slots.getStackInSlot(theFirstOutput)) <= this.slots.getStackInSlot(theFirstOutput).func_77976_d() - StackUtil.getStackSize(outputOne)) && (!StackUtil.isValid(outputTwo) || !StackUtil.isValid(this.slots.getStackInSlot(theSecondOutput)) || this.slots.getStackInSlot(theSecondOutput).func_77969_a(outputTwo) && StackUtil.getStackSize(this.slots.getStackInSlot(theSecondOutput)) <= this.slots.getStackInSlot(theSecondOutput).func_77976_d() - StackUtil.getStackSize(outputTwo))) {
                    return true;
                }
            }
        }
        return false;
    }

    private int getMaxCrushTime() {
        return this.isDouble ? 150 : 100;
    }

    public void finishCrushing(int theInput, int theFirstOutput, int theSecondOutput) {
        ItemStack outputTwo;
        ItemStack outputOne = CrusherRecipeRegistry.getOutputOnes(this.slots.getStackInSlot(theInput));
        if (StackUtil.isValid(outputOne)) {
            if (outputOne.func_77952_i() == Short.MAX_VALUE) {
                outputOne.func_77964_b(0);
            }
            if (!StackUtil.isValid(this.slots.getStackInSlot(theFirstOutput))) {
                this.slots.setStackInSlot(theFirstOutput, outputOne.func_77946_l());
            } else if (this.slots.getStackInSlot(theFirstOutput).func_77973_b() == outputOne.func_77973_b()) {
                this.slots.setStackInSlot(theFirstOutput, StackUtil.addStackSize(this.slots.getStackInSlot(theFirstOutput), StackUtil.getStackSize(outputOne)));
            }
        }
        if (StackUtil.isValid(outputTwo = CrusherRecipeRegistry.getOutputTwos(this.slots.getStackInSlot(theInput)))) {
            int rand;
            if (outputTwo.func_77952_i() == Short.MAX_VALUE) {
                outputTwo.func_77964_b(0);
            }
            if ((rand = this.field_145850_b.field_73012_v.nextInt(100) + 1) <= CrusherRecipeRegistry.getOutputTwoChance(this.slots.getStackInSlot(theInput))) {
                if (!StackUtil.isValid(this.slots.getStackInSlot(theSecondOutput))) {
                    this.slots.setStackInSlot(theSecondOutput, outputTwo.func_77946_l());
                } else if (this.slots.getStackInSlot(theSecondOutput).func_77973_b() == outputTwo.func_77973_b()) {
                    this.slots.setStackInSlot(theSecondOutput, StackUtil.addStackSize(this.slots.getStackInSlot(theSecondOutput), StackUtil.getStackSize(outputTwo)));
                }
            }
        }
        this.slots.setStackInSlot(theInput, StackUtil.addStackSize(this.slots.getStackInSlot(theInput), -1));
    }

    @SideOnly(value=Side.CLIENT)
    public int getEnergyScaled(int i) {
        return this.storage.getEnergyStored() * i / this.storage.getMaxEnergyStored();
    }

    @SideOnly(value=Side.CLIENT)
    public int getFirstTimeToScale(int i) {
        return this.firstCrushTime * i / this.getMaxCrushTime();
    }

    @SideOnly(value=Side.CLIENT)
    public int getSecondTimeToScale(int i) {
        return this.secondCrushTime * i / this.getMaxCrushTime();
    }

    @Override
    public boolean canExtractItem(int slot, ItemStack stack) {
        return slot == 1 || slot == 2 || slot == 4 || slot == 5;
    }

    @Override
    public void onButtonPressed(int buttonID, EntityPlayer player) {
        if (buttonID == 0) {
            this.isAutoSplit = !this.isAutoSplit;
            this.func_70296_d();
        }
    }

    @Override
    public IEnergyStorage getEnergyStorage(EnumFacing facing) {
        return this.storage;
    }
}

