/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.tile.CustomEnergyStorage;
import de.ellpeck.actuallyadditions.mod.tile.IEnergyDisplay;
import de.ellpeck.actuallyadditions.mod.tile.ISharingEnergyProvider;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockMagma;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.energy.IEnergyStorage;

public class TileEntityHeatCollector
extends TileEntityBase
implements ISharingEnergyProvider,
IEnergyDisplay {
    public static final int ENERGY_PRODUCE = 40;
    public static final int BLOCKS_NEEDED = 4;
    public final CustomEnergyStorage storage = new CustomEnergyStorage(30000, 0, 80);
    private int oldEnergy;
    private int disappearTime;

    public TileEntityHeatCollector() {
        super("heatCollector");
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        this.storage.writeToNBT(compound);
        if (type == TileEntityBase.NBTType.SAVE_TILE) {
            compound.func_74768_a("DisappearTime", this.disappearTime);
        }
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        this.storage.readFromNBT(compound);
        if (type == TileEntityBase.NBTType.SAVE_TILE) {
            this.disappearTime = compound.func_74762_e("DisappearTime");
        }
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!this.field_145850_b.field_72995_K) {
            ArrayList<Integer> blocksAround = new ArrayList<Integer>();
            if (40 <= this.storage.getMaxEnergyStored() - this.storage.getEnergyStored()) {
                for (int i = 1; i <= 5; ++i) {
                    BlockPos coords = this.field_174879_c.func_177972_a(WorldUtil.getDirectionBySidesInOrder(i));
                    IBlockState state = this.field_145850_b.func_180495_p(coords);
                    Block block = state.func_177230_c();
                    if ((block == null || this.field_145850_b.func_180495_p(coords).func_185904_a() != Material.field_151587_i || block.func_176201_c(state) != 0) && !(this.field_145850_b.func_180495_p(coords).func_177230_c() instanceof BlockMagma)) continue;
                    blocksAround.add(i);
                }
                if (blocksAround.size() >= 4) {
                    this.storage.receiveEnergyInternal(40, false);
                    this.func_70296_d();
                    ++this.disappearTime;
                    if (this.disappearTime >= 1000) {
                        this.disappearTime = 0;
                        if (this.field_145850_b.field_73012_v.nextInt(200) == 0) {
                            int randomSide = (Integer)blocksAround.get(this.field_145850_b.field_73012_v.nextInt(blocksAround.size()));
                            this.field_145850_b.func_175698_g(this.field_174879_c.func_177972_a(WorldUtil.getDirectionBySidesInOrder(randomSide)));
                        }
                    }
                }
            }
            if (this.oldEnergy != this.storage.getEnergyStored() && this.sendUpdateWithInterval()) {
                this.oldEnergy = this.storage.getEnergyStored();
            }
        }
    }

    @Override
    public CustomEnergyStorage getEnergyStorage() {
        return this.storage;
    }

    @Override
    public boolean needsHoldShift() {
        return false;
    }

    @Override
    public int getEnergyToSplitShare() {
        return this.storage.getEnergyStored();
    }

    @Override
    public boolean doesShareEnergy() {
        return true;
    }

    @Override
    public EnumFacing[] getEnergyShareSides() {
        return EnumFacing.values();
    }

    @Override
    public boolean canShareTo(TileEntity tile) {
        return true;
    }

    @Override
    public IEnergyStorage getEnergyStorage(EnumFacing facing) {
        return this.storage;
    }
}

