/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.util;

import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class ItemStackHandlerCustom
extends ItemStackHandler {
    private boolean tempIgnoreConditions;

    public ItemStackHandlerCustom(int slots) {
        super(slots);
    }

    public void decrStackSize(int slot, int amount) {
        this.setStackInSlot(slot, StackUtil.addStackSize(this.getStackInSlot(slot), -amount));
    }

    public NonNullList<ItemStack> getItems() {
        return this.stacks;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (!StackUtil.isValid(stack)) {
            return StackUtil.getEmpty();
        }
        this.validateSlotIndex(slot);
        ItemStack existing = (ItemStack)this.stacks.get(slot);
        int limit = this.getStackLimit(slot, stack);
        if (StackUtil.isValid(existing)) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.func_190916_E();
        }
        if (limit <= 0) {
            return stack;
        }
        if (!this.tempIgnoreConditions && !this.canInsert(stack, slot)) {
            return stack;
        }
        boolean bl = reachedLimit = stack.func_190916_E() > limit;
        if (!simulate) {
            if (!StackUtil.isValid(existing)) {
                this.stacks.set(slot, (Object)(reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack));
            } else {
                existing.func_190917_f(reachedLimit ? limit : stack.func_190916_E());
            }
            this.onContentsChanged(slot);
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - limit)) : ItemStack.field_190927_a;
    }

    public ItemStack insertItemInternal(int slot, ItemStack stack, boolean simulate) {
        this.tempIgnoreConditions = true;
        ItemStack result = this.insertItem(slot, stack, simulate);
        this.tempIgnoreConditions = false;
        return result;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount <= 0) {
            return StackUtil.getEmpty();
        }
        this.validateSlotIndex(slot);
        ItemStack existing = (ItemStack)this.stacks.get(slot);
        if (!StackUtil.isValid(existing)) {
            return StackUtil.getEmpty();
        }
        int toExtract = Math.min(amount, existing.func_77976_d());
        if (toExtract <= 0) {
            return StackUtil.getEmpty();
        }
        if (!this.tempIgnoreConditions && !this.canExtract(this.getStackInSlot(slot), slot)) {
            return StackUtil.getEmpty();
        }
        if (existing.func_190916_E() <= toExtract) {
            if (!simulate) {
                this.stacks.set(slot, (Object)StackUtil.getEmpty());
                this.onContentsChanged(slot);
                return existing;
            }
            return existing.func_77946_l();
        }
        if (!simulate) {
            this.stacks.set(slot, (Object)ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.func_190916_E() - toExtract)));
            this.onContentsChanged(slot);
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
    }

    public ItemStack extractItemInternal(int slot, int amount, boolean simulate) {
        this.tempIgnoreConditions = true;
        ItemStack result = this.extractItem(slot, amount, simulate);
        this.tempIgnoreConditions = false;
        return result;
    }

    public boolean canInsert(ItemStack stack, int slot) {
        return true;
    }

    public boolean canExtract(ItemStack stack, int slot) {
        return true;
    }
}

