/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.util;

import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.RegistryHandler;
import de.ellpeck.actuallyadditions.mod.blocks.base.ItemBlockBase;
import de.ellpeck.actuallyadditions.mod.creative.CreativeTab;
import de.ellpeck.actuallyadditions.mod.util.IColorProvidingBlock;
import de.ellpeck.actuallyadditions.mod.util.IColorProvidingItem;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import de.ellpeck.actuallyadditions.mod.util.compat.IMCHandler;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public final class ItemUtil {
    public static Item getItemFromName(String name) {
        return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(name));
    }

    public static void registerBlock(Block block, ItemBlockBase itemBlock, String name, boolean addTab) {
        block.func_149663_c("actuallyadditions." + name);
        block.setRegistryName("actuallyadditions", name);
        RegistryHandler.BLOCKS_TO_REGISTER.add(block);
        itemBlock.setRegistryName(block.getRegistryName());
        RegistryHandler.ITEMS_TO_REGISTER.add((Item)itemBlock);
        block.func_149647_a((CreativeTabs)(addTab ? CreativeTab.INSTANCE : null));
        IMCHandler.doBlockIMC(block);
        if (block instanceof IColorProvidingBlock) {
            ActuallyAdditions.proxy.addColoredBlock(block);
        }
    }

    public static void registerItem(Item item, String name, boolean addTab) {
        item.func_77655_b("actuallyadditions." + name);
        item.setRegistryName("actuallyadditions", name);
        RegistryHandler.ITEMS_TO_REGISTER.add(item);
        item.func_77637_a((CreativeTabs)(addTab ? CreativeTab.INSTANCE : null));
        IMCHandler.doItemIMC(item);
        if (item instanceof IColorProvidingItem) {
            ActuallyAdditions.proxy.addColoredItem(item);
        }
    }

    public static boolean contains(ItemStack[] array, ItemStack stack, boolean checkWildcard) {
        return ItemUtil.getPlaceAt(array, stack, checkWildcard) != -1;
    }

    public static int getPlaceAt(ItemStack[] array, ItemStack stack, boolean checkWildcard) {
        return ItemUtil.getPlaceAt(Arrays.asList(array), stack, checkWildcard);
    }

    public static int getPlaceAt(List<ItemStack> list, ItemStack stack, boolean checkWildcard) {
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                if ((StackUtil.isValid(stack) || StackUtil.isValid(list.get(i))) && !ItemUtil.areItemsEqual(stack, list.get(i), checkWildcard)) continue;
                return i;
            }
        }
        return -1;
    }

    public static boolean areItemsEqual(ItemStack stack1, ItemStack stack2, boolean checkWildcard) {
        return StackUtil.isValid(stack1) && StackUtil.isValid(stack2) && (stack1.func_77969_a(stack2) || checkWildcard && stack1.func_77973_b() == stack2.func_77973_b() && (stack1.func_77952_i() == Short.MAX_VALUE || stack2.func_77952_i() == Short.MAX_VALUE));
    }

    public static boolean contains(List<ItemStack> list, ItemStack stack, boolean checkWildcard) {
        return list != null && !list.isEmpty() && ItemUtil.getPlaceAt(list, stack, checkWildcard) != -1;
    }

    public static void addEnchantment(ItemStack stack, Enchantment e, int level) {
        if (!ItemUtil.hasEnchantment(stack, e)) {
            stack.func_77966_a(e, level);
        }
    }

    public static boolean hasEnchantment(ItemStack stack, Enchantment e) {
        NBTTagList ench = stack.func_77986_q();
        if (ench != null) {
            for (int i = 0; i < ench.func_74745_c(); ++i) {
                short id = ench.func_150305_b(i).func_74765_d("id");
                if (id != Enchantment.func_185258_b((Enchantment)e)) continue;
                return true;
            }
        }
        return false;
    }

    public static void removeEnchantment(ItemStack stack, Enchantment e) {
        NBTTagList ench = stack.func_77986_q();
        if (ench != null) {
            for (int i = 0; i < ench.func_74745_c(); ++i) {
                short id = ench.func_150305_b(i).func_74765_d("id");
                if (id != Enchantment.func_185258_b((Enchantment)e)) continue;
                ench.func_74744_a(i);
            }
            if (ench.func_82582_d() && stack.func_77942_o()) {
                stack.func_77978_p().func_82580_o("ench");
            }
        }
    }

    public static boolean canBeStacked(ItemStack stack1, ItemStack stack2) {
        return ItemStack.func_179545_c((ItemStack)stack1, (ItemStack)stack2) && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public static boolean isEnabled(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74767_n("IsEnabled");
    }

    public static void changeEnabled(EntityPlayer player, EnumHand hand) {
        ItemUtil.changeEnabled(player.func_184586_b(hand));
    }

    public static void changeEnabled(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        boolean isEnabled = ItemUtil.isEnabled(stack);
        stack.func_77978_p().func_74757_a("IsEnabled", !isEnabled);
    }
}

