/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.glass.client.core;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import me.ichun.mods.glass.common.GeneralLaymansAestheticSpyingScreen;
import me.ichun.mods.glass.common.block.TerminalPlacement;
import me.ichun.mods.glass.common.tileentity.TileEntityGlassBase;
import me.ichun.mods.glass.common.tileentity.TileEntityGlassMaster;
import me.ichun.mods.glass.common.tileentity.TileEntityGlassTerminal;
import me.ichun.mods.ichunutil.client.model.item.ModelEmpty;
import me.ichun.mods.ichunutil.common.module.worldportals.common.WorldPortals;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;

public class EventHandlerClient {
    public BlockPos clickedPos = BlockPos.field_177992_a;
    public HashMap<String, BlockPos> terminalLocations = new HashMap();
    public HashMap<String, HashSet<TileEntityGlassBase>> activeGLASS = new HashMap();
    public HashSet<String> drawnChannels = new HashSet();
    public HashMap<String, TerminalPlacement> terminalPlacements = new HashMap();
    public HashMap<String, Integer> terminalPlacementCreationTimeout = new HashMap();

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            this.drawnChannels.clear();
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71441_e != null) {
                if (!this.clickedPos.equals((Object)BlockPos.field_177992_a)) {
                    TileEntity te = mc.field_71441_e.func_175625_s(this.clickedPos);
                    if (te instanceof TileEntityGlassBase && ((TileEntityGlassBase)te).active && mc.field_71442_b.func_181040_m()) {
                        TileEntityGlassBase base = (TileEntityGlassBase)te;
                        if (base.fadeoutTime < TileEntityGlassBase.FADEOUT_TIME - TileEntityGlassBase.PROPAGATE_TIME) {
                            base.fadeoutTime = TileEntityGlassBase.FADEOUT_TIME;
                            base.fadePropagate = TileEntityGlassBase.PROPAGATE_TIME;
                            base.fadeDistance = 2;
                            base.fadePropagate();
                        }
                    } else {
                        this.clickedPos = BlockPos.field_177992_a;
                    }
                }
                Iterator<Map.Entry<String, Integer>> ite = this.terminalPlacementCreationTimeout.entrySet().iterator();
                while (ite.hasNext()) {
                    Map.Entry<String, Integer> e = ite.next();
                    e.setValue(e.getValue() - 1);
                    if (e.getValue() >= 0) continue;
                    ite.remove();
                }
            }
        }
    }

    @SubscribeEvent
    public void onModelRegistry(ModelRegistryEvent event) {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)GeneralLaymansAestheticSpyingScreen.blockGlass), (int)0, (ModelResourceLocation)new ModelResourceLocation("generallaymansaestheticspyingscreen:block_glass", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)GeneralLaymansAestheticSpyingScreen.blockGlass), (int)1, (ModelResourceLocation)new ModelResourceLocation("generallaymansaestheticspyingscreen:block_glass_projector", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)GeneralLaymansAestheticSpyingScreen.blockGlass), (int)2, (ModelResourceLocation)new ModelResourceLocation("generallaymansaestheticspyingscreen:block_glass", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)GeneralLaymansAestheticSpyingScreen.blockGlassTerminal), (int)0, (ModelResourceLocation)new ModelResourceLocation("generallaymansaestheticspyingscreen:block_glass_terminal", "inventory"));
    }

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent event) {
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation("generallaymansaestheticspyingscreen:block_glass_terminal", "normal"), (Object)new ModelEmpty(Minecraft.func_71410_x().func_147117_R().func_110572_b("minecraft:blocks/obsidian")));
    }

    @SubscribeEvent
    public void onClientDisconnect(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        Minecraft.func_71410_x().func_152344_a(this::disconnectFromServer);
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (event.getWorld().field_72995_K) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71441_e != null) {
                Iterator<Map.Entry<String, BlockPos>> ite = this.terminalLocations.entrySet().iterator();
                while (ite.hasNext()) {
                    Map.Entry<String, BlockPos> e = ite.next();
                    TileEntity te = mc.field_71441_e.func_175625_s(e.getValue());
                    if (te instanceof TileEntityGlassTerminal) continue;
                    ite.remove();
                }
                Iterator<Map.Entry<String, HashSet<TileEntityGlassBase>>> ite1 = this.activeGLASS.entrySet().iterator();
                while (ite1.hasNext()) {
                    Map.Entry<String, HashSet<TileEntityGlassBase>> e = ite1.next();
                    e.getValue().removeIf(base -> base.func_145831_w() != mc.field_71441_e || !base.active);
                    if (!e.getValue().isEmpty()) continue;
                    ite1.remove();
                }
            } else {
                this.terminalLocations.clear();
                this.activeGLASS.clear();
                this.terminalPlacements.forEach((k, v) -> WorldPortals.eventHandlerClient.renderGlobalProxy.releaseViewFrustum(v.getPair()));
                this.terminalPlacements.clear();
                this.terminalPlacementCreationTimeout.clear();
            }
        }
    }

    public TerminalPlacement getTerminalPlacement(String channel) {
        if (!this.terminalPlacementCreationTimeout.containsKey(channel)) {
            if (this.terminalPlacements.containsKey(channel)) {
                return this.terminalPlacements.get(channel);
            }
            if (this.terminalLocations.containsKey(channel)) {
                Minecraft mc = Minecraft.func_71410_x();
                TileEntity te = mc.field_71441_e.func_175625_s(this.terminalLocations.get(channel));
                if (te instanceof TileEntityGlassTerminal) {
                    TileEntityGlassTerminal terminal = (TileEntityGlassTerminal)te;
                    TileEntityGlassMaster master = null;
                    HashSet<TileEntityGlassBase> activeGlasses = this.activeGLASS.get(channel);
                    for (TileEntityGlassBase base : activeGlasses) {
                        if (!base.active || base.distance != 1 || !base.channel.equalsIgnoreCase(channel) || !(base instanceof TileEntityGlassMaster)) continue;
                        master = (TileEntityGlassMaster)base;
                        break;
                    }
                    if (master != null) {
                        TerminalPlacement placement = new TerminalPlacement((World)mc.field_71441_e, master, terminal, this.getActiveGlass(channel));
                        this.terminalPlacements.put(channel, placement);
                        return placement;
                    }
                } else {
                    this.terminalLocations.remove(channel);
                }
            }
            this.terminalPlacementCreationTimeout.put(channel, 13);
        }
        return null;
    }

    public HashSet<TileEntityGlassBase> getActiveGlass(String channel) {
        if (!channel.isEmpty() && this.activeGLASS.containsKey(channel)) {
            return this.activeGLASS.get(channel);
        }
        return new HashSet<TileEntityGlassBase>();
    }

    public void addActiveGlass(TileEntityGlassBase base, String channel) {
        Minecraft.func_71410_x().func_152344_a(() -> this.addGlass(base, channel));
    }

    private void addGlass(TileEntityGlassBase base, String channel) {
        HashSet bases = this.activeGLASS.computeIfAbsent(channel, v -> new HashSet());
        bases.add(base);
        if (this.terminalPlacements.containsKey(channel)) {
            this.terminalPlacements.get(channel).addActiveGlass(base);
        }
    }

    public void removeActiveGlass(TileEntityGlassBase base, String channel) {
        Minecraft.func_71410_x().func_152344_a(() -> this.removeGlass(base, channel));
    }

    private void removeGlass(TileEntityGlassBase base, String channel) {
        HashSet<TileEntityGlassBase> bases = this.activeGLASS.get(channel);
        if (bases != null) {
            bases.remove((Object)base);
            if (bases.isEmpty()) {
                this.activeGLASS.remove(channel);
                if (this.terminalPlacements.containsKey(channel)) {
                    WorldPortals.eventHandlerClient.renderGlobalProxy.releaseViewFrustum(this.terminalPlacements.get(channel).getPair());
                }
                this.terminalPlacements.remove(channel);
                this.terminalPlacementCreationTimeout.remove(channel);
            } else if (this.terminalPlacements.containsKey(channel)) {
                this.terminalPlacements.get(channel).removeActiveGlass(base);
            }
        }
    }

    public void disconnectFromServer() {
        this.terminalLocations.clear();
        this.activeGLASS.clear();
        this.terminalPlacements.forEach((k, v) -> WorldPortals.eventHandlerClient.renderGlobalProxy.releaseViewFrustum(v.getPair()));
        this.terminalPlacements.clear();
        this.terminalPlacementCreationTimeout.clear();
    }
}

