/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.glass.common.block;

import java.util.HashSet;
import java.util.Random;
import javax.annotation.Nullable;
import me.ichun.mods.glass.client.gui.GuiChannelSetterProjector;
import me.ichun.mods.glass.client.gui.GuiProjectorSetter;
import me.ichun.mods.glass.common.GeneralLaymansAestheticSpyingScreen;
import me.ichun.mods.glass.common.tileentity.TileEntityGlassBase;
import me.ichun.mods.glass.common.tileentity.TileEntityGlassMaster;
import me.ichun.mods.glass.common.tileentity.TileEntityGlassWireless;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockGlass
extends net.minecraft.block.BlockGlass
implements ITileEntityProvider {
    public static final PropertyBool MASTER = PropertyBool.func_177716_a((String)"master");
    public static final PropertyBool WIRELESS = PropertyBool.func_177716_a((String)"wireless");

    public BlockGlass(Material materialIn, boolean ignoreSimilarity) {
        super(materialIn, ignoreSimilarity);
        this.func_149647_a(CreativeTabs.field_78028_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)MASTER, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)WIRELESS, (Comparable)Boolean.valueOf(false)));
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntityGlassMaster && !((TileEntityGlassBase)te).active) {
            if (worldIn.field_72995_K) {
                this.openGui((TileEntityGlassMaster)te);
            }
            return true;
        }
        if (te instanceof TileEntityGlassWireless && !((TileEntityGlassBase)te).active) {
            if (worldIn.field_72995_K) {
                this.openGui((TileEntityGlassWireless)te);
            }
            return true;
        }
        return false;
    }

    public void func_180649_a(World worldIn, BlockPos pos, EntityPlayer playerIn) {
        TileEntity te;
        if (worldIn.field_72995_K && (te = worldIn.func_175625_s(pos)) instanceof TileEntityGlassBase) {
            TileEntityGlassBase base = (TileEntityGlassBase)te;
            if (base.active) {
                GeneralLaymansAestheticSpyingScreen.eventHandlerClient.clickedPos = pos;
                base.fadeoutTime = TileEntityGlassBase.FADEOUT_TIME;
                base.fadePropagate = TileEntityGlassBase.PROPAGATE_TIME;
                base.fadeDistance = 2;
                base.fadePropagate();
            }
        }
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return meta == 1 ? new TileEntityGlassMaster() : (meta == 2 ? new TileEntityGlassWireless() : new TileEntityGlassBase());
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        super.func_180663_b(worldIn, pos, state);
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        items.add((Object)new ItemStack((Block)this, 1, 1));
        items.add((Object)new ItemStack((Block)this, 1, 2));
        items.add((Object)new ItemStack((Block)this, 1, 0));
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        TileEntity tileentity;
        if (!worldIn.field_72995_K && (tileentity = worldIn.func_175625_s(pos)) instanceof TileEntityGlassBase) {
            TileEntityGlassBase base2;
            TileEntity te;
            BlockPos pos1;
            HashSet propagationFaces;
            TileEntityGlassBase base = (TileEntityGlassBase)tileentity;
            TileEntity tileentity1 = worldIn.func_175625_s(fromPos);
            if (tileentity1 instanceof TileEntityGlassBase) {
                TileEntityGlassBase base1 = (TileEntityGlassBase)tileentity1;
                if (base.active) {
                    propagationFaces = new HashSet();
                    for (EnumFacing facing : base.activeFaces) {
                        propagationFaces.addAll(TileEntityGlassBase.PROPAGATION_FACES.get(facing));
                    }
                    for (EnumFacing facing : propagationFaces) {
                        pos1 = pos.func_177967_a(facing, -1);
                        te = worldIn.func_175625_s(pos1);
                        if (!(te instanceof TileEntityGlassBase)) continue;
                        base2 = (TileEntityGlassBase)te;
                        if (!base2.active || !base2.channel.equals(base.channel) || base2.distance >= base.distance) continue;
                        base.checkFacesToTurnOn(base2);
                        if (base1.active && !base1.channel.equals(base.channel)) continue;
                        base1.bePropagatedTo(base, base.channel, base.active);
                    }
                }
            }
            if (blockIn == this && base.active) {
                int distance = base.distance;
                propagationFaces = new HashSet();
                for (EnumFacing facing : base.activeFaces) {
                    propagationFaces.addAll(TileEntityGlassBase.PROPAGATION_FACES.get(facing));
                }
                for (EnumFacing facing : propagationFaces) {
                    pos1 = pos.func_177972_a(facing);
                    te = worldIn.func_175625_s(pos1);
                    if (!(te instanceof TileEntityGlassBase)) continue;
                    TileEntityGlassBase base1 = (TileEntityGlassBase)te;
                    if (!base1.active || !base1.channel.equalsIgnoreCase(base.channel) || base1.distance >= distance) continue;
                    distance = base1.distance;
                }
                if (distance == base.distance) {
                    base.bePropagatedTo(base, base.channel, false);
                } else {
                    for (EnumFacing facing : propagationFaces) {
                        pos1 = pos.func_177967_a(facing, -1);
                        te = worldIn.func_175625_s(pos1);
                        if (!(te instanceof TileEntityGlassBase)) continue;
                        base2 = (TileEntityGlassBase)te;
                        if (!base2.active || !base2.channel.equals(base.channel) || base2.distance >= base.distance) continue;
                        base.checkFacesToTurnOn(base2);
                    }
                }
            }
            if (base instanceof TileEntityGlassMaster) {
                TileEntityGlassMaster player = (TileEntityGlassMaster)base;
                boolean flag = worldIn.func_175640_z(pos);
                if (player.powered != flag) {
                    player.changeRedstoneState(flag);
                    player.powered = flag;
                }
            }
        }
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{MASTER, WIRELESS});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)MASTER, (Comparable)Boolean.valueOf(meta == 1)).func_177226_a((IProperty)WIRELESS, (Comparable)Boolean.valueOf(meta == 2));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WIRELESS) != false ? 2 : ((Boolean)state.func_177229_b((IProperty)MASTER) != false ? 1 : 0);
    }

    @SideOnly(value=Side.CLIENT)
    public void openGui(TileEntityGlassMaster master) {
        FMLClientHandler.instance().displayGuiScreen((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (GuiScreen)new GuiChannelSetterProjector(master));
    }

    @SideOnly(value=Side.CLIENT)
    public void openGui(TileEntityGlassWireless master) {
        FMLClientHandler.instance().displayGuiScreen((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (GuiScreen)new GuiProjectorSetter(master));
    }
}

