/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.glass.common.block;

import java.util.HashSet;
import me.ichun.mods.glass.client.render.TileEntityGlassRenderer;
import me.ichun.mods.glass.client.sound.SoundGlassAmbience;
import me.ichun.mods.glass.common.GeneralLaymansAestheticSpyingScreen;
import me.ichun.mods.glass.common.tileentity.TileEntityGlassBase;
import me.ichun.mods.glass.common.tileentity.TileEntityGlassMaster;
import me.ichun.mods.glass.common.tileentity.TileEntityGlassTerminal;
import me.ichun.mods.ichunutil.common.module.worldportals.common.portal.WorldPortal;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class TerminalPlacement
extends WorldPortal {
    public TileEntityGlassMaster master;
    public TileEntityGlassTerminal terminal;
    public HashSet<TileEntityGlassBase> activeBlocks;
    public TileEntityGlassBase renderCaller;
    public boolean playedAmbience;

    public TerminalPlacement(World world) {
        super(world);
        this.master = null;
        this.terminal = null;
        this.activeBlocks = null;
    }

    public TerminalPlacement(World world, TileEntityGlassMaster master, TileEntityGlassTerminal terminal, HashSet<TileEntityGlassBase> activeBlocks) {
        super(world, new Vec3d((Vec3i)master.func_174877_v()).func_72441_c(0.5, 0.5, 0.5), master.placingFace, EnumFacing.UP, 0.0f, 0.0f);
        this.master = master;
        this.terminal = terminal;
        this.activeBlocks = activeBlocks;
        TerminalPlacement pair = new TerminalPlacement(world);
        pair.setPosition(new Vec3d((Vec3i)terminal.func_174877_v().func_177967_a(terminal.facing, -1)).func_72441_c(0.5, 0.5, 0.5));
        pair.setFace(terminal.facing.func_176734_d(), EnumFacing.UP);
        this.setPair(pair);
        pair.setPair(this);
        this.generateActiveFaces();
    }

    public float getPlaneOffset() {
        return 0.0f;
    }

    public boolean canCollideWithBorders() {
        return false;
    }

    public String owner() {
        return "GLASS";
    }

    public void drawPlane(float partialTick) {
        if (!this.playedAmbience) {
            this.playedAmbience = true;
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new SoundGlassAmbience(GeneralLaymansAestheticSpyingScreen.soundAmb, SoundCategory.BLOCKS, 0.015f, 0.6f, this));
        }
        for (TileEntityGlassBase base : this.activeBlocks) {
            if (!base.active || base.lastDraw <= 0) continue;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(base.func_174877_v().func_177958_n() - this.renderCaller.func_174877_v().func_177958_n()), (float)(base.func_174877_v().func_177956_o() - this.renderCaller.func_174877_v().func_177956_o()), (float)(base.func_174877_v().func_177952_p() - this.renderCaller.func_174877_v().func_177952_p()));
            TileEntityGlassRenderer.drawPlanes(base, 1.0f, 1.0f, 1.0f, 1.0f, 0.501, partialTick);
            GlStateManager.func_179121_F();
        }
    }

    public void generateActiveFaces() {
        this.renderAll = false;
        HashSet<EnumFacing> faces = new HashSet<EnumFacing>();
        for (TileEntityGlassBase base : this.activeBlocks) {
            if (base instanceof TileEntityGlassMaster && !((TileEntityGlassMaster)base).wirelessPos.isEmpty()) {
                this.renderAll = true;
                break;
            }
            if (!base.active) continue;
            faces.addAll(base.activeFaces);
            if (faces.size() <= 1) continue;
            this.renderAll = true;
            break;
        }
    }

    public void addActiveGlass(TileEntityGlassBase base) {
        this.generateActiveFaces();
    }

    public void removeActiveGlass(TileEntityGlassBase base) {
        this.generateActiveFaces();
    }

    public boolean canTeleportEntities() {
        return false;
    }

    public <T extends WorldPortal> T createFakeInstance(NBTTagCompound tag) {
        return null;
    }
}

