/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.glass.common.tileentity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import me.ichun.mods.glass.common.GeneralLaymansAestheticSpyingScreen;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityGlassBase
extends TileEntity
implements ITickable {
    public static final HashMap<EnumFacing, ArrayList<EnumFacing>> PROPAGATION_FACES = new HashMap();
    public static int FADEOUT_TIME;
    public static int PROPAGATE_TIME;
    public int fadeoutTime = 0;
    public ArrayList<EnumFacing> activeFaces = new ArrayList();
    public boolean active = false;
    public String channel = "";
    public int distance = 0;
    public int propagateTime = 0;
    public int fadePropagate;
    public int fadeDistance;
    public int lastDraw;

    public void onLoad() {
        if (this.func_145831_w().field_72995_K && this.active && !this.channel.isEmpty()) {
            GeneralLaymansAestheticSpyingScreen.eventHandlerClient.addActiveGlass(this, this.channel);
        }
    }

    public void onChunkUnload() {
        if (this.func_145831_w().field_72995_K && this.active && !this.channel.isEmpty()) {
            GeneralLaymansAestheticSpyingScreen.eventHandlerClient.removeActiveGlass(this, this.channel);
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        boolean flag;
        boolean bl = flag = oldState != newState;
        if (flag && world.field_72995_K && this.active && !this.channel.isEmpty()) {
            GeneralLaymansAestheticSpyingScreen.eventHandlerClient.removeActiveGlass(this, this.channel);
        }
        return flag;
    }

    public void func_73660_a() {
        if (this.fadeoutTime > 0) {
            --this.fadeoutTime;
            if (this.fadeoutTime == 0) {
                if (!this.active) {
                    this.activeFaces.clear();
                }
                if (this.fadeDistance > 0) {
                    this.fadeDistance = 0;
                }
            }
        }
        if (this.propagateTime > 0) {
            --this.propagateTime;
            if (!this.field_145850_b.field_72995_K && this.propagateTime == 0) {
                this.propagate();
            }
        }
        if (this.fadePropagate > 0) {
            --this.fadePropagate;
            if (this.field_145850_b.field_72995_K && this.fadePropagate == 0) {
                this.fadePropagate();
            }
        }
        if (this.lastDraw > 0) {
            --this.lastDraw;
        }
    }

    public void fadePropagate() {
        if (this.fadeDistance <= 0 || !this.active) {
            return;
        }
        HashSet propagationFaces = new HashSet();
        for (EnumFacing facing : this.activeFaces) {
            propagationFaces.addAll(PROPAGATION_FACES.get(facing));
        }
        for (EnumFacing facing : propagationFaces) {
            BlockPos pos = this.func_174877_v().func_177972_a(facing);
            TileEntity te = this.func_145831_w().func_175625_s(pos);
            if (!(te instanceof TileEntityGlassBase)) continue;
            TileEntityGlassBase base = (TileEntityGlassBase)te;
            if (!base.active || !base.channel.equalsIgnoreCase(this.channel) || base.fadeDistance > this.fadeDistance) continue;
            base.fadeoutTime = FADEOUT_TIME;
            base.fadePropagate = PROPAGATE_TIME;
            base.fadeDistance = this.fadeDistance - 1;
        }
    }

    public boolean canPropagate() {
        return this.distance < 40;
    }

    public void propagate() {
        if (!this.canPropagate()) {
            return;
        }
        HashSet propagationFaces = new HashSet();
        for (EnumFacing facing : this.activeFaces) {
            propagationFaces.addAll(PROPAGATION_FACES.get(facing));
        }
        for (EnumFacing facing : propagationFaces) {
            BlockPos pos = this.func_174877_v().func_177972_a(facing);
            TileEntity te = this.func_145831_w().func_175625_s(pos);
            if (!(te instanceof TileEntityGlassBase)) continue;
            ((TileEntityGlassBase)te).bePropagatedTo(this, this.channel, this.active);
        }
        if (!this.active) {
            this.channel = "";
            this.distance = 0;
            IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
            this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 3);
        }
    }

    public void bePropagatedTo(TileEntityGlassBase base, String newChannel, boolean activate) {
        IBlockState state;
        boolean flag = false;
        if (this.active && activate && this.channel.equalsIgnoreCase(newChannel) && this.distance > base.distance + 1) {
            this.distance = base.distance + 1;
            this.checkFacesToTurnOn(base);
            flag = true;
        }
        if (activate && !this.active && (this.distance > base.distance || this.distance == 0)) {
            this.active = true;
            this.channel = newChannel;
            this.distance = base.distance + 1;
            this.checkFacesToTurnOn(base);
            flag = true;
        }
        if (!activate && this.active && this.channel.equalsIgnoreCase(newChannel)) {
            if (this.distance > base.distance || base == this) {
                this.active = false;
                flag = true;
            } else {
                this.propagateTime = PROPAGATE_TIME + 1;
                state = this.func_145831_w().func_180495_p(this.func_174877_v());
                this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 3);
            }
        }
        if (flag) {
            this.fadeoutTime = FADEOUT_TIME;
            this.propagateTime = PROPAGATE_TIME;
            state = this.func_145831_w().func_180495_p(this.func_174877_v());
            this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 3);
        }
    }

    public void checkFacesToTurnOn(TileEntityGlassBase origin) {
        if (origin != this) {
            this.activeFaces.clear();
            this.activeFaces.addAll(origin.activeFaces);
            if (this.activeFaces.size() > 1) {
                for (int i = this.activeFaces.size() - 1; i >= 0; --i) {
                    EnumFacing facing = this.activeFaces.get(i);
                    BlockPos facePos = this.func_174877_v().func_177967_a(facing, -1);
                    TileEntity te = this.func_145831_w().func_175625_s(facePos);
                    if (te instanceof TileEntityGlassBase && ((TileEntityGlassBase)te).active && ((TileEntityGlassBase)te).channel.equalsIgnoreCase(this.channel) && ((TileEntityGlassBase)te).distance < this.distance) {
                        this.activeFaces.remove(i);
                        continue;
                    }
                    facePos = this.func_174877_v().func_177972_a(facing);
                    te = this.func_145831_w().func_175625_s(facePos);
                    if (!(te instanceof TileEntityGlassBase) || !((TileEntityGlassBase)te).active || !((TileEntityGlassBase)te).channel.equalsIgnoreCase(this.channel) || ((TileEntityGlassBase)te).distance >= this.distance) continue;
                    this.activeFaces.remove(i);
                }
            }
            HashSet<EnumFacing> newFaces = new HashSet<EnumFacing>();
            for (EnumFacing facing : this.activeFaces) {
                EnumFacing newFace;
                Object originPos;
                BlockPos facePos = this.func_174877_v().func_177972_a(facing);
                TileEntity te = this.func_145831_w().func_175625_s(facePos);
                if (te instanceof TileEntityGlassBase) {
                    originPos = origin.func_174877_v().func_177972_a(facing);
                    newFace = EnumFacing.func_176737_a((float)(originPos.func_177958_n() - facePos.func_177958_n()), (float)(originPos.func_177956_o() - facePos.func_177956_o()), (float)(originPos.func_177952_p() - facePos.func_177952_p()));
                    newFaces.add(newFace);
                    continue;
                }
                facePos = this.func_174877_v().func_177967_a(facing, -1);
                te = this.func_145831_w().func_175625_s(facePos);
                if (!(te instanceof TileEntityGlassBase)) continue;
                if (origin.func_174877_v().func_177956_o() != this.func_174877_v().func_177956_o()) {
                    for (EnumFacing newFacing : PROPAGATION_FACES.get(facing)) {
                        if (newFacing.func_176740_k() == EnumFacing.Axis.Y) continue;
                        BlockPos newPos = this.func_174877_v().func_177972_a(newFacing);
                        TileEntity te1 = this.func_145831_w().func_175625_s(newPos);
                        if (!(te1 instanceof TileEntityGlassBase) || !((TileEntityGlassBase)te1).activeFaces.contains(facing)) continue;
                        origin = (TileEntityGlassBase)te1;
                    }
                }
                originPos = origin.func_174877_v().func_177967_a(facing, -1);
                newFace = EnumFacing.func_176737_a((float)(facePos.func_177958_n() - originPos.func_177958_n()), (float)(facePos.func_177956_o() - originPos.func_177956_o()), (float)(facePos.func_177952_p() - originPos.func_177952_p()));
                newFaces.add(newFace);
            }
            this.activeFaces.addAll(newFaces);
            IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
            this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 3);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("activeFaces", this.activeFaces.size());
        for (int i = 0; i < this.activeFaces.size(); ++i) {
            tag.func_74768_a("activeFace_" + i, this.activeFaces.get(i).func_176745_a());
        }
        tag.func_74757_a("active", this.active);
        tag.func_74778_a("channel", this.channel);
        tag.func_74768_a("distance", this.distance);
        tag.func_74768_a("propagateTime", this.propagateTime);
        tag.func_74768_a("fadeoutTime", this.fadeoutTime);
        return tag;
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.activeFaces.clear();
        int faceCount = tag.func_74762_e("activeFaces");
        for (int i = 0; i < faceCount; ++i) {
            this.activeFaces.add(EnumFacing.func_82600_a((int)tag.func_74762_e("activeFace_" + i)));
        }
        this.active = tag.func_74767_n("active");
        this.channel = tag.func_74779_i("channel");
        this.distance = tag.func_74762_e("distance");
        this.propagateTime = tag.func_74762_e("propagateTime");
        this.fadeoutTime = tag.func_74762_e("fadeoutTime");
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.onChunkUnload();
        this.func_145839_a(pkt.func_148857_g());
        this.onLoad();
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.onChunkUnload();
        this.func_145839_a(tag);
        this.onLoad();
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.func_174877_v().func_177982_a(-1, -1, -1), this.func_174877_v().func_177982_a(2, 2, 2));
    }

    static {
        for (EnumFacing face : EnumFacing.field_82609_l) {
            ArrayList faces = PROPAGATION_FACES.computeIfAbsent(face, v -> new ArrayList());
            for (EnumFacing face1 : EnumFacing.field_82609_l) {
                if (face1.func_176740_k().equals((Object)face.func_176740_k())) continue;
                faces.add(face1);
            }
        }
        FADEOUT_TIME = 12;
        PROPAGATE_TIME = 2;
    }
}

