/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.colour;

import codechicken.lib.colour.ColourRGBA;
import codechicken.lib.config.ConfigTag;
import codechicken.lib.math.MathHelper;
import codechicken.lib.util.Copyable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class Colour
implements Copyable<Colour> {
    public static ConfigTag.IConfigType<Colour> configRGB = new ConfigTag.IConfigType<Colour>(){
        private final Pattern patternRGB = Pattern.compile("(\\d+),(\\d+),(\\d+)");

        @Override
        public String configValue(Colour entry) {
            String s = Long.toString((long)entry.rgb() << 32 >>> 32, 16);
            while (s.length() < 6) {
                s = "0" + s;
            }
            return "0x" + s.toUpperCase();
        }

        @Override
        public Colour valueOf(String text) throws Exception {
            Matcher matcherRGB = this.patternRGB.matcher(text.replaceAll("\\s", ""));
            if (matcherRGB.matches()) {
                return new ColourRGBA(Integer.parseInt(matcherRGB.group(1)), Integer.parseInt(matcherRGB.group(2)), Integer.parseInt(matcherRGB.group(3)), 255);
            }
            int hex = (int)Long.parseLong(text.replace("0x", ""), 16);
            return new ColourRGBA(hex << 8 | 0xFF);
        }
    };
    public byte r;
    public byte g;
    public byte b;
    public byte a;

    public Colour(int r, int g, int b, int a) {
        this.r = (byte)r;
        this.g = (byte)g;
        this.b = (byte)b;
        this.a = (byte)a;
    }

    public Colour(Colour colour) {
        this.r = colour.r;
        this.g = colour.g;
        this.b = colour.b;
        this.a = colour.a;
    }

    @SideOnly(value=Side.CLIENT)
    public void glColour() {
        GlStateManager.func_179131_c((float)((float)(this.r & 0xFF) / 255.0f), (float)((float)(this.g & 0xFF) / 255.0f), (float)((float)(this.b & 0xFF) / 255.0f), (float)((float)(this.a & 0xFF) / 255.0f));
    }

    @SideOnly(value=Side.CLIENT)
    public void glColour(int a) {
        GlStateManager.func_179131_c((float)((float)(this.r & 0xFF) / 255.0f), (float)((float)(this.g & 0xFF) / 255.0f), (float)((float)(this.b & 0xFF) / 255.0f), (float)((float)a / 255.0f));
    }

    public abstract int pack();

    public abstract float[] packArray();

    public String toString() {
        return this.getClass().getSimpleName() + "[0x" + Integer.toHexString(this.pack()).toUpperCase() + "]";
    }

    public Colour add(Colour colour2) {
        this.a = (byte)(this.a + colour2.a);
        this.r = (byte)(this.r + colour2.r);
        this.g = (byte)(this.g + colour2.g);
        this.b = (byte)(this.b + colour2.b);
        return this;
    }

    public Colour sub(Colour colour2) {
        int ia = (this.a & 0xFF) - (colour2.a & 0xFF);
        int ir = (this.r & 0xFF) - (colour2.r & 0xFF);
        int ig = (this.g & 0xFF) - (colour2.g & 0xFF);
        int ib = (this.b & 0xFF) - (colour2.b & 0xFF);
        this.a = (byte)(ia < 0 ? 0 : ia);
        this.r = (byte)(ir < 0 ? 0 : ir);
        this.g = (byte)(ig < 0 ? 0 : ig);
        this.b = (byte)(ib < 0 ? 0 : ib);
        return this;
    }

    public Colour invert() {
        this.a = (byte)(255 - (this.a & 0xFF));
        this.r = (byte)(255 - (this.r & 0xFF));
        this.g = (byte)(255 - (this.g & 0xFF));
        this.b = (byte)(255 - (this.b & 0xFF));
        return this;
    }

    public Colour multiply(Colour colour2) {
        this.a = (byte)((double)(this.a & 0xFF) * ((double)(colour2.a & 0xFF) / 255.0));
        this.r = (byte)((double)(this.r & 0xFF) * ((double)(colour2.r & 0xFF) / 255.0));
        this.g = (byte)((double)(this.g & 0xFF) * ((double)(colour2.g & 0xFF) / 255.0));
        this.b = (byte)((double)(this.b & 0xFF) * ((double)(colour2.b & 0xFF) / 255.0));
        return this;
    }

    public Colour scale(double d) {
        this.a = (byte)((double)(this.a & 0xFF) * d);
        this.r = (byte)((double)(this.r & 0xFF) * d);
        this.g = (byte)((double)(this.g & 0xFF) * d);
        this.b = (byte)((double)(this.b & 0xFF) * d);
        return this;
    }

    public Colour interpolate(Colour colour2, double d) {
        return this.add(colour2.copy().sub(this).scale(d));
    }

    public Colour multiplyC(double d) {
        this.r = (byte)MathHelper.clip((double)(this.r & 0xFF) * d, 0.0, 255.0);
        this.g = (byte)MathHelper.clip((double)(this.g & 0xFF) * d, 0.0, 255.0);
        this.b = (byte)MathHelper.clip((double)(this.b & 0xFF) * d, 0.0, 255.0);
        return this;
    }

    @Override
    public abstract Colour copy();

    public int rgb() {
        return (this.r & 0xFF) << 16 | (this.g & 0xFF) << 8 | this.b & 0xFF;
    }

    public int argb() {
        return (this.a & 0xFF) << 24 | (this.r & 0xFF) << 16 | (this.g & 0xFF) << 8 | this.b & 0xFF;
    }

    public int rgba() {
        return (this.r & 0xFF) << 24 | (this.g & 0xFF) << 16 | (this.b & 0xFF) << 8 | this.a & 0xFF;
    }

    public abstract Colour set(int var1);

    public Colour set(Colour colour) {
        this.r = colour.r;
        this.g = colour.g;
        this.b = colour.b;
        this.a = colour.a;
        return this;
    }

    public Colour set(double r, double g, double b, double a) {
        return this.set((int)(255.0 * r), (int)(255.0 * g), (int)(255.0 * b), (int)(255.0 * a));
    }

    public Colour set(int r, int g, int b, int a) {
        this.r = (byte)r;
        this.g = (byte)g;
        this.b = (byte)b;
        this.a = (byte)a;
        return this;
    }

    public static int[] unpack(int colour) {
        return new int[]{colour >> 24 & 0xFF, colour >> 16 & 0xFF, colour >> 8 & 0xFF, colour & 0xFF};
    }

    public static int pack(int[] data) {
        return (data[0] & 0xFF) << 24 | (data[1] & 0xFF) << 16 | (data[2] & 0xFF) << 8 | data[3] & 0xFF;
    }

    public float[] getRGBA() {
        return new float[]{(float)this.r / 255.0f, (float)this.g / 255.0f, (float)this.b / 255.0f, (float)this.a / 255.0f};
    }

    public float[] getARGB() {
        return new float[]{(float)this.a / 255.0f, (float)this.r / 255.0f, (float)this.g / 255.0f, (float)this.b / 255.0f};
    }

    public static int packRGBA(byte r, byte g, byte b, byte a) {
        return (r & 0xFF) << 24 | (g & 0xFF) << 16 | (b & 0xFF) << 8 | a & 0xFF;
    }

    public static int packARGB(byte r, byte g, byte b, byte a) {
        return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public static int packRGBA(int r, int g, int b, int a) {
        return r << 24 | g << 16 | b << 8 | a;
    }

    public static int packARGB(int r, int g, int b, int a) {
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static int packRGBA(double r, double g, double b, double a) {
        return (int)(r * 255.0) << 24 | (int)(g * 255.0) << 16 | (int)(b * 255.0) << 8 | (int)(a * 255.0);
    }

    public static int packARGB(double r, double g, double b, double a) {
        return (int)(a * 255.0) << 24 | (int)(r * 255.0) << 16 | (int)(g * 255.0) << 8 | (int)(b * 255.0);
    }

    public static int packRGBA(float[] data) {
        return Colour.packRGBA(data[0], data[1], data[2], data[3]);
    }

    public static int packARGB(float[] data) {
        return Colour.packARGB(data[0], data[1], data[2], data[3]);
    }

    public static void glColourRGBA(int colour) {
        float r = (float)(colour >> 24 & 0xFF) / 255.0f;
        float g = (float)(colour >> 16 & 0xFF) / 255.0f;
        float b = (float)(colour >> 8 & 0xFF) / 255.0f;
        float a = (float)(colour & 0xFF) / 255.0f;
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)a);
    }

    public static void glColourARGB(int colour) {
        float r = (float)(colour >> 16 & 0xFF) / 255.0f;
        float g = (float)(colour >> 8 & 0xFF) / 255.0f;
        float b = (float)(colour & 0xFF) / 255.0f;
        float a = (float)(colour >> 24 & 0xFF) / 255.0f;
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)a);
    }

    public boolean equals(Colour colour) {
        return colour != null && this.rgba() == colour.rgba();
    }
}

