/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.util;

import java.util.function.Consumer;
import java.util.function.Predicate;

public class LambdaUtils {
    public static <T> boolean forEach(Iterable<T> iterable, Predicate<T> predicate) {
        for (T e : iterable) {
            if (predicate.test(e)) continue;
            return false;
        }
        return true;
    }

    public static <E> void forEach(E[] elements, Consumer<E> consumer) {
        for (E element : elements) {
            consumer.accept(element);
        }
    }

    public static <E> void checkArgument(E argument, String log, Predicate<E> predicate) {
        if (predicate.test(argument)) {
            throw new RuntimeException("Argument check failed! Reason: " + log);
        }
    }
}

