/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui;

import java.awt.Color;
import java.awt.Rectangle;
import mezz.jei.Internal;
import mezz.jei.gui.GuiHelper;
import mezz.jei.gui.elements.GuiIconButton;
import mezz.jei.input.IPaged;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;

public class PageNavigation {
    private final IPaged paged;
    private final GuiButton nextButton;
    private final GuiButton backButton;
    private final boolean hideOnSinglePage;
    private String pageNumDisplayString = "1/1";
    private int pageNumDisplayX;
    private int pageNumDisplayY;
    private Rectangle area = new Rectangle();

    public PageNavigation(IPaged paged, boolean hideOnSinglePage) {
        this.paged = paged;
        GuiHelper guiHelper = Internal.getHelpers().getGuiHelper();
        this.nextButton = new GuiIconButton(0, guiHelper.getArrowNext());
        this.backButton = new GuiIconButton(1, guiHelper.getArrowPrevious());
        this.hideOnSinglePage = hideOnSinglePage;
    }

    public void updateBounds(Rectangle area) {
        this.area = area;
        int buttonSize = area.height;
        this.nextButton.field_146128_h = area.x + area.width - buttonSize;
        this.nextButton.field_146129_i = area.y;
        this.nextButton.field_146120_f = this.nextButton.field_146121_g = buttonSize;
        this.backButton.field_146128_h = area.x;
        this.backButton.field_146129_i = area.y;
        this.backButton.field_146120_f = this.backButton.field_146121_g = buttonSize;
    }

    public void updatePageState(int pageNum, int pageCount) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        this.pageNumDisplayString = pageNum + 1 + "/" + pageCount;
        int pageDisplayWidth = fontRenderer.func_78256_a(this.pageNumDisplayString);
        this.pageNumDisplayX = (this.backButton.field_146128_h + this.backButton.field_146120_f + this.nextButton.field_146128_h) / 2 - pageDisplayWidth / 2;
        this.pageNumDisplayY = this.backButton.field_146129_i + Math.round((float)(this.backButton.field_146121_g - fontRenderer.field_78288_b) / 2.0f);
    }

    public void draw(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        this.nextButton.field_146124_l = this.paged.hasNext();
        this.backButton.field_146124_l = this.paged.hasPrevious();
        if (!this.hideOnSinglePage || this.nextButton.field_146124_l || this.backButton.field_146124_l) {
            minecraft.field_71466_p.func_175065_a(this.pageNumDisplayString, (float)this.pageNumDisplayX, (float)this.pageNumDisplayY, Color.white.getRGB(), true);
            this.nextButton.func_191745_a(minecraft, mouseX, mouseY, partialTicks);
            this.backButton.func_191745_a(minecraft, mouseX, mouseY, partialTicks);
        }
    }

    public boolean isMouseOver(int mouseX, int mouseY) {
        return this.area.contains(mouseX, mouseY);
    }

    public boolean handleMouseClickedButtons(int mouseX, int mouseY) {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (this.nextButton.func_146116_c(minecraft, mouseX, mouseY)) {
            this.paged.nextPage();
            this.nextButton.func_146113_a(minecraft.func_147118_V());
            return true;
        }
        if (this.backButton.func_146116_c(minecraft, mouseX, mouseY)) {
            this.paged.previousPage();
            this.backButton.func_146113_a(minecraft.func_147118_V());
            return true;
        }
        return false;
    }
}

