/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.ghost;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.gui.IGhostIngredientHandler;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.config.Config;
import mezz.jei.gui.ghost.GhostIngredientDrag;
import mezz.jei.gui.ghost.GhostIngredientReturning;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.gui.overlay.IngredientGrid;
import mezz.jei.ingredients.IngredientRegistry;
import mezz.jei.input.IClickedIngredient;
import mezz.jei.runtime.JeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;

public class GhostIngredientDragManager {
    private final IngredientGrid contents;
    private final List<GhostIngredientReturning> ghostIngredientsReturning = new ArrayList<GhostIngredientReturning>();
    @Nullable
    private GhostIngredientDrag<?> ghostIngredientDrag;
    @Nullable
    private Object hoveredIngredient;
    @Nullable
    private List<IGhostIngredientHandler.Target<Object>> hoveredIngredientTargets;

    public GhostIngredientDragManager(IngredientGrid contents) {
        this.contents = contents;
    }

    public void drawTooltips(Minecraft minecraft, int mouseX, int mouseY) {
        if (!(minecraft.field_71462_r instanceof GuiContainer)) {
            this.drawGhostIngredientHighlights(minecraft, mouseX, mouseY);
        }
        if (this.ghostIngredientDrag != null) {
            this.ghostIngredientDrag.drawItem(minecraft, mouseX, mouseY);
        }
        this.ghostIngredientsReturning.forEach(returning -> returning.drawItem(minecraft));
        this.ghostIngredientsReturning.removeIf(GhostIngredientReturning::isComplete);
    }

    public void drawOnForeground(Minecraft minecraft, int mouseX, int mouseY) {
        this.drawGhostIngredientHighlights(minecraft, mouseX, mouseY);
    }

    private void drawGhostIngredientHighlights(Minecraft minecraft, int mouseX, int mouseY) {
        if (this.ghostIngredientDrag != null) {
            this.ghostIngredientDrag.drawTargets(mouseX, mouseY);
        } else {
            Object hovered;
            IIngredientListElement elementUnderMouse = this.contents.getElementUnderMouse();
            Object i = hovered = elementUnderMouse == null ? null : (Object)elementUnderMouse.getIngredient();
            if (!Objects.equals(hovered, this.hoveredIngredient)) {
                IGhostIngredientHandler<GuiScreen> handler;
                this.hoveredIngredient = hovered;
                this.hoveredIngredientTargets = null;
                JeiRuntime runtime = Internal.getRuntime();
                GuiScreen currentScreen = minecraft.field_71462_r;
                if (runtime != null && currentScreen != null && hovered != null && (handler = runtime.getGhostIngredientHandler(currentScreen)) != null && handler.shouldHighlightTargets()) {
                    this.hoveredIngredientTargets = handler.getTargets(currentScreen, hovered, false);
                }
            }
            if (this.hoveredIngredientTargets != null && !Config.isCheatItemsEnabled()) {
                GhostIngredientDrag.drawTargets(mouseX, mouseY, this.hoveredIngredientTargets);
            }
        }
    }

    public boolean handleMouseClicked(int mouseX, int mouseY) {
        if (this.ghostIngredientDrag != null) {
            boolean success = this.ghostIngredientDrag.onClick(mouseX, mouseY);
            if (!success) {
                GhostIngredientReturning<?> returning = GhostIngredientReturning.create(this.ghostIngredientDrag, mouseX, mouseY);
                this.ghostIngredientsReturning.add(returning);
            }
            this.ghostIngredientDrag = null;
            return success;
        }
        return false;
    }

    public <T extends GuiScreen, V> boolean handleClickGhostIngredient(T currentScreen, IClickedIngredient<V> clicked) {
        V ingredient;
        List targets;
        IGhostIngredientHandler<T> handler;
        JeiRuntime runtime = Internal.getRuntime();
        if (runtime != null && (handler = runtime.getGhostIngredientHandler(currentScreen)) != null && !(targets = handler.getTargets(currentScreen, ingredient = clicked.getValue(), true)).isEmpty()) {
            IngredientRegistry ingredientRegistry = Internal.getIngredientRegistry();
            IIngredientRenderer<V> ingredientRenderer = ingredientRegistry.getIngredientRenderer(ingredient);
            Rectangle clickedArea = clicked.getArea();
            this.ghostIngredientDrag = new GhostIngredientDrag(handler, targets, ingredientRenderer, ingredient, clickedArea);
            return true;
        }
        return false;
    }
}

