/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.input;

import java.awt.Rectangle;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.ingredients.IngredientRegistry;
import mezz.jei.input.IClickedIngredient;
import mezz.jei.util.ErrorUtil;
import net.minecraft.item.ItemStack;

public class ClickedIngredient<V>
implements IClickedIngredient<V> {
    private final V value;
    @Nullable
    private final Rectangle area;
    private boolean allowsCheating;

    public ClickedIngredient(V value, @Nullable Rectangle area) {
        ErrorUtil.checkIsValidIngredient(value, "value");
        this.value = value;
        this.area = area;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    @Nullable
    public Rectangle getArea() {
        return this.area;
    }

    public void setAllowsCheating() {
        this.allowsCheating = true;
    }

    @Override
    public ItemStack getCheatItemStack() {
        if (this.allowsCheating) {
            IngredientRegistry ingredientRegistry = Internal.getIngredientRegistry();
            IIngredientHelper<V> ingredientHelper = ingredientRegistry.getIngredientHelper(this.value);
            return ingredientHelper.getCheatItemStack(this.value);
        }
        return ItemStack.field_190927_a;
    }
}

