/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.jei.info;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.util.MathUtil;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;

public class IngredientInfoRecipe<T>
implements IRecipeWrapper {
    private static final int lineSpacing = 2;
    private final List<String> description;
    private final List<T> ingredients;
    private final Class<? extends T> ingredientClass;
    private final IDrawable slotDrawable;

    public static <T> List<IngredientInfoRecipe<T>> create(IGuiHelper guiHelper, List<T> ingredients, Class<? extends T> ingredientClass, String ... descriptionKeys) {
        ArrayList<IngredientInfoRecipe<T>> recipes = new ArrayList<IngredientInfoRecipe<T>>();
        List<String> descriptionLines = IngredientInfoRecipe.translateDescriptionLines(descriptionKeys);
        descriptionLines = IngredientInfoRecipe.expandNewlines(descriptionLines);
        descriptionLines = IngredientInfoRecipe.wrapDescriptionLines(descriptionLines);
        int lineCount = descriptionLines.size();
        Minecraft minecraft = Minecraft.func_71410_x();
        int maxLinesPerPage = 105 / (minecraft.field_71466_p.field_78288_b + 2);
        int pageCount = MathUtil.divideCeil(lineCount, maxLinesPerPage);
        for (int i = 0; i < pageCount; ++i) {
            int startLine = i * maxLinesPerPage;
            int endLine = Math.min((i + 1) * maxLinesPerPage, lineCount);
            List<String> description = descriptionLines.subList(startLine, endLine);
            IngredientInfoRecipe<? extends T> recipe = new IngredientInfoRecipe<T>(guiHelper, ingredients, ingredientClass, description);
            recipes.add(recipe);
        }
        return recipes;
    }

    private static List<String> translateDescriptionLines(String ... descriptionKeys) {
        ArrayList<String> descriptionLines = new ArrayList<String>();
        for (String descriptionKey : descriptionKeys) {
            String translatedLine = Translator.translateToLocal(descriptionKey);
            descriptionLines.add(translatedLine);
        }
        return descriptionLines;
    }

    private static List<String> expandNewlines(List<String> descriptionLines) {
        ArrayList<String> descriptionLinesExpanded = new ArrayList<String>();
        for (String descriptionLine : descriptionLines) {
            String[] descriptionLineExpanded = descriptionLine.split("\\\\n");
            Collections.addAll(descriptionLinesExpanded, descriptionLineExpanded);
        }
        return descriptionLinesExpanded;
    }

    private static List<String> wrapDescriptionLines(List<String> descriptionLines) {
        Minecraft minecraft = Minecraft.func_71410_x();
        ArrayList<String> descriptionLinesWrapped = new ArrayList<String>();
        for (String descriptionLine : descriptionLines) {
            List textLines = minecraft.field_71466_p.func_78271_c(descriptionLine, 160);
            descriptionLinesWrapped.addAll(textLines);
        }
        return descriptionLinesWrapped;
    }

    private IngredientInfoRecipe(IGuiHelper guiHelper, List<T> ingredients, Class<? extends T> ingredientClass, List<String> description) {
        this.description = description;
        this.ingredients = ingredients;
        this.ingredientClass = ingredientClass;
        this.slotDrawable = guiHelper.getSlotDrawable();
    }

    @Override
    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(this.ingredientClass, Collections.singletonList(this.ingredients));
        ingredients.setOutputs(this.ingredientClass, this.ingredients);
    }

    @Override
    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        int xPos = 0;
        int yPos = this.slotDrawable.getHeight() + 4;
        for (String descriptionLine : this.description) {
            minecraft.field_71466_p.func_78276_b(descriptionLine, xPos, yPos, Color.black.getRGB());
            yPos += minecraft.field_71466_p.field_78288_b + 2;
        }
    }

    public List<String> getDescription() {
        return this.description;
    }
}

