/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.startup;

import com.google.common.base.Stopwatch;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mezz.jei.Internal;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.gui.IAdvancedGuiHandler;
import mezz.jei.api.gui.IGhostIngredientHandler;
import mezz.jei.api.gui.IGuiScreenHandler;
import mezz.jei.config.Config;
import mezz.jei.gui.GuiEventHandler;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.gui.overlay.IngredientListOverlay;
import mezz.jei.gui.recipes.RecipesGui;
import mezz.jei.ingredients.IngredientFilter;
import mezz.jei.ingredients.IngredientListElementFactory;
import mezz.jei.ingredients.IngredientRegistry;
import mezz.jei.plugins.vanilla.VanillaPlugin;
import mezz.jei.recipes.RecipeRegistry;
import mezz.jei.runtime.JeiHelpers;
import mezz.jei.runtime.JeiRuntime;
import mezz.jei.runtime.SubtypeRegistry;
import mezz.jei.startup.ForgeModIdHelper;
import mezz.jei.startup.ModIngredientRegistration;
import mezz.jei.startup.ModRegistry;
import mezz.jei.startup.StackHelper;
import mezz.jei.util.Log;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.ProgressManager;

public class JeiStarter {
    private boolean started;

    public void start(List<IModPlugin> plugins) {
        LoggedTimer totalTime = new LoggedTimer();
        totalTime.start("Starting JEI");
        SubtypeRegistry subtypeRegistry = new SubtypeRegistry();
        JeiStarter.registerItemSubtypes(plugins, subtypeRegistry);
        StackHelper stackHelper = new StackHelper(subtypeRegistry);
        stackHelper.enableUidCache();
        Internal.setStackHelper(stackHelper);
        IngredientRegistry ingredientRegistry = JeiStarter.registerIngredients(plugins);
        Internal.setIngredientRegistry(ingredientRegistry);
        JeiHelpers jeiHelpers = new JeiHelpers(ingredientRegistry, stackHelper);
        Internal.setHelpers(jeiHelpers);
        ModRegistry modRegistry = new ModRegistry(jeiHelpers, ingredientRegistry);
        LoggedTimer timer = new LoggedTimer();
        timer.start("Registering recipe categories");
        JeiStarter.registerCategories(plugins, modRegistry);
        timer.stop();
        timer.start("Registering mod plugins");
        JeiStarter.registerPlugins(plugins, modRegistry);
        timer.stop();
        timer.start("Building recipe registry");
        RecipeRegistry recipeRegistry = modRegistry.createRecipeRegistry(ingredientRegistry);
        timer.stop();
        timer.start("Building ingredient list");
        NonNullList<IIngredientListElement> ingredientList = IngredientListElementFactory.createBaseList(ingredientRegistry, ForgeModIdHelper.getInstance());
        timer.stop();
        timer.start("Building ingredient filter");
        IngredientFilter ingredientFilter = new IngredientFilter(jeiHelpers);
        ingredientFilter.addIngredients(ingredientList);
        Internal.setIngredientFilter(ingredientFilter);
        timer.stop();
        timer.start("Building runtime");
        List<IAdvancedGuiHandler<?>> advancedGuiHandlers = modRegistry.getAdvancedGuiHandlers();
        Map<Class, IGuiScreenHandler> guiScreenHandlers = modRegistry.getGuiScreenHandlers();
        Map<Class, IGhostIngredientHandler> ghostIngredientHandlers = modRegistry.getGhostIngredientHandlers();
        IngredientListOverlay ingredientListOverlay = new IngredientListOverlay(ingredientFilter);
        RecipesGui recipesGui = new RecipesGui(recipeRegistry);
        JeiRuntime jeiRuntime = new JeiRuntime(recipeRegistry, ingredientListOverlay, recipesGui, ingredientRegistry, advancedGuiHandlers, guiScreenHandlers, ghostIngredientHandlers, ingredientFilter);
        Internal.setRuntime(jeiRuntime);
        timer.stop();
        stackHelper.disableUidCache();
        JeiStarter.sendRuntime(plugins, jeiRuntime);
        GuiEventHandler guiEventHandler = new GuiEventHandler(jeiRuntime);
        Internal.setGuiEventHandler(guiEventHandler);
        Config.checkForModNameFormatOverride();
        this.started = true;
        totalTime.stop();
    }

    public boolean hasStarted() {
        return this.started;
    }

    private static void registerItemSubtypes(List<IModPlugin> plugins, SubtypeRegistry subtypeRegistry) {
        ProgressManager.ProgressBar progressBar = ProgressManager.push((String)"Registering item subtypes", (int)plugins.size());
        Iterator<IModPlugin> iterator = plugins.iterator();
        while (iterator.hasNext()) {
            IModPlugin plugin = iterator.next();
            try {
                progressBar.step(plugin.getClass().getName());
                plugin.registerItemSubtypes(subtypeRegistry);
            }
            catch (LinkageError | RuntimeException e) {
                Log.get().error("Failed to register item subtypes for mod plugin: {}", plugin.getClass(), (Object)e);
                iterator.remove();
            }
        }
        ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
    }

    private static IngredientRegistry registerIngredients(List<IModPlugin> plugins) {
        ProgressManager.ProgressBar progressBar = ProgressManager.push((String)"Registering ingredients", (int)plugins.size());
        ModIngredientRegistration modIngredientRegistry = new ModIngredientRegistration();
        Iterator<IModPlugin> iterator = plugins.iterator();
        while (iterator.hasNext()) {
            IModPlugin plugin = iterator.next();
            try {
                progressBar.step(plugin.getClass().getName());
                plugin.registerIngredients(modIngredientRegistry);
            }
            catch (LinkageError | RuntimeException e) {
                if (VanillaPlugin.class.isInstance(plugin)) {
                    throw e;
                }
                Log.get().error("Failed to register Ingredients for mod plugin: {}", plugin.getClass(), (Object)e);
                iterator.remove();
            }
        }
        ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
        return modIngredientRegistry.createIngredientRegistry(ForgeModIdHelper.getInstance());
    }

    private static void registerCategories(List<IModPlugin> plugins, ModRegistry modRegistry) {
        ProgressManager.ProgressBar progressBar = ProgressManager.push((String)"Registering categories", (int)plugins.size());
        Iterator<IModPlugin> iterator = plugins.iterator();
        while (iterator.hasNext()) {
            IModPlugin plugin = iterator.next();
            try {
                progressBar.step(plugin.getClass().getName());
                long start_time = System.currentTimeMillis();
                Log.get().debug("Registering categories: {} ...", (Object)plugin.getClass().getName());
                plugin.registerCategories(modRegistry);
                long timeElapsedMs = System.currentTimeMillis() - start_time;
                Log.get().debug("Registered  categories: {} in {} ms", (Object)plugin.getClass().getName(), (Object)timeElapsedMs);
            }
            catch (AbstractMethodError start_time) {
            }
            catch (LinkageError | RuntimeException e) {
                Log.get().error("Failed to register mod categories: {}", plugin.getClass(), (Object)e);
                iterator.remove();
            }
        }
        ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
    }

    private static void registerPlugins(List<IModPlugin> plugins, ModRegistry modRegistry) {
        ProgressManager.ProgressBar progressBar = ProgressManager.push((String)"Registering plugins", (int)plugins.size());
        Iterator<IModPlugin> iterator = plugins.iterator();
        while (iterator.hasNext()) {
            IModPlugin plugin = iterator.next();
            try {
                progressBar.step(plugin.getClass().getName());
                long start_time = System.currentTimeMillis();
                Log.get().debug("Registering plugin: {} ...", (Object)plugin.getClass().getName());
                plugin.register(modRegistry);
                long timeElapsedMs = System.currentTimeMillis() - start_time;
                Log.get().debug("Registered  plugin: {} in {} ms", (Object)plugin.getClass().getName(), (Object)timeElapsedMs);
            }
            catch (LinkageError | RuntimeException e) {
                Log.get().error("Failed to register mod plugin: {}", plugin.getClass(), (Object)e);
                iterator.remove();
            }
        }
        ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
    }

    private static void sendRuntime(List<IModPlugin> plugins, IJeiRuntime jeiRuntime) {
        ProgressManager.ProgressBar progressBar = ProgressManager.push((String)"Sending Runtime", (int)plugins.size());
        Iterator<IModPlugin> iterator = plugins.iterator();
        while (iterator.hasNext()) {
            IModPlugin plugin = iterator.next();
            try {
                progressBar.step(plugin.getClass().getName());
                long start_time = System.currentTimeMillis();
                Log.get().debug("Sending runtime to plugin: {} ...", (Object)plugin.getClass().getName());
                plugin.onRuntimeAvailable(jeiRuntime);
                long timeElapsedMs = System.currentTimeMillis() - start_time;
                if (timeElapsedMs <= 100L) continue;
                Log.get().warn("Sending runtime to plugin: {} took {} ms", (Object)plugin.getClass().getName(), (Object)timeElapsedMs);
            }
            catch (LinkageError | RuntimeException e) {
                Log.get().error("Sending runtime to plugin failed: {}", plugin.getClass(), (Object)e);
                iterator.remove();
            }
        }
        ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
    }

    private static class LoggedTimer {
        private final Stopwatch stopWatch = Stopwatch.createUnstarted();
        private String message = "";

        private LoggedTimer() {
        }

        public void start(String message) {
            this.message = message;
            Log.get().info("{}...", (Object)message);
            this.stopWatch.reset();
            this.stopWatch.start();
        }

        public void stop() {
            this.stopWatch.stop();
            Log.get().info("{} took {}", (Object)this.message, (Object)this.stopWatch);
        }
    }
}

