/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.builder;

import io.netty.buffer.ByteBuf;
import mcjty.lib.network.NetworkTools;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.builder.BuilderTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketPositionToClient
implements IMessage {
    private BlockPos tePos;
    private BlockPos scanPos;

    public void fromBytes(ByteBuf buf) {
        this.tePos = NetworkTools.readPos((ByteBuf)buf);
        this.scanPos = NetworkTools.readPos((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        NetworkTools.writePos((ByteBuf)buf, (BlockPos)this.tePos);
        NetworkTools.writePos((ByteBuf)buf, (BlockPos)this.scanPos);
    }

    public PacketPositionToClient() {
    }

    public PacketPositionToClient(BlockPos tePos, BlockPos scanPos) {
        this.tePos = tePos;
        this.scanPos = scanPos;
    }

    public static class Handler
    implements IMessageHandler<PacketPositionToClient, IMessage> {
        public IMessage onMessage(PacketPositionToClient message, MessageContext ctx) {
            RFTools.proxy.addScheduledTaskClient(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketPositionToClient message, MessageContext ctx) {
            TileEntity te = RFTools.proxy.getClientWorld().func_175625_s(message.tePos);
            if (te instanceof BuilderTileEntity) {
                BuilderTileEntity.setScanLocationClient(message.tePos, message.scanPos);
            }
        }
    }
}

