/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.logic.wire;

import java.util.List;
import mcjty.lib.container.EmptyContainer;
import mcjty.rftools.blocks.logic.generic.LogicSlabBlock;
import mcjty.rftools.blocks.logic.wire.WireTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class WireBlock
extends LogicSlabBlock<WireTileEntity, EmptyContainer> {
    public WireBlock() {
        super(Material.field_151573_f, "wire_block", WireTileEntity.class, EmptyContainer.class);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack itemStack, World player, List<String> list, ITooltipFlag advanced) {
        super.func_190948_a(itemStack, player, list, advanced);
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(TextFormatting.WHITE + "This logic block is just a simple");
            list.add(TextFormatting.WHITE + "lag free redstone wire");
        } else {
            list.add(TextFormatting.WHITE + "<Press Shift>");
        }
    }

    public int getGuiID() {
        return -1;
    }

    @Override
    protected void checkRedstone(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof WireTileEntity) {
            WireTileEntity logicTileEntity = (WireTileEntity)te;
            EnumFacing inputSide = logicTileEntity.getFacing(world.func_180495_p(pos)).getInputSide();
            int power = this.getInputStrength(world, pos, inputSide);
            int oldPower = logicTileEntity.getPowerLevel();
            logicTileEntity.setPowerInput(power);
            if (oldPower != power) {
                world.func_175685_c(pos, (Block)this, false);
            }
        }
    }

    @Override
    protected int getRedstoneOutput(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntity te = world.func_175625_s(pos);
        if (state.func_177230_c() instanceof WireBlock && te instanceof WireTileEntity) {
            WireTileEntity logicTileEntity = (WireTileEntity)te;
            if (side == logicTileEntity.getFacing(state).getInputSide()) {
                return logicTileEntity.getPowerLevel();
            }
            return 0;
        }
        return 0;
    }
}

