/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.screens.modulesclient;

import mcjty.rftools.api.screens.IClientScreenModule;
import mcjty.rftools.api.screens.IModuleGuiBuilder;
import mcjty.rftools.api.screens.IModuleRenderHelper;
import mcjty.rftools.api.screens.ITextRenderHelper;
import mcjty.rftools.api.screens.ModuleRenderInfo;
import mcjty.rftools.api.screens.TextAlign;
import mcjty.rftools.api.screens.data.IModuleDataBoolean;
import mcjty.rftools.blocks.screens.modulesclient.helper.ScreenTextHelper;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class RedstoneClientScreenModule
implements IClientScreenModule<IModuleDataBoolean> {
    private String line = "";
    private String yestext = "on";
    private String notext = "off";
    private int color = 0xFFFFFF;
    private int yescolor = 0xFFFFFF;
    private int nocolor = 0xFFFFFF;
    private int dim = 0;
    private ITextRenderHelper labelCache = new ScreenTextHelper();

    @Override
    public IClientScreenModule.TransformMode getTransformMode() {
        return IClientScreenModule.TransformMode.TEXT;
    }

    @Override
    public int getHeight() {
        return 10;
    }

    @Override
    public void render(IModuleRenderHelper renderHelper, FontRenderer fontRenderer, int currenty, IModuleDataBoolean screenData, ModuleRenderInfo renderInfo) {
        int col;
        String text;
        int xoffset;
        GlStateManager.func_179140_f();
        if (!this.line.isEmpty()) {
            this.labelCache.setup(this.line, 160, renderInfo);
            this.labelCache.renderText(0, currenty, this.color, renderInfo);
            xoffset = 47;
        } else {
            xoffset = 7;
        }
        if (screenData != null) {
            boolean rs = screenData.get();
            text = rs ? this.yestext : this.notext;
            col = rs ? this.yescolor : this.nocolor;
        } else {
            text = "<invalid>";
            col = 0xFF0000;
        }
        renderHelper.renderText(xoffset, currenty, col, renderInfo, text);
    }

    @Override
    public void mouseClick(World world, int x, int y, boolean clicked) {
    }

    @Override
    public void createGui(IModuleGuiBuilder guiBuilder) {
        guiBuilder.label("Label:").text("text", "Label text").color("color", "Color for the label").nl().label("Yes:").text("yestext", "Positive text").color("yescolor", "Color for the positive text").nl().label("No:").text("notext", "Negative text").color("nocolor", "Color for the negative text").nl().choices("align", "Label alignment", "Left", "Center", "Right").nl().label("Block:").block("monitor").nl();
    }

    @Override
    public void setupFromNBT(NBTTagCompound tagCompound, int dim, BlockPos pos) {
        if (tagCompound != null) {
            this.line = tagCompound.func_74779_i("text");
            if (tagCompound.func_74764_b("yestext")) {
                this.yestext = tagCompound.func_74779_i("yestext");
            }
            if (tagCompound.func_74764_b("notext")) {
                this.notext = tagCompound.func_74779_i("notext");
            }
            this.color = tagCompound.func_74764_b("color") ? tagCompound.func_74762_e("color") : 0xFFFFFF;
            this.yescolor = tagCompound.func_74764_b("yescolor") ? tagCompound.func_74762_e("yescolor") : 0xFFFFFF;
            this.nocolor = tagCompound.func_74764_b("nocolor") ? tagCompound.func_74762_e("nocolor") : 0xFFFFFF;
            if (tagCompound.func_74764_b("align")) {
                String alignment = tagCompound.func_74779_i("align");
                this.labelCache.align(TextAlign.get(alignment));
            } else {
                this.labelCache.align(TextAlign.ALIGN_LEFT);
            }
        }
    }

    @Override
    public boolean needsServerData() {
        return true;
    }
}

