/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.shaper;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import mcjty.lib.base.ModBase;
import mcjty.lib.container.EmptyContainer;
import mcjty.lib.container.GenericGuiContainer;
import mcjty.lib.entity.GenericEnergyStorageTileEntity;
import mcjty.lib.entity.GenericTileEntity;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.LayoutHint;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.widgets.ColorChoiceLabel;
import mcjty.lib.gui.widgets.EnergyBar;
import mcjty.lib.gui.widgets.ImageChoiceLabel;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.ToggleButton;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.network.Argument;
import mcjty.lib.varia.RedstoneMode;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.shaper.LocatorTileEntity;
import mcjty.rftools.blocks.shaper.PacketRequestLocatorEnergyConsumption;
import mcjty.rftools.blocks.shaper.ScannerConfiguration;
import mcjty.rftools.network.RFToolsMessages;
import mcjty.rftools.shapes.BeaconType;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiLocator
extends GenericGuiContainer<LocatorTileEntity> {
    private static final int LOCATOR_WIDTH = 256;
    private static final int LOCATOR_HEIGHT = 238;
    private static final ResourceLocation iconLocation = new ResourceLocation("rftools", "textures/gui/locator.png");
    private static final ResourceLocation iconGuiElements = new ResourceLocation("rftools", "textures/gui/guielements.png");
    private EnergyBar energyBar;
    private ImageChoiceLabel redstoneMode;
    private ColorChoiceLabel hostile;
    private ColorChoiceLabel passive;
    private ColorChoiceLabel player;
    private ToggleButton hostileBeacon;
    private ToggleButton passiveBeacon;
    private ToggleButton playerBeacon;
    private TextField filter;
    private ColorChoiceLabel energy;
    private ToggleButton energyBeacon;
    private TextField minEnergy;
    private TextField maxEnergy;
    private Label energyLabel;
    public static int energyConsumption = 0;
    private static final Map<Integer, BeaconType> COLOR_TO_TYPE = new HashMap<Integer, BeaconType>();
    static int cnt = 10;

    public GuiLocator(LocatorTileEntity tileEntity, EmptyContainer container) {
        super((ModBase)RFTools.instance, RFToolsMessages.INSTANCE, (GenericTileEntity)tileEntity, (Container)container, RFTools.GUI_MANUAL_SHAPE, "locator");
        this.field_146999_f = 256;
        this.field_147000_g = 238;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Panel toplevel = ((Panel)new Panel(this.field_146297_k, (Gui)this).setBackground(iconLocation)).setLayout((Layout)new PositionalLayout());
        int maxEnergyStored = ((LocatorTileEntity)this.tileEntity).getMaxEnergyStored();
        this.energyBar = ((EnergyBar)new EnergyBar(this.field_146297_k, (Gui)this).setHorizontal().setMaxValue(maxEnergyStored).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(28, 10, 70, 10))).setShowText(false);
        this.energyBar.setValue(GenericEnergyStorageTileEntity.getCurrentRF());
        toplevel.addChild((Widget)this.energyBar);
        this.initRedstoneMode();
        toplevel.addChild((Widget)this.redstoneMode);
        this.hostile = new ColorChoiceLabel(this.field_146297_k, (Gui)this);
        this.hostileBeacon = new ToggleButton(this.field_146297_k, (Gui)this);
        this.addBeaconSetting(toplevel, this.hostile, this.hostileBeacon, 30, "Hostile");
        this.hostile.setCurrentColor(Integer.valueOf(((LocatorTileEntity)this.tileEntity).getHostileType().getColor()));
        this.hostileBeacon.setPressed(((LocatorTileEntity)this.tileEntity).isHostileBeacon());
        this.passive = new ColorChoiceLabel(this.field_146297_k, (Gui)this);
        this.passiveBeacon = new ToggleButton(this.field_146297_k, (Gui)this);
        this.addBeaconSetting(toplevel, this.passive, this.passiveBeacon, 46, "Passive");
        this.passive.setCurrentColor(Integer.valueOf(((LocatorTileEntity)this.tileEntity).getPassiveType().getColor()));
        this.passiveBeacon.setPressed(((LocatorTileEntity)this.tileEntity).isPassiveBeacon());
        this.player = new ColorChoiceLabel(this.field_146297_k, (Gui)this);
        this.playerBeacon = new ToggleButton(this.field_146297_k, (Gui)this);
        this.addBeaconSetting(toplevel, this.player, this.playerBeacon, 62, "Player");
        this.player.setCurrentColor(Integer.valueOf(((LocatorTileEntity)this.tileEntity).getPlayerType().getColor()));
        this.playerBeacon.setPressed(((LocatorTileEntity)this.tileEntity).isPlayerBeacon());
        toplevel.addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText("Filter").setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(8, 82, 40, 14)));
        this.filter = new TextField(this.field_146297_k, (Gui)this);
        this.filter.setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(50, 82, 90, 14));
        this.filter.setText(((LocatorTileEntity)this.tileEntity).getFilter());
        this.filter.addTextEvent((parent, newText) -> this.update());
        toplevel.addChild((Widget)this.filter);
        this.energy = new ColorChoiceLabel(this.field_146297_k, (Gui)this);
        this.energyBeacon = new ToggleButton(this.field_146297_k, (Gui)this);
        this.addBeaconSetting(toplevel, this.energy, this.energyBeacon, 98, "Energy");
        this.energy.setCurrentColor(Integer.valueOf(((LocatorTileEntity)this.tileEntity).getEnergyType().getColor()));
        this.energyBeacon.setPressed(((LocatorTileEntity)this.tileEntity).isEnergyBeacon());
        toplevel.addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText("<").setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(153, 98, 10, 14)));
        this.minEnergy = (TextField)new TextField(this.field_146297_k, (Gui)this).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(162, 98, 25, 14));
        this.minEnergy.setText(((LocatorTileEntity)this.tileEntity).getMinEnergy() == null ? "" : Integer.toString(((LocatorTileEntity)this.tileEntity).getMinEnergy()));
        this.minEnergy.addTextEvent((parent, newText) -> this.update());
        toplevel.addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText("%").setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(187, 98, 10, 14)));
        toplevel.addChild((Widget)this.minEnergy);
        toplevel.addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText(">").setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(205, 98, 10, 14)));
        this.maxEnergy = (TextField)new TextField(this.field_146297_k, (Gui)this).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(214, 98, 25, 14));
        this.maxEnergy.setText(((LocatorTileEntity)this.tileEntity).getMaxEnergy() == null ? "" : Integer.toString(((LocatorTileEntity)this.tileEntity).getMaxEnergy()));
        this.maxEnergy.addTextEvent((parent, newText) -> this.update());
        toplevel.addChild((Widget)this.maxEnergy);
        toplevel.addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText("%").setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(238, 98, 10, 14)));
        toplevel.addChild((Widget)new Label(this.field_146297_k, (Gui)this).setColor(0x993300).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT).setText("RF per scan (every " + ScannerConfiguration.ticksPerLocatorScan + " ticks):").setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(8, 186, 156, 14)));
        this.energyLabel = new Label(this.field_146297_k, (Gui)this).setText("");
        this.energyLabel.setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT);
        this.energyLabel.setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(8, 200, 156, 14));
        toplevel.addChild((Widget)this.energyLabel);
        toplevel.setBounds(new Rectangle(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g));
        this.window = new Window((GuiScreen)this, (Widget)toplevel);
        ((LocatorTileEntity)this.tileEntity).requestRfFromServer("rftools");
        energyConsumption = 0;
    }

    private void addBeaconSetting(Panel toplevel, ColorChoiceLabel choice, ToggleButton toggle, int y, String label) {
        toplevel.addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText(label).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(8, y, 40, 14)));
        choice.setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(50, y, 30, 14));
        for (BeaconType type : BeaconType.VALUES) {
            choice.addColors(new Integer[]{type.getColor()});
            COLOR_TO_TYPE.put(type.getColor(), type);
        }
        choice.addChoiceEvent((parent, newColor) -> this.update());
        toplevel.addChild((Widget)choice);
        toggle.setCheckMarker(true).setText("Beacon");
        toggle.setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(90, y, 60, 14));
        toggle.addButtonEvent(parent -> this.update());
        toplevel.addChild((Widget)toggle);
    }

    private void update() {
        ArrayList<Argument> arguments = new ArrayList<Argument>();
        arguments.add(new Argument("hostile", COLOR_TO_TYPE.get(this.hostile.getCurrentColor()).getCode()));
        arguments.add(new Argument("passive", COLOR_TO_TYPE.get(this.passive.getCurrentColor()).getCode()));
        arguments.add(new Argument("player", COLOR_TO_TYPE.get(this.player.getCurrentColor()).getCode()));
        arguments.add(new Argument("energy", COLOR_TO_TYPE.get(this.energy.getCurrentColor()).getCode()));
        arguments.add(new Argument("hostileBeacon", this.hostileBeacon.isPressed()));
        arguments.add(new Argument("passiveBeacon", this.passiveBeacon.isPressed()));
        arguments.add(new Argument("playerBeacon", this.playerBeacon.isPressed()));
        arguments.add(new Argument("energyBeacon", this.energyBeacon.isPressed()));
        arguments.add(new Argument("filter", this.filter.getText()));
        if (!this.minEnergy.getText().trim().isEmpty()) {
            try {
                arguments.add(new Argument("minEnergy", Integer.parseInt(this.minEnergy.getText())));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (!this.maxEnergy.getText().trim().isEmpty()) {
            try {
                arguments.add(new Argument("maxEnergy", Integer.parseInt(this.maxEnergy.getText())));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.sendServerCommand(RFToolsMessages.INSTANCE, "setSettings", arguments.toArray(new Argument[arguments.size()]));
    }

    private void initRedstoneMode() {
        this.redstoneMode = new ImageChoiceLabel(this.field_146297_k, (Gui)this).addChoiceEvent((parent, newChoice) -> this.changeRedstoneMode()).addChoice(RedstoneMode.REDSTONE_IGNORED.getDescription(), "Redstone mode:\nIgnored", iconGuiElements, 0, 0).addChoice(RedstoneMode.REDSTONE_OFFREQUIRED.getDescription(), "Redstone mode:\nOff to activate", iconGuiElements, 16, 0).addChoice(RedstoneMode.REDSTONE_ONREQUIRED.getDescription(), "Redstone mode:\nOn to activate", iconGuiElements, 32, 0);
        this.redstoneMode.setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(8, 10, 16, 16));
        this.redstoneMode.setCurrentChoice(((LocatorTileEntity)this.tileEntity).getRSMode().ordinal());
    }

    private void changeRedstoneMode() {
        ((LocatorTileEntity)this.tileEntity).setRSMode(RedstoneMode.values()[this.redstoneMode.getCurrentChoiceIndex()]);
        this.sendServerCommand(RFToolsMessages.INSTANCE, "setMode", new Argument[]{new Argument("rs", RedstoneMode.values()[this.redstoneMode.getCurrentChoiceIndex()].getDescription())});
    }

    protected void func_146976_a(float v, int x, int y) {
        this.drawWindow();
        int currentRF = GenericEnergyStorageTileEntity.getCurrentRF();
        this.energyBar.setValue(currentRF);
        ((LocatorTileEntity)this.tileEntity).requestRfFromServer("rftools");
        if (--cnt < 0) {
            cnt = 10;
            RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketRequestLocatorEnergyConsumption(((LocatorTileEntity)this.tileEntity).func_174877_v()));
        }
        this.energyLabel.setText(energyConsumption + " RF");
    }
}

