/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.shaper;

import java.awt.Rectangle;
import java.io.IOException;
import mcjty.lib.base.ModBase;
import mcjty.lib.container.GenericGuiContainer;
import mcjty.lib.entity.GenericEnergyStorageTileEntity;
import mcjty.lib.entity.GenericTileEntity;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.LayoutHint;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.EnergyBar;
import mcjty.lib.gui.widgets.ImageChoiceLabel;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.ToggleButton;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.network.Argument;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.RedstoneMode;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.shaper.RemoteScannerTileEntity;
import mcjty.rftools.blocks.shaper.ScannerConfiguration;
import mcjty.rftools.blocks.shaper.ScannerContainer;
import mcjty.rftools.blocks.shaper.ScannerTileEntity;
import mcjty.rftools.blocks.shaper.ShapeGuiTools;
import mcjty.rftools.items.builder.ShapeCardItem;
import mcjty.rftools.network.RFToolsMessages;
import mcjty.rftools.shapes.IShapeParentGui;
import mcjty.rftools.shapes.ShapeID;
import mcjty.rftools.shapes.ShapeRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import org.lwjgl.input.Mouse;

public class GuiScanner
extends GenericGuiContainer<ScannerTileEntity>
implements IShapeParentGui {
    public static final int SCANNER_WIDTH = 256;
    public static final int SCANNER_HEIGHT = 238;
    private static final ResourceLocation iconLocation = new ResourceLocation("rftools", "textures/gui/scanner.png");
    private static final ResourceLocation iconGuiElements = new ResourceLocation("rftools", "textures/gui/guielements.png");
    private EnergyBar energyBar;
    private ImageChoiceLabel redstoneMode;
    private ToggleButton showAxis;
    private ToggleButton showOuter;
    private ToggleButton showScan;
    private Button scanButton;
    private Label offsetLabel;
    private Label dimensionLabel;
    private Label progressLabel;
    private ShapeRenderer shapeRenderer = null;
    private int filterCnt = 0;

    public GuiScanner(ScannerTileEntity shaperTileEntity, ScannerContainer container) {
        super((ModBase)RFTools.instance, RFToolsMessages.INSTANCE, (GenericTileEntity)shaperTileEntity, (Container)container, RFTools.GUI_MANUAL_SHAPE, "scanner");
        this.field_146999_f = 256;
        this.field_147000_g = 238;
    }

    public GuiScanner(RemoteScannerTileEntity shaperTileEntity, ScannerContainer container) {
        super((ModBase)RFTools.instance, RFToolsMessages.INSTANCE, (GenericTileEntity)shaperTileEntity, (Container)container, RFTools.GUI_MANUAL_SHAPE, "remote_scanner");
        this.field_146999_f = 256;
        this.field_147000_g = 238;
    }

    private ShapeRenderer getShapeRenderer() {
        if (this.shapeRenderer == null) {
            this.shapeRenderer = new ShapeRenderer(this.getShapeID());
        }
        return this.shapeRenderer;
    }

    private ShapeID getShapeID() {
        ItemStack renderStack = ((ScannerTileEntity)this.tileEntity).getRenderStack();
        return new ShapeID(0, null, ShapeCardItem.getScanId(renderStack), false, ShapeCardItem.isSolid(renderStack));
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.getShapeRenderer().initView(this.getPreviewLeft(), this.field_147009_r + 100);
        Panel toplevel = ((Panel)new Panel(this.field_146297_k, (Gui)this).setBackground(iconLocation)).setLayout((Layout)new PositionalLayout());
        int maxEnergyStored = ((ScannerTileEntity)this.tileEntity).getMaxEnergyStored();
        this.energyBar = ((EnergyBar)new EnergyBar(this.field_146297_k, (Gui)this).setHorizontal().setMaxValue(maxEnergyStored).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(8, 120, 70, 10))).setShowText(false);
        this.energyBar.setValue(GenericEnergyStorageTileEntity.getCurrentRF());
        toplevel.addChild((Widget)this.energyBar);
        this.initRedstoneMode();
        toplevel.addChild((Widget)this.redstoneMode);
        this.showAxis = ShapeGuiTools.createAxisButton((Gui)this, toplevel, 5, 176);
        this.showOuter = ShapeGuiTools.createBoxButton((Gui)this, toplevel, 31, 176);
        this.showScan = ShapeGuiTools.createScanButton((Gui)this, toplevel, 57, 176);
        this.scanButton = (Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("Scan")).addButtonEvent(parent -> this.scan()).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(5, 156, 40, 16));
        toplevel.addChild((Widget)this.scanButton);
        toplevel.addChild((Widget)((Button)new Button(this.field_146297_k, (Gui)this).setText("W")).addButtonEvent(parent -> this.move(-16, 0, 0)).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(4, 30, 16, 15)));
        toplevel.addChild((Widget)((Button)new Button(this.field_146297_k, (Gui)this).setText("w")).addButtonEvent(parent -> this.move(-1, 0, 0)).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(20, 30, 16, 15)));
        toplevel.addChild((Widget)((Button)new Button(this.field_146297_k, (Gui)this).setText("e")).addButtonEvent(parent -> this.move(1, 0, 0)).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(45, 30, 16, 15)));
        toplevel.addChild((Widget)((Button)new Button(this.field_146297_k, (Gui)this).setText("E")).addButtonEvent(parent -> this.move(16, 0, 0)).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(61, 30, 16, 15)));
        toplevel.addChild((Widget)((Button)new Button(this.field_146297_k, (Gui)this).setText("S")).addButtonEvent(parent -> this.move(0, 0, -16)).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(4, 50, 16, 15)));
        toplevel.addChild((Widget)((Button)new Button(this.field_146297_k, (Gui)this).setText("s")).addButtonEvent(parent -> this.move(0, 0, -1)).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(20, 50, 16, 15)));
        toplevel.addChild((Widget)((Button)new Button(this.field_146297_k, (Gui)this).setText("n")).addButtonEvent(parent -> this.move(0, 0, 1)).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(45, 50, 16, 15)));
        toplevel.addChild((Widget)((Button)new Button(this.field_146297_k, (Gui)this).setText("N")).addButtonEvent(parent -> this.move(0, 0, 16)).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(61, 50, 16, 15)));
        toplevel.addChild((Widget)((Button)new Button(this.field_146297_k, (Gui)this).setText("D")).addButtonEvent(parent -> this.move(0, -16, 0)).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(4, 70, 16, 15)));
        toplevel.addChild((Widget)((Button)new Button(this.field_146297_k, (Gui)this).setText("d")).addButtonEvent(parent -> this.move(0, -1, 0)).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(20, 70, 16, 15)));
        toplevel.addChild((Widget)((Button)new Button(this.field_146297_k, (Gui)this).setText("u")).addButtonEvent(parent -> this.move(0, 1, 0)).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(45, 70, 16, 15)));
        toplevel.addChild((Widget)((Button)new Button(this.field_146297_k, (Gui)this).setText("U")).addButtonEvent(parent -> this.move(0, 16, 0)).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(61, 70, 16, 15)));
        this.offsetLabel = new Label(this.field_146297_k, (Gui)this).setText("Off: " + BlockPosTools.toString((BlockPos)((ScannerTileEntity)this.tileEntity).getDataOffset())).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT);
        this.offsetLabel.setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(4, 90, 80, 14));
        toplevel.addChild((Widget)this.offsetLabel);
        this.dimensionLabel = new Label(this.field_146297_k, (Gui)this).setText("Dim: " + BlockPosTools.toString((BlockPos)((ScannerTileEntity)this.tileEntity).getDataDim())).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT);
        this.dimensionLabel.setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(4, 105, 80, 14));
        toplevel.addChild((Widget)this.dimensionLabel);
        this.progressLabel = new Label(this.field_146297_k, (Gui)this).setText("");
        this.progressLabel.setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(4, 135, 80, 14));
        toplevel.addChild((Widget)this.progressLabel);
        toplevel.setBounds(new Rectangle(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g));
        this.window = new Window((GuiScreen)this, (Widget)toplevel);
        this.move(0, 0, 0);
        this.filterCnt = this.countFilters();
        ((ScannerTileEntity)this.tileEntity).requestRfFromServer("rftools");
    }

    private void initRedstoneMode() {
        this.redstoneMode = new ImageChoiceLabel(this.field_146297_k, (Gui)this).addChoiceEvent((parent, newChoice) -> this.changeRedstoneMode()).addChoice(RedstoneMode.REDSTONE_IGNORED.getDescription(), "Redstone mode:\nIgnored", iconGuiElements, 0, 0).addChoice(RedstoneMode.REDSTONE_OFFREQUIRED.getDescription(), "Redstone mode:\nOff to activate", iconGuiElements, 16, 0).addChoice(RedstoneMode.REDSTONE_ONREQUIRED.getDescription(), "Redstone mode:\nOn to activate", iconGuiElements, 32, 0);
        this.redstoneMode.setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(50, 156, 16, 16));
        this.redstoneMode.setCurrentChoice(((ScannerTileEntity)this.tileEntity).getRSMode().ordinal());
    }

    private void changeRedstoneMode() {
        ((ScannerTileEntity)this.tileEntity).setRSMode(RedstoneMode.values()[this.redstoneMode.getCurrentChoiceIndex()]);
        this.sendServerCommand(RFToolsMessages.INSTANCE, "setMode", new Argument[]{new Argument("rs", RedstoneMode.values()[this.redstoneMode.getCurrentChoiceIndex()].getDescription())});
    }

    private void scan() {
        this.sendServerCommand(this.network, "scan", new Argument[0]);
    }

    private int countFilters() {
        int cnt = 0;
        if (this.field_147002_h.func_75139_a(0).func_75216_d()) {
            ++cnt;
        }
        if (this.field_147002_h.func_75139_a(2).func_75216_d()) {
            ++cnt;
        }
        if (this.field_147002_h.func_75139_a(3).func_75216_d()) {
            ++cnt;
        }
        return cnt;
    }

    private void move(int x, int y, int z) {
        BlockPos offset = ((ScannerTileEntity)this.tileEntity).getDataOffset();
        int offsetX = offset.func_177958_n() + x;
        int offsetY = offset.func_177956_o() + y;
        int offsetZ = offset.func_177952_p() + z;
        this.sendServerCommand(this.network, "setOffset", new Argument[]{new Argument("offsetX", offsetX), new Argument("offsetY", offsetY), new Argument("offsetZ", offsetZ)});
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        this.getShapeRenderer().handleShapeDragging(x -= this.field_147003_i, y -= this.field_147009_r);
    }

    @Override
    public int getPreviewLeft() {
        return this.getGuiLeft();
    }

    @Override
    public int getPreviewTop() {
        return this.getGuiTop();
    }

    protected void func_146976_a(float v, int x, int y) {
        this.getShapeRenderer().handleMouseWheel();
        this.offsetLabel.setText("Off: " + BlockPosTools.toString((BlockPos)((ScannerTileEntity)this.tileEntity).getDataOffset()));
        this.dimensionLabel.setText("Dim: " + BlockPosTools.toString((BlockPos)((ScannerTileEntity)this.tileEntity).getDataDim()));
        this.drawWindow();
        int currentRF = GenericEnergyStorageTileEntity.getCurrentRF();
        this.energyBar.setValue(currentRF);
        ((ScannerTileEntity)this.tileEntity).requestRfFromServer("rftools");
        boolean instack = this.field_147002_h.func_75139_a(0).func_75216_d();
        if (currentRF < ScannerConfiguration.SCANNER_PERTICK) {
            instack = false;
        }
        if (((ScannerTileEntity)this.tileEntity).getScanProgress() >= 0) {
            instack = false;
            this.progressLabel.setText(((ScannerTileEntity)this.tileEntity).getScanProgress() + "%");
        } else {
            this.progressLabel.setText("");
        }
        this.scanButton.setEnabled(instack);
        ItemStack stack = ((ScannerTileEntity)this.tileEntity).getRenderStack();
        if (!stack.func_190926_b()) {
            int cnt = this.countFilters();
            if (cnt != this.filterCnt) {
                this.filterCnt = cnt;
                this.move(0, 0, 0);
            }
            this.getShapeRenderer().setShapeID(this.getShapeID());
            this.getShapeRenderer().renderShape(this, stack, this.field_147003_i, this.field_147009_r, this.showAxis.isPressed(), this.showOuter.isPressed(), this.showScan.isPressed(), false);
        }
    }
}

