/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.storage;

import java.util.List;
import javax.annotation.Nonnull;
import mcjty.lib.varia.ItemStackList;
import mcjty.rftools.blocks.storage.ModularStorageSetup;
import mcjty.rftools.craftinggrid.CraftingGrid;
import mcjty.rftools.craftinggrid.CraftingGridProvider;
import mcjty.rftools.craftinggrid.InventoriesItemSource;
import mcjty.rftools.craftinggrid.StorageCraftingTools;
import mcjty.rftools.items.storage.StorageModuleItem;
import mcjty.rftools.jei.JEIRecipeAcceptor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;

public class ModularStorageItemInventory
implements CraftingGridProvider,
JEIRecipeAcceptor,
IInventory {
    private ItemStackList stacks;
    private final EntityPlayer entityPlayer;
    private CraftingGrid craftingGrid = new CraftingGrid();
    private ItemStack storageItem = null;

    public ModularStorageItemInventory(EntityPlayer player, ItemStack storageItem) {
        this.entityPlayer = player;
        this.storageItem = storageItem;
        int maxSize = this.getMaxSize();
        this.stacks = ItemStackList.create((int)maxSize);
        NBTTagList bufferTagList = this.getStorageItem().func_77978_p().func_150295_c("Items", 10);
        for (int i = 0; i < Math.min(bufferTagList.func_74745_c(), maxSize); ++i) {
            NBTTagCompound nbtTagCompound = bufferTagList.func_150305_b(i);
            this.stacks.set(i, (Object)new ItemStack(nbtTagCompound));
        }
    }

    public ModularStorageItemInventory(EntityPlayer player) {
        this.entityPlayer = player;
        int maxSize = this.getMaxSize();
        this.stacks = ItemStackList.create((int)maxSize);
        NBTTagCompound tagCompound = this.getStorageItem().func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            this.getStorageItem().func_77982_d(tagCompound);
        }
        tagCompound.func_74768_a("maxSize", maxSize);
        NBTTagList bufferTagList = tagCompound.func_150295_c("Items", 10);
        for (int i = 0; i < Math.min(bufferTagList.func_74745_c(), maxSize); ++i) {
            NBTTagCompound nbtTagCompound = bufferTagList.func_150305_b(i);
            this.stacks.set(i, (Object)new ItemStack(nbtTagCompound));
        }
        this.craftingGrid.readFromNBT(tagCompound.func_74775_l("grid"));
    }

    private ItemStack getStorageItem() {
        if (this.storageItem != null) {
            return this.storageItem;
        }
        return this.entityPlayer.func_184586_b(EnumHand.MAIN_HAND);
    }

    @Override
    public void setGridContents(List<ItemStack> stacks) {
        for (int i = 0; i < stacks.size(); ++i) {
            this.craftingGrid.getCraftingGridInventory().func_70299_a(i, stacks.get(i));
        }
        this.func_70296_d();
    }

    @Override
    public void storeRecipe(int index) {
        this.getCraftingGrid().storeRecipe(index);
    }

    @Override
    public void setRecipe(int index, ItemStack[] stacks) {
        this.craftingGrid.setRecipe(index, stacks);
        this.func_70296_d();
    }

    @Override
    public CraftingGrid getCraftingGrid() {
        return this.craftingGrid;
    }

    @Override
    public void markInventoryDirty() {
        this.func_70296_d();
    }

    @Override
    @Nonnull
    public int[] craft(EntityPlayerMP player, int n, boolean test) {
        InventoriesItemSource itemSource = new InventoriesItemSource().add((IInventory)player.field_71071_by, 0).add(this, 0);
        if (test) {
            return StorageCraftingTools.testCraftItems(player, n, this.craftingGrid.getActiveRecipe(), itemSource);
        }
        StorageCraftingTools.craftItems(player, n, this.craftingGrid.getActiveRecipe(), itemSource);
        return new int[0];
    }

    private int getMaxSize() {
        ItemStack heldItem = this.getStorageItem();
        if (heldItem.func_190926_b()) {
            return 0;
        }
        if (heldItem.func_77973_b() != ModularStorageSetup.storageModuleTabletItem) {
            return 0;
        }
        if (heldItem.func_77978_p() == null) {
            return 0;
        }
        return StorageModuleItem.MAXSIZE[heldItem.func_77978_p().func_74762_e("childDamage")];
    }

    public ItemStackList getStacks() {
        return this.stacks;
    }

    public int func_70302_i_() {
        return this.getMaxSize();
    }

    public ItemStack func_70301_a(int index) {
        if (index >= this.getMaxSize()) {
            return ItemStack.field_190927_a;
        }
        return (ItemStack)this.stacks.get(index);
    }

    public ItemStack func_70298_a(int index, int amount) {
        if (index >= this.stacks.size()) {
            return ItemStack.field_190927_a;
        }
        if (!((ItemStack)this.stacks.get(index)).func_190926_b()) {
            if (((ItemStack)this.stacks.get(index)).func_190916_E() <= amount) {
                ItemStack old = (ItemStack)this.stacks.get(index);
                this.stacks.set(index, (Object)ItemStack.field_190927_a);
                this.func_70296_d();
                return old;
            }
            ItemStack its = ((ItemStack)this.stacks.get(index)).func_77979_a(amount);
            if (((ItemStack)this.stacks.get(index)).func_190926_b()) {
                this.stacks.set(index, (Object)ItemStack.field_190927_a);
            }
            this.func_70296_d();
            return its;
        }
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (index >= this.stacks.size()) {
            return;
        }
        this.stacks.set(index, (Object)stack);
        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            int amount = this.func_70297_j_();
            if (amount <= 0) {
                stack.func_190920_e(0);
            } else {
                stack.func_190920_e(amount);
            }
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        NBTTagList bufferTagList = new NBTTagList();
        int numStacks = 0;
        for (int i = 0; i < this.getMaxSize(); ++i) {
            ItemStack stack = (ItemStack)this.stacks.get(i);
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            if (!stack.func_190926_b()) {
                stack.func_77955_b(nbtTagCompound);
                if (stack.func_190916_E() > 0) {
                    ++numStacks;
                }
            }
            bufferTagList.func_74742_a((NBTBase)nbtTagCompound);
        }
        NBTTagCompound tagCompound = this.getStorageItem().func_77978_p();
        tagCompound.func_74782_a("Items", (NBTBase)bufferTagList);
        tagCompound.func_74768_a("count", numStacks);
        tagCompound.func_74782_a("grid", (NBTBase)this.craftingGrid.writeToNBT());
    }

    public boolean isUsable(EntityPlayer player) {
        return true;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index < this.getMaxSize();
    }

    public ItemStack func_70304_b(int index) {
        ItemStack stack = this.func_70301_a(index);
        this.func_70299_a(index, ItemStack.field_190927_a);
        return stack;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public String func_70005_c_() {
        return "modular storage";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.isUsable(player);
    }

    public boolean func_191420_l() {
        return false;
    }
}

