/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.storage;

import java.util.HashMap;
import java.util.Map;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.rftools.blocks.storage.RemoteStorageTileEntity;
import mcjty.rftools.varia.RFToolsTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.DimensionManager;

public class RemoteStorageIdRegistry
extends WorldSavedData {
    public static final String RFTOOLS_REMOTE_STORAGE = "RFToolsRemoteStorage";
    private static RemoteStorageIdRegistry instance = null;
    private int lastId = 0;
    private Map<Integer, GlobalCoordinate> storages = new HashMap<Integer, GlobalCoordinate>();
    private Map<Integer, Long> lastPublishTime = new HashMap<Integer, Long>();

    public RemoteStorageIdRegistry(String identifier) {
        super(identifier);
    }

    public void save(World world) {
        world.func_72823_a(RFTOOLS_REMOTE_STORAGE, (WorldSavedData)this);
        this.func_76185_a();
    }

    public static void clearInstance() {
        instance = null;
    }

    public static RemoteStorageIdRegistry getRegistry(World world) {
        if (world.field_72995_K) {
            return null;
        }
        if (instance != null) {
            return instance;
        }
        instance = (RemoteStorageIdRegistry)world.func_72943_a(RemoteStorageIdRegistry.class, RFTOOLS_REMOTE_STORAGE);
        if (instance == null) {
            instance = new RemoteStorageIdRegistry(RFTOOLS_REMOTE_STORAGE);
        }
        return instance;
    }

    public static RemoteStorageTileEntity getRemoteStorage(World world, int id) {
        RemoteStorageIdRegistry registry = RemoteStorageIdRegistry.getRegistry(world);
        if (registry == null) {
            return null;
        }
        GlobalCoordinate coordinate = registry.getStorage(id);
        if (coordinate == null) {
            return null;
        }
        WorldServer w = DimensionManager.getWorld((int)coordinate.getDimension());
        if (w == null) {
            return null;
        }
        BlockPos c = coordinate.getCoordinate();
        boolean exists = RFToolsTools.chunkLoaded((World)w, c);
        if (!exists) {
            return null;
        }
        TileEntity te = w.func_175625_s(c);
        if (te instanceof RemoteStorageTileEntity) {
            RemoteStorageTileEntity remoteStorageTileEntity = (RemoteStorageTileEntity)te;
            int index = remoteStorageTileEntity.findRemoteIndex(id);
            if (index == -1) {
                return null;
            }
            if (remoteStorageTileEntity.isGlobal(index) || world.field_73011_w.getDimension() == coordinate.getDimension()) {
                return remoteStorageTileEntity;
            }
            return null;
        }
        return null;
    }

    public void publishStorage(int id, GlobalCoordinate coordinate) {
        long time = System.currentTimeMillis();
        this.storages.put(id, coordinate);
        this.lastPublishTime.put(id, time);
    }

    public GlobalCoordinate getStorage(int id) {
        long time = System.currentTimeMillis();
        if (!this.storages.containsKey(id)) {
            return null;
        }
        long t = this.lastPublishTime.get(id);
        if (time > t + 500L) {
            return null;
        }
        return this.storages.get(id);
    }

    public int getNewId() {
        ++this.lastId;
        return this.lastId;
    }

    public void func_76184_a(NBTTagCompound tagCompound) {
        this.lastId = tagCompound.func_74762_e("lastId");
    }

    public NBTTagCompound func_189551_b(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("lastId", this.lastId);
        return tagCompound;
    }
}

