/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.storagemonitor;

import io.netty.buffer.ByteBuf;
import java.util.Optional;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.network.clientinfo.InfoPacketClient;
import mcjty.lib.network.clientinfo.InfoPacketServer;
import mcjty.rftools.blocks.storagemonitor.ScannerInfoPacketClient;
import mcjty.rftools.blocks.storagemonitor.StorageScannerTileEntity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class ScannerInfoPacketServer
implements InfoPacketServer {
    private int dimension;
    private BlockPos pos;

    public ScannerInfoPacketServer() {
    }

    public ScannerInfoPacketServer(int dimension, BlockPos pos) {
        this.dimension = dimension;
        this.pos = pos;
    }

    public void fromBytes(ByteBuf buf) {
        this.dimension = buf.readInt();
        this.pos = NetworkTools.readPos((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dimension);
        NetworkTools.writePos((ByteBuf)buf, (BlockPos)this.pos);
    }

    public Optional<InfoPacketClient> onMessageServer(EntityPlayerMP player) {
        TileEntity te;
        WorldServer world = DimensionManager.getWorld((int)this.dimension);
        int rf = -1;
        boolean export = false;
        if (world != null && (te = world.func_175625_s(this.pos)) instanceof StorageScannerTileEntity) {
            StorageScannerTileEntity tileEntity = (StorageScannerTileEntity)te;
            rf = tileEntity.getEnergyStored();
            export = tileEntity.isExportToCurrent();
        }
        return Optional.of(new ScannerInfoPacketClient(rf, export));
    }
}

