/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.craftinggrid;

import java.awt.Rectangle;
import mcjty.lib.base.ModBase;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.container.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.events.DefaultSelectionEvent;
import mcjty.lib.gui.events.SelectionEvent;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.LayoutHint;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;
import mcjty.rftools.BlockInfo;
import mcjty.rftools.blocks.crafter.CraftingRecipe;
import mcjty.rftools.craftinggrid.CraftingGridInventory;
import mcjty.rftools.craftinggrid.CraftingGridProvider;
import mcjty.rftools.craftinggrid.PacketCraftFromGrid;
import mcjty.rftools.craftinggrid.PacketGridToServer;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import org.lwjgl.input.Mouse;

public class GuiCraftingGrid {
    private static final ResourceLocation iconLocation = new ResourceLocation("rftools", "textures/gui/craftinggrid.png");
    protected Window craftWindow;
    private Button craft1Button;
    private Button craft4Button;
    private Button craft8Button;
    private Button craftSButton;
    private Button storeButton;
    private WidgetList recipeList;
    private Minecraft mc;
    private GenericGuiContainer gui;
    private CraftingGridProvider provider;
    private BlockPos pos;
    public static int[] testResultFromServer = null;
    private int lastTestAmount = -2;
    private int lastTestTimer = 0;

    public void initGui(ModBase modBase, SimpleNetworkWrapper network, Minecraft mc, GenericGuiContainer gui, BlockPos pos, CraftingGridProvider provider, int guiLeft, int guiTop, int xSize, int ySize) {
        this.mc = mc;
        this.gui = gui;
        SimpleNetworkWrapper network1 = network;
        this.provider = provider;
        this.pos = pos;
        this.recipeList = (WidgetList)new WidgetList(mc, (Gui)gui).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(5, 5, 56, 102));
        this.recipeList.addSelectionEvent((SelectionEvent)new DefaultSelectionEvent(){

            public void select(Widget parent, int index) {
            }

            public void doubleClick(Widget parent, int index) {
                GuiCraftingGrid.this.selectRecipe();
            }
        });
        this.craft1Button = ((Button)((Button)((Button)new Button(mc, (Gui)gui).setText("1")).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(29, 183, 14, 10))).setTooltips(new String[]{"Craft one"})).addButtonEvent(parent -> this.craft(1));
        this.craft4Button = ((Button)((Button)((Button)new Button(mc, (Gui)gui).setText("4")).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(45, 183, 14, 10))).setTooltips(new String[]{"Craft four"})).addButtonEvent(parent -> this.craft(4));
        this.craft8Button = ((Button)((Button)((Button)new Button(mc, (Gui)gui).setText("8")).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(29, 195, 14, 10))).setTooltips(new String[]{"Craft eight"})).addButtonEvent(parent -> this.craft(8));
        this.craftSButton = ((Button)((Button)((Button)new Button(mc, (Gui)gui).setText("*")).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(45, 195, 14, 10))).setTooltips(new String[]{"Craft a stack"})).addButtonEvent(parent -> this.craft(-1));
        this.storeButton = ((Button)((Button)((Button)new Button(mc, (Gui)gui).setText("Store")).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(5, 109, 56, 14))).setTooltips(new String[]{"Store the current recipe"})).addButtonEvent(parent -> this.store());
        Panel sidePanel = (Panel)((Panel)((Panel)((Panel)((Panel)((Panel)new Panel(mc, (Gui)gui).setLayout((Layout)new PositionalLayout()).addChild((Widget)this.craft1Button)).addChild((Widget)this.craft4Button)).addChild((Widget)this.craft8Button)).addChild((Widget)this.craftSButton)).addChild((Widget)this.storeButton)).addChild((Widget)this.recipeList);
        int sideLeft = guiLeft - CraftingGridInventory.GRID_WIDTH - 2;
        int sideTop = guiTop;
        sidePanel.setBounds(new Rectangle(sideLeft, sideTop, CraftingGridInventory.GRID_WIDTH, CraftingGridInventory.GRID_HEIGHT));
        sidePanel.setBackground(iconLocation);
        this.craftWindow = new Window((GuiScreen)gui, (Widget)sidePanel);
    }

    public Window getWindow() {
        return this.craftWindow;
    }

    private void craft(int n) {
        RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketCraftFromGrid(this.pos, n, false));
    }

    private void testCraft(int n) {
        if (this.lastTestAmount != n || this.lastTestTimer <= 0) {
            RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketCraftFromGrid(this.pos, n, true));
            this.lastTestAmount = n;
            this.lastTestTimer = 20;
        }
        --this.lastTestTimer;
    }

    private void store() {
        int selected = this.recipeList.getSelected();
        if (selected == -1) {
            return;
        }
        this.provider.storeRecipe(selected);
        RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketGridToServer(this.pos, this.provider.getCraftingGrid()));
    }

    private void selectRecipe() {
        int selected = this.recipeList.getSelected();
        if (selected == -1) {
            return;
        }
        this.provider.getCraftingGrid().selectRecipe(selected);
        RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketGridToServer(this.pos, this.provider.getCraftingGrid()));
    }

    private void populateList() {
        this.recipeList.removeChildren();
        for (int i = 0; i < 6; ++i) {
            CraftingRecipe recipe = this.provider.getCraftingGrid().getRecipe(i);
            this.addRecipeLine(recipe.getResult());
        }
    }

    public void draw() {
        int selected = this.recipeList.getSelected();
        this.storeButton.setEnabled(selected != -1);
        this.populateList();
        this.testRecipe();
        int x = Mouse.getEventX() * this.gui.field_146294_l / this.gui.field_146297_k.field_71443_c;
        int y = this.gui.field_146295_m - Mouse.getEventY() * this.gui.field_146295_m / this.gui.field_146297_k.field_71440_d - 1;
        Widget widget = this.craftWindow.getToplevel().getWidgetAtPosition(x, y);
        if (widget == this.craft1Button) {
            this.testCraft(1);
        } else if (widget == this.craft4Button) {
            this.testCraft(4);
        } else if (widget == this.craft8Button) {
            this.testCraft(8);
        } else if (widget == this.craftSButton) {
            this.testCraft(-1);
        } else {
            testResultFromServer = null;
            this.lastTestAmount = -2;
            this.lastTestTimer = 0;
        }
        this.craftWindow.draw();
        if (testResultFromServer != null) {
            Slot slot;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.gui.getGuiLeft(), (float)this.gui.getGuiTop(), (float)0.0f);
            if (testResultFromServer[9] > 0 && (slot = this.gui.field_147002_h.func_75147_a((IInventory)this.provider.getCraftingGrid().getCraftingGridInventory(), CraftingGridInventory.SLOT_GHOSTOUTPUT)) != null) {
                GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
                int xPos = slot.field_75223_e;
                int yPos = slot.field_75221_f;
                GenericGuiContainer.func_73734_a((int)xPos, (int)yPos, (int)(xPos + 16), (int)(yPos + 16), (int)-65536);
            }
            for (int i = 0; i < 9; ++i) {
                Slot slot2;
                if (testResultFromServer[i] <= 0 || (slot2 = this.gui.field_147002_h.func_75147_a((IInventory)this.provider.getCraftingGrid().getCraftingGridInventory(), CraftingGridInventory.SLOT_GHOSTINPUT + i)) == null) continue;
                GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
                int xPos = slot2.field_75223_e;
                int yPos = slot2.field_75221_f;
                GenericGuiContainer.func_73734_a((int)xPos, (int)yPos, (int)(xPos + 16), (int)(yPos + 16), (int)-65536);
            }
            GlStateManager.func_179121_F();
        }
    }

    private void testRecipe() {
        InventoryCrafting inv = new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer var1) {
                return false;
            }
        }, 3, 3);
        for (int i = 0; i < 9; ++i) {
            inv.func_70299_a(i, this.provider.getCraftingGrid().getCraftingGridInventory().func_70301_a(i + 1));
        }
        IRecipe recipe = CraftingRecipe.findRecipe((World)this.mc.field_71441_e, inv);
        ItemStack newResult = recipe == null ? ItemStack.field_190927_a : recipe.func_77572_b(inv);
        this.provider.getCraftingGrid().getCraftingGridInventory().func_70299_a(0, newResult);
    }

    private void addRecipeLine(ItemStack craftingResult) {
        String readableName = BlockInfo.getReadableName(craftingResult, 0);
        int color = StyleConfig.colorTextInListNormal;
        if (craftingResult.func_190926_b()) {
            readableName = "<recipe>";
            color = -11513776;
        }
        Panel panel = (Panel)((Panel)new Panel(this.mc, (Gui)this.gui).setLayout((Layout)new PositionalLayout()).addChild((Widget)new BlockRender(this.mc, (Gui)this.gui).setRenderItem((Object)craftingResult).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(0, 0, 18, 18)))).addChild((Widget)new Label(this.mc, (Gui)this.gui).setColor(color).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT).setText(readableName).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(20, 0, 30, 18)));
        this.recipeList.addChild((Widget)panel);
    }
}

