/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.craftinggrid;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.network.NetworkTools;
import mcjty.rftools.blocks.crafter.CraftingRecipe;
import mcjty.rftools.blocks.storage.ModularStorageItemContainer;
import mcjty.rftools.blocks.storage.ModularStorageSetup;
import mcjty.rftools.blocks.storage.RemoteStorageItemContainer;
import mcjty.rftools.blocks.storagemonitor.StorageScannerContainer;
import mcjty.rftools.craftinggrid.CraftingGrid;
import mcjty.rftools.craftinggrid.CraftingGridProvider;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class PacketGridSync {
    private BlockPos pos;
    private List<ItemStack[]> recipes;

    public void convertFromBytes(ByteBuf buf) {
        this.pos = buf.readBoolean() ? NetworkTools.readPos((ByteBuf)buf) : null;
        int s = buf.readInt();
        this.recipes = new ArrayList<ItemStack[]>(s);
        for (int i = 0; i < s; ++i) {
            int ss = buf.readInt();
            ItemStack[] stacks = new ItemStack[ss];
            for (int j = 0; j < ss; ++j) {
                stacks[j] = buf.readBoolean() ? NetworkTools.readItemStack((ByteBuf)buf) : ItemStack.field_190927_a;
            }
            this.recipes.add(stacks);
        }
    }

    public void convertToBytes(ByteBuf buf) {
        if (this.pos != null) {
            buf.writeBoolean(true);
            NetworkTools.writePos((ByteBuf)buf, (BlockPos)this.pos);
        } else {
            buf.writeBoolean(false);
        }
        buf.writeInt(this.recipes.size());
        for (ItemStack[] recipe : this.recipes) {
            buf.writeInt(recipe.length);
            for (ItemStack stack : recipe) {
                if (!stack.func_190926_b()) {
                    buf.writeBoolean(true);
                    NetworkTools.writeItemStack((ByteBuf)buf, (ItemStack)stack);
                    continue;
                }
                buf.writeBoolean(false);
            }
        }
    }

    protected void init(BlockPos pos, CraftingGrid grid) {
        this.pos = pos;
        this.recipes = new ArrayList<ItemStack[]>();
        for (int i = 0; i < 6; ++i) {
            CraftingRecipe recipe = grid.getRecipe(i);
            InventoryCrafting inventory = recipe.getInventory();
            ItemStack[] stacks = new ItemStack[10];
            stacks[0] = recipe.getResult();
            for (int j = 0; j < 9; ++j) {
                stacks[j + 1] = inventory.func_70301_a(j);
            }
            this.recipes.add(stacks);
        }
    }

    protected CraftingGridProvider handleMessage(World world, EntityPlayer player) {
        CraftingGridProvider provider = null;
        if (this.pos == null) {
            ItemStack mainhand = player.func_184614_ca();
            if (!mainhand.func_190926_b() && mainhand.func_77973_b() == ModularStorageSetup.storageModuleTabletItem) {
                GenericContainer storageItemContainer;
                if (player.field_71070_bA instanceof ModularStorageItemContainer) {
                    storageItemContainer = (ModularStorageItemContainer)player.field_71070_bA;
                    provider = storageItemContainer.getCraftingGridProvider();
                } else if (player.field_71070_bA instanceof RemoteStorageItemContainer) {
                    storageItemContainer = (RemoteStorageItemContainer)player.field_71070_bA;
                    provider = storageItemContainer.getCraftingGridProvider();
                } else if (player.field_71070_bA instanceof StorageScannerContainer) {
                    storageItemContainer = (StorageScannerContainer)player.field_71070_bA;
                    provider = storageItemContainer.getStorageScannerTileEntity();
                }
            }
        } else {
            TileEntity te = world.func_175625_s(this.pos);
            if (te instanceof CraftingGridProvider) {
                provider = (CraftingGridProvider)te;
            }
        }
        if (provider != null) {
            for (int i = 0; i < this.recipes.size(); ++i) {
                provider.setRecipe(i, this.recipes.get(i));
            }
        }
        return provider;
    }
}

