/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.integration.computers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.prefab.AbstractManagedEnvironment;
import mcjty.lib.integration.computers.AbstractOCDriver;
import mcjty.rftools.blocks.teleporter.DialingDeviceTileEntity;
import mcjty.rftools.blocks.teleporter.MatterReceiverTileEntity;
import mcjty.rftools.blocks.teleporter.MatterTransmitterTileEntity;
import mcjty.rftools.blocks.teleporter.TeleportDestinations;
import mcjty.rftools.blocks.teleporter.TeleportationTools;
import mcjty.rftools.blocks.teleporter.TransmitterInfo;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DialingDeviceDriver {

    public static class OCDriver
    extends AbstractOCDriver {
        public OCDriver() {
            super("rftools_dialing_device", DialingDeviceTileEntity.class);
        }

        public AbstractManagedEnvironment createEnvironment(World world, BlockPos pos, EnumFacing side, TileEntity tile) {
            return new InternalManagedEnvironment((DialingDeviceTileEntity)tile);
        }

        public static class InternalManagedEnvironment
        extends AbstractOCDriver.InternalManagedEnvironment<DialingDeviceTileEntity> {
            public InternalManagedEnvironment(DialingDeviceTileEntity tile) {
                super((Object)tile, "rftools_dialing_device");
            }

            @Callback(doc="function():number; Get the currently stored energy")
            public Object[] getEnergy(Context c, Arguments a) {
                return new Object[]{((DialingDeviceTileEntity)((Object)this.tile)).getEnergyStored()};
            }

            @Callback(doc="function():number; Get the maximum stored energy")
            public Object[] getMaxEnergy(Context c, Arguments a) {
                return new Object[]{((DialingDeviceTileEntity)((Object)this.tile)).getMaxEnergyStored()};
            }

            @Callback(doc="function():table; Get a list of nearby matter transmitters")
            public Object[] getTransmitters(Context c, Arguments a) {
                List<TransmitterInfo> transmitters = ((DialingDeviceTileEntity)((Object)this.tile)).searchTransmitters();
                List ret = transmitters.stream().map(info -> {
                    String name = info.getName();
                    Map<String, Integer> pos = InternalManagedEnvironment.getCoordinateMap(info.getCoordinate());
                    boolean dialed = false;
                    TileEntity transmitterTE = ((DialingDeviceTileEntity)((Object)((Object)this.tile))).func_145831_w().func_175625_s(info.getCoordinate());
                    if (transmitterTE instanceof MatterTransmitterTileEntity) {
                        MatterTransmitterTileEntity transmitter = (MatterTransmitterTileEntity)transmitterTE;
                        dialed = true;
                    }
                    HashMap<String, Object> transmitterInfo = new HashMap<String, Object>();
                    transmitterInfo.put("name", name);
                    transmitterInfo.put("position", pos);
                    transmitterInfo.put("dialed", dialed);
                    return transmitterInfo;
                }).collect(Collectors.toList());
                return new Object[]{ret};
            }

            @Callback(doc="function():table; Get a list of valid matter receivers")
            public Object[] getReceivers(Context c, Arguments a) {
                TeleportDestinations receivers = TeleportDestinations.getDestinations(((DialingDeviceTileEntity)((Object)this.tile)).func_145831_w());
                List ret = receivers.getValidDestinations(((DialingDeviceTileEntity)((Object)this.tile)).func_145831_w(), null).stream().map(destination -> {
                    String name = destination.getName();
                    Map<String, Integer> pos = InternalManagedEnvironment.getCoordinateMap(destination.getCoordinate());
                    int dimension = destination.getDimension();
                    String dimName = destination.getDimensionName();
                    HashMap<String, Object> receiverInfo = new HashMap<String, Object>();
                    receiverInfo.put("name", name);
                    receiverInfo.put("position", pos);
                    receiverInfo.put("dimension", dimension);
                    receiverInfo.put("dimensionName", dimName);
                    return receiverInfo;
                }).collect(Collectors.toList());
                return new Object[]{ret};
            }

            @Callback(doc="function(transmitter:table, receiver:table, targetDim:int, once:bool):true or nil, string; Dial the transmitter to the receiver. The table arguments are their respective positions as returned by getReceivers and getTransmitters")
            public Object[] dial(Context c, Arguments a) {
                Map transmitterSPos = a.checkTable(0);
                Map receiverSPos = a.checkTable(1);
                int targetDim = a.checkInteger(2);
                boolean once = a.checkBoolean(3);
                TileEntity transmitterTE = ((DialingDeviceTileEntity)((Object)this.tile)).func_145831_w().func_175625_s(InternalManagedEnvironment.fromCoordinateMap(transmitterSPos));
                TileEntity receiverTE = TeleportationTools.getWorldForDimension(((DialingDeviceTileEntity)((Object)this.tile)).func_145831_w(), targetDim).func_175625_s(InternalManagedEnvironment.fromCoordinateMap(receiverSPos));
                if (!(transmitterTE instanceof MatterTransmitterTileEntity)) {
                    return new Object[]{null, "Invalid matter transmitter"};
                }
                if (!(receiverTE instanceof MatterReceiverTileEntity)) {
                    return new Object[]{null, "Invalid matter receiver"};
                }
                MatterTransmitterTileEntity transmitter = (MatterTransmitterTileEntity)transmitterTE;
                MatterReceiverTileEntity receiver = (MatterReceiverTileEntity)receiverTE;
                BlockPos transmitterPos = transmitter.func_174877_v();
                BlockPos receiverPos = receiver.func_174877_v();
                TeleportationTools.dial(((DialingDeviceTileEntity)((Object)this.tile)).func_145831_w(), (DialingDeviceTileEntity)((Object)this.tile), null, transmitterPos, ((DialingDeviceTileEntity)((Object)this.tile)).func_145831_w().field_73011_w.getDimension(), receiverPos, targetDim, once);
                return new Object[]{true};
            }

            @Callback(doc="function(transmitter:table):true or nil, string; Interrupt the current beam")
            public Object[] interrupt(Context c, Arguments a) {
                Map transmitterSPos = a.checkTable(0);
                TileEntity transmitterTE = ((DialingDeviceTileEntity)((Object)this.tile)).func_145831_w().func_175625_s(InternalManagedEnvironment.fromCoordinateMap(transmitterSPos));
                if (!(transmitterTE instanceof MatterTransmitterTileEntity)) {
                    return new Object[]{null, "Invalid matter transmitter"};
                }
                MatterTransmitterTileEntity transmitter = (MatterTransmitterTileEntity)transmitterTE;
                BlockPos transmitterPos = transmitter.func_174877_v();
                TeleportationTools.dial(((DialingDeviceTileEntity)((Object)this.tile)).func_145831_w(), (DialingDeviceTileEntity)((Object)this.tile), null, transmitterPos, ((DialingDeviceTileEntity)((Object)this.tile)).func_145831_w().field_73011_w.getDimension(), null, 0, false);
                return new Object[]{true};
            }

            @Callback(doc="function():bool; Returns whether a matter booster is available or not")
            public Object[] isMatterBoosterAvailable(Context c, Arguments a) {
                boolean ret = DialingDeviceTileEntity.isMatterBoosterAvailable(((DialingDeviceTileEntity)((Object)this.tile)).func_145831_w(), ((DialingDeviceTileEntity)((Object)this.tile)).func_174877_v());
                return new Object[]{ret};
            }

            @Callback(doc="function():bool; Returns whether a destination analyzer is available or not")
            public Object[] isDestinationAnalyzerAvailable(Context c, Arguments a) {
                boolean ret = DialingDeviceTileEntity.isDestinationAnalyzerAvailable(((DialingDeviceTileEntity)((Object)this.tile)).func_145831_w(), ((DialingDeviceTileEntity)((Object)this.tile)).func_174877_v());
                return new Object[]{ret};
            }

            @Nonnull
            private static Map<String, Integer> getCoordinateMap(BlockPos pos) {
                HashMap<String, Integer> ret = new HashMap<String, Integer>();
                ret.put("x", pos.func_177958_n());
                ret.put("y", pos.func_177956_o());
                ret.put("z", pos.func_177952_p());
                return ret;
            }

            private static BlockPos fromCoordinateMap(Map<String, Double> map) {
                return new BlockPos(map.get("x").doubleValue(), map.get("y").doubleValue(), map.get("z").doubleValue());
            }

            public int priority() {
                return 4;
            }
        }
    }
}

