/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.tileentity.guide;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import openblocks.OpenBlocks;
import openblocks.client.renderer.tileentity.guide.GuideRendererSelector;
import openblocks.client.renderer.tileentity.guide.IGuideRenderer;
import openblocks.common.tileentity.TileEntityGuide;
import org.lwjgl.opengl.GL11;

public class TileEntityGuideRenderer<T extends TileEntityGuide>
extends TileEntitySpecialRenderer<T> {
    private static final ModelResourceLocation MARKER_MODEL_LOCATION = new ModelResourceLocation(OpenBlocks.location("guide"), "marker");
    private final IGuideRenderer renderer = new GuideRendererSelector().getRenderer();

    public TileEntityGuideRenderer() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public boolean isGlobalRenderer(T te) {
        return ((TileEntityGuide)((Object)te)).shouldRender();
    }

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent evt) {
        IModel model = ModelLoaderRegistry.getModelOrMissing((ResourceLocation)MARKER_MODEL_LOCATION);
        final TextureMap textureMapBlocks = Minecraft.func_71410_x().func_147117_R();
        final IBakedModel bakedModel = model.bake(model.getDefaultState(), DefaultVertexFormats.field_176599_b, (java.util.function.Function)new Function<ResourceLocation, TextureAtlasSprite>(){

            public TextureAtlasSprite apply(ResourceLocation input) {
                return textureMapBlocks.func_110572_b(input.toString());
            }
        });
        this.renderer.onModelBake(new Supplier<BufferBuilder>(){

            public BufferBuilder get() {
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder vertexBuffer = tessellator.func_178180_c();
                vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
                for (EnumFacing enumfacing : EnumFacing.values()) {
                    TileEntityGuideRenderer.renderQuads(vertexBuffer, bakedModel.func_188616_a(null, enumfacing, 0L));
                }
                TileEntityGuideRenderer.renderQuads(vertexBuffer, bakedModel.func_188616_a(null, null, 0L));
                vertexBuffer.func_178977_d();
                return vertexBuffer;
            }
        });
    }

    private static void renderQuads(BufferBuilder vb, List<BakedQuad> quads) {
        for (BakedQuad quad : quads) {
            vb.func_178981_a(quad.func_178209_a());
        }
    }

    public void render(T tileentity, double x, double y, double z, float partialTicks, int destroyStage, float partial) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        this.renderer.renderShape((TileEntityGuide)((Object)tileentity));
        GL11.glPopMatrix();
    }
}

