/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.block;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import openblocks.common.tileentity.TileEntityVacuumHopper;
import openmods.block.OpenBlock;
import openmods.infobook.BookDocumentation;
import openmods.model.variant.VariantModelState;

@BookDocumentation
public class BlockVacuumHopper
extends OpenBlock {
    private static final AxisAlignedBB SELECTION_AABB = new AxisAlignedBB(0.3, 0.3, 0.3, 0.7, 0.7, 0.7);
    private static final AxisAlignedBB COLLISION_AABB = new AxisAlignedBB(0.01, 0.01, 0.01, 0.99, 0.99, 0.99);
    private static final AxisAlignedBB STANDARD_AABB = new AxisAlignedBB(0.25, 0.25, 0.25, 0.75, 0.75, 0.75);

    public BlockVacuumHopper() {
        super(Material.field_151576_e);
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{this.getPropertyOrientation()}, new IUnlistedProperty[]{VariantModelState.PROPERTY});
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return STANDARD_AABB;
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return COLLISION_AABB;
    }

    public AxisAlignedBB func_180640_a(IBlockState state, World world, BlockPos pos) {
        return SELECTION_AABB;
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state instanceof IExtendedBlockState) {
            IExtendedBlockState oldState = (IExtendedBlockState)state;
            TileEntityVacuumHopper te = (TileEntityVacuumHopper)((Object)BlockVacuumHopper.getTileEntity((IBlockAccess)world, (BlockPos)pos, TileEntityVacuumHopper.class));
            if (te != null) {
                VariantModelState selectors = VariantModelState.create(te.getOutputState());
                return oldState.withProperty(VariantModelState.PROPERTY, (Object)selectors);
            }
        }
        return state;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        TileEntityVacuumHopper te = (TileEntityVacuumHopper)((Object)BlockVacuumHopper.getTileEntity((IBlockAccess)world, (BlockPos)pos, TileEntityVacuumHopper.class));
        if (te != null) {
            te.onEntityCollidedWithBlock(entity);
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }
}

