/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.item;

import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.SleepingLocationCheckEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import openblocks.OpenBlocks;
import openblocks.client.model.ModelSleepingBag;
import openmods.infobook.BookDocumentation;
import openmods.utils.BlockUtils;
import openmods.utils.ItemUtils;

@BookDocumentation
public class ItemSleepingBag
extends ItemArmor {
    private static final String TAG_SLEEPING = "Sleeping";
    private static final String TAG_SLOT = "Slot";
    public static final String TEXTURE_SLEEPINGBAG = OpenBlocks.location("textures/models/sleeping_bag.png").toString();

    public ItemSleepingBag() {
        super(ItemArmor.ArmorMaterial.IRON, 2, EntityEquipmentSlot.CHEST);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return TEXTURE_SLEEPINGBAG;
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        return armorSlot == EntityEquipmentSlot.CHEST ? ModelSleepingBag.instance : null;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack heldStack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            ItemStack currentArmor = ItemSleepingBag.getChestpieceSlot(player);
            if (!currentArmor.func_190926_b()) {
                currentArmor = currentArmor.func_77946_l();
            }
            ItemStack sleepingBagCopy = heldStack.func_77946_l();
            NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)sleepingBagCopy);
            tag.func_74768_a(TAG_SLOT, player.field_71071_by.field_70461_c);
            ItemSleepingBag.setChestpieceSlot(player, sleepingBagCopy);
            if (!currentArmor.func_190926_b()) {
                return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)currentArmor);
            }
            heldStack.func_190920_e(0);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)heldStack);
    }

    public boolean isValidArmor(ItemStack stack, EntityEquipmentSlot armorType, Entity entity) {
        return armorType == EntityEquipmentSlot.CHEST;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        if (!(player instanceof EntityPlayerMP)) {
            return;
        }
        if (player.func_70608_bn()) {
            return;
        }
        NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)itemStack);
        if (tag.func_74767_n(TAG_SLEEPING)) {
            tag.func_82580_o(TAG_SLEEPING);
            ItemSleepingBag.getOutOfSleepingBag(player);
        } else if (!ItemSleepingBag.trySleep(world, player)) {
            ItemSleepingBag.getOutOfSleepingBag(player);
        } else {
            tag.func_74757_a(TAG_SLEEPING, true);
        }
    }

    private static boolean trySleep(World world, EntityPlayer player) {
        BlockPos pos = player.func_180425_c();
        if (!ItemSleepingBag.isNotSuffocating(world, pos) || !ItemSleepingBag.isSolidEnough(world, pos.func_177977_b())) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("openblocks.misc.oh_no_ground", new Object[0]));
            return false;
        }
        EntityPlayer.SleepResult sleepResult = player.func_180469_a(pos);
        if (sleepResult == EntityPlayer.SleepResult.OK) {
            return true;
        }
        switch (sleepResult) {
            case NOT_POSSIBLE_NOW: {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("tile.bed.noSleep", new Object[0]));
                break;
            }
            case NOT_SAFE: {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("tile.bed.notSafe", new Object[0]));
                break;
            }
        }
        return false;
    }

    private static boolean isNotSuffocating(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_185890_d((IBlockAccess)world, pos) == null || world.func_175623_d(pos);
    }

    private static boolean isSolidEnough(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        AxisAlignedBB aabb = state.func_185890_d((IBlockAccess)world, pos);
        if (aabb == null) {
            return false;
        }
        double dx = aabb.field_72336_d - aabb.field_72340_a;
        double dy = aabb.field_72337_e - aabb.field_72338_b;
        double dz = aabb.field_72334_f - aabb.field_72339_c;
        return dx >= 0.5 && dy >= 0.5 && dz >= 0.5;
    }

    private static Integer getReturnSlot(NBTTagCompound tag) {
        int slot;
        if (tag.func_150297_b(TAG_SLOT, 99) && (slot = tag.func_74762_e(TAG_SLOT)) < 9 && slot >= 0) {
            return slot;
        }
        return null;
    }

    private static boolean tryReturnToSlot(EntityPlayer player, ItemStack sleepingBag) {
        NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)sleepingBag);
        Integer returnSlot = ItemSleepingBag.getReturnSlot(tag);
        tag.func_82580_o(TAG_SLOT);
        if (returnSlot == null) {
            ItemSleepingBag.setChestpieceSlot(player, ItemStack.field_190927_a);
            return false;
        }
        ItemStack possiblyArmor = (ItemStack)player.field_71071_by.field_70462_a.get(returnSlot.intValue());
        if (ItemSleepingBag.isChestplate(possiblyArmor)) {
            ItemSleepingBag.setChestpieceSlot(player, possiblyArmor);
        } else {
            ItemSleepingBag.setChestpieceSlot(player, ItemStack.field_190927_a);
            if (!possiblyArmor.func_190926_b()) {
                return false;
            }
        }
        player.field_71071_by.func_70299_a(returnSlot.intValue(), sleepingBag);
        return true;
    }

    private static void getOutOfSleepingBag(EntityPlayer player) {
        ItemStack stack = ItemSleepingBag.getChestpieceSlot(player);
        if (ItemSleepingBag.isSleepingBag(stack) && !ItemSleepingBag.tryReturnToSlot(player, stack) && !player.field_71071_by.func_70441_a(stack)) {
            BlockUtils.dropItemStackInWorld((World)player.field_70170_p, (double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v, (ItemStack)stack);
        }
    }

    public static boolean isWearingSleepingBag(EntityPlayer player) {
        ItemStack armor = ItemSleepingBag.getChestpieceSlot(player);
        return ItemSleepingBag.isSleepingBag(armor);
    }

    private static boolean isSleepingBag(ItemStack armor) {
        return !armor.func_190926_b() && armor.func_77973_b() instanceof ItemSleepingBag;
    }

    @Nonnull
    private static ItemStack setChestpieceSlot(EntityPlayer player, @Nonnull ItemStack chestpiece) {
        player.func_184201_a(EntityEquipmentSlot.CHEST, chestpiece);
        return chestpiece;
    }

    @Nonnull
    private static ItemStack getChestpieceSlot(EntityPlayer player) {
        return player.func_184582_a(EntityEquipmentSlot.CHEST);
    }

    private static boolean isChestplate(@Nonnull ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        Item item = stack.func_77973_b();
        if (item instanceof ItemSleepingBag) {
            return false;
        }
        if (item instanceof ItemArmor) {
            ItemArmor armorItem = (ItemArmor)item;
            return armorItem.field_77881_a == EntityEquipmentSlot.CHEST;
        }
        return false;
    }

    public static class IsSleepingHandler {
        @SubscribeEvent
        public void onBedCheck(SleepingLocationCheckEvent evt) {
            if (ItemSleepingBag.isWearingSleepingBag(evt.getEntityPlayer())) {
                evt.setResult(Event.Result.ALLOW);
            }
        }
    }
}

