/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.item;

import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import openblocks.common.CanvasReplaceBlacklist;
import openblocks.common.IStencilPattern;
import openblocks.common.StencilPattern;
import openblocks.common.block.BlockCanvas;
import openblocks.common.tileentity.TileEntityCanvas;

public class ItemStencil
extends Item {
    public ItemStencil() {
        this.func_77627_a(true);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            for (StencilPattern stencil : StencilPattern.values()) {
                list.add((Object)this.createItemStack(stencil));
            }
        }
    }

    public ItemStack createItemStack(StencilPattern stencil) {
        return new ItemStack((Item)this, 1, stencil.ordinal());
    }

    public static Optional<IStencilPattern> getPattern(@Nonnull ItemStack stack) {
        int patternId = stack.func_77960_j();
        try {
            return Optional.of(StencilPattern.values()[patternId]);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return Optional.empty();
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity te;
        if (CanvasReplaceBlacklist.instance.isAllowedToReplace(world, pos)) {
            BlockCanvas.replaceBlock(world, pos);
        }
        if ((te = world.func_175625_s(pos)) instanceof TileEntityCanvas) {
            StencilPattern stencil;
            ItemStack stack = player.func_184586_b(hand);
            TileEntityCanvas canvas = (TileEntityCanvas)te;
            int stencilId = stack.func_77952_i();
            try {
                stencil = StencilPattern.values()[stencilId];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return EnumActionResult.FAIL;
            }
            if (canvas.useStencil(facing, stencil)) {
                stack.func_190918_g(1);
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.PASS;
    }
}

