/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import openblocks.client.gui.GuiItemDropper;
import openblocks.common.container.ContainerItemDropper;
import openblocks.rpc.IItemDropper;
import openmods.api.IHasGui;
import openmods.api.INeighbourAwareTile;
import openmods.fakeplayer.DropItemAction;
import openmods.fakeplayer.FakePlayerPool;
import openmods.fixers.GenericInventoryTeFixerWalker;
import openmods.fixers.RegisterFixer;
import openmods.geometry.Orientation;
import openmods.include.IncludeInterface;
import openmods.inventory.GenericInventory;
import openmods.inventory.IInventoryProvider;
import openmods.inventory.TileEntityInventory;
import openmods.sync.SyncableBoolean;
import openmods.sync.SyncableDouble;
import openmods.tileentity.SyncedTileEntity;

@RegisterFixer(value=GenericInventoryTeFixerWalker.class)
public class TileEntityItemDropper
extends SyncedTileEntity
implements INeighbourAwareTile,
IInventoryProvider,
IHasGui,
IItemDropper {
    static final int BUFFER_SIZE = 9;
    private boolean redstoneState;
    private GenericInventory inventory = this.registerInventoryCallback((GenericInventory)new TileEntityInventory((TileEntity)this, "itemDropper", false, 9));
    private SyncableDouble itemSpeedBase;
    private SyncableBoolean useRedstoneStrength;
    private static final Vector4f DROP_POS = new Vector4f(0.5f, -0.5f, 0.5f, 1.0f);
    private static final Vector3f DROP_V = new Vector3f(0.0f, -1.0f, 0.0f);

    protected void createSyncedFields() {
        this.itemSpeedBase = new SyncableDouble(0.0);
        this.useRedstoneStrength = new SyncableBoolean(false);
    }

    private void setRedstoneSignal(int redstoneSignal) {
        boolean newRedstoneState;
        boolean bl = newRedstoneState = redstoneSignal > 0;
        if (newRedstoneState != this.redstoneState) {
            this.redstoneState = newRedstoneState;
            if (this.redstoneState) {
                float speedMultiplier = (float)(this.itemSpeedBase.get() * (double)(this.useRedstoneStrength.get() ? (float)redstoneSignal / 15.0f : 1.0f));
                this.dropItem(speedMultiplier);
            }
        }
    }

    private void dropItem(float speedMultiplier) {
        if (!(this.field_145850_b instanceof WorldServer)) {
            return;
        }
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            ItemStack stack = this.inventory.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            ItemStack dropped = stack.func_77979_a(1);
            this.inventory.func_70299_a(i, dropped);
            Orientation orientation = this.getOrientation();
            Vector4f worldDrop = new Vector4f();
            Matrix4f blockLocalToWorld = orientation.getBlockLocalToWorldMatrix();
            blockLocalToWorld.transform((Tuple4f)DROP_POS, (Tuple4f)worldDrop);
            Vector3f worldVel = new Vector3f();
            Matrix3f localToWorld = orientation.getLocalToWorldMatrix();
            worldVel.set((Tuple3f)DROP_V);
            worldVel.scale(speedMultiplier);
            localToWorld.transform((Tuple3f)worldVel);
            double worldDropX = (float)this.field_174879_c.func_177958_n() + worldDrop.x;
            double worldDropY = (float)this.field_174879_c.func_177956_o() + worldDrop.y;
            double worldDropZ = (float)this.field_174879_c.func_177952_p() + worldDrop.z;
            DropItemAction action = new DropItemAction(dropped, worldDropX, worldDropY, worldDropZ, worldVel.x, worldVel.y, worldVel.z);
            FakePlayerPool.instance.executeOnPlayer((WorldServer)this.field_145850_b, (FakePlayerPool.PlayerUser)action);
            break;
        }
    }

    public void onNeighbourChanged(BlockPos neighbourPos, Block neighbourBlock) {
        if (!this.field_145850_b.field_72995_K) {
            this.setRedstoneSignal(this.field_145850_b.func_175687_A(this.field_174879_c));
        }
    }

    public Object getServerGui(EntityPlayer player) {
        return new ContainerItemDropper((IInventory)player.field_71071_by, this);
    }

    public Object getClientGui(EntityPlayer player) {
        return new GuiItemDropper(new ContainerItemDropper((IInventory)player.field_71071_by, this));
    }

    public boolean canOpenGui(EntityPlayer player) {
        return true;
    }

    @IncludeInterface
    public IInventory getInventory() {
        return this.inventory;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        this.inventory.writeToNBT(tag);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inventory.readFromNBT(tag);
    }

    @Override
    public void setItemSpeed(double speed) {
        this.itemSpeedBase.set(speed);
        this.sync();
    }

    public double getItemSpeed() {
        return this.itemSpeedBase.get();
    }

    @Override
    public void setUseRedstoneStrength(boolean useRedstone) {
        this.useRedstoneStrength.set(useRedstone);
        this.sync();
    }

    public boolean getUseRedstoneStrength() {
        return this.useRedstoneStrength.get();
    }

    public IItemDropper createRpcProxy() {
        return (IItemDropper)this.createClientRpcProxy(IItemDropper.class, new Class[0]);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventory.getHandler();
        }
        return (T)super.getCapability(capability, facing);
    }
}

