/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.client.feature;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.quark.base.module.Feature;

public class GreenerGrass
extends Feature {
    boolean affectFolliage;
    boolean alphaGrass;
    boolean absoluteValues;
    int redShift;
    int greenShift;
    int blueShift;
    List<String> extraBlocks;

    @Override
    public void setupConfig() {
        this.affectFolliage = this.loadPropBool("Should affect folliage", "", true);
        this.alphaGrass = this.loadPropBool("Alpha grass", "Sets the grass color to be a \"Minecraft Alpha\" tone.\nThis will override all manual shift values.", false);
        this.absoluteValues = this.loadPropBool("Treat shifts as absolute and ignore biome colors", "", false);
        this.redShift = this.loadPropInt("Shift reds by", "", -30);
        this.greenShift = this.loadPropInt("Shift greens by", "", 30);
        this.blueShift = this.loadPropInt("Shift blues by", "", -30);
        this.extraBlocks = Arrays.asList(this.loadPropStringList("Extra blocks", "", new String[]{"buildingbrickscompatvanilla:grass_slab", "buildingbrickscompatvanilla:grass_step", "buildingbrickscompatvanilla:grass_corner", "buildingbrickscompatvanilla:grass_vertical_slab", "buildingbrickscompatvanilla:grass_stairs", "betterwithmods:dirt_slab", "biomesoplenty:plant_0", "biomesoplenty:plant_1", "biomesoplenty:leaves_1", "biomesoplenty:leaves_2", "biomesoplenty:leaves_3", "biomesoplenty:leaves_4", "biomesoplenty:leaves_5", "biomesoplenty:grass"}));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void postInitClient(FMLPostInitializationEvent event) {
        this.registerGreenerColor(new Block[]{Blocks.field_150349_c, Blocks.field_150329_H, Blocks.field_150398_cm, Blocks.field_150436_aH});
        if (this.affectFolliage) {
            this.registerGreenerColor(new Block[]{Blocks.field_150362_t, Blocks.field_150361_u, Blocks.field_150395_bd});
        }
        for (String s : this.extraBlocks) {
            Block b = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(s));
            if (b == null) continue;
            this.registerGreenerColor(b);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void registerGreenerColor(Block ... blocks) {
        BlockColors colors = Minecraft.func_71410_x().func_184125_al();
        Map map = (Map)ReflectionHelper.getPrivateValue(BlockColors.class, (Object)colors, (String[])new String[]{"blockColorMap"});
        for (Block b : blocks) {
            IBlockColor color = (IBlockColor)map.get(b.delegate);
            if (color == null) continue;
            colors.func_186722_a(this.getGreenerColor(color), new Block[]{b});
        }
    }

    @SideOnly(value=Side.CLIENT)
    private IBlockColor getGreenerColor(final IBlockColor color) {
        return new IBlockColor(){

            public int func_186720_a(IBlockState state, IBlockAccess world, BlockPos pos, int tintIndex) {
                int shiftBlue;
                int originalColor = color.func_186720_a(state, world, pos, tintIndex);
                int r = originalColor >> 16 & 0xFF;
                int g = originalColor >> 8 & 0xFF;
                int b = originalColor & 0xFF;
                int shiftRed = GreenerGrass.this.alphaGrass ? 30 : GreenerGrass.this.redShift;
                int shiftGreen = GreenerGrass.this.alphaGrass ? 120 : GreenerGrass.this.greenShift;
                int n = shiftBlue = GreenerGrass.this.alphaGrass ? 30 : GreenerGrass.this.blueShift;
                if (GreenerGrass.this.absoluteValues) {
                    return (Math.max(0, Math.min(255, GreenerGrass.this.redShift)) << 16) + Math.max(0, Math.min(255, GreenerGrass.this.greenShift) << 8) + Math.max(0, Math.min(255, GreenerGrass.this.blueShift));
                }
                return (Math.max(0, Math.min(255, r + shiftRed)) << 16) + Math.max(0, Math.min(255, g + shiftGreen) << 8) + Math.max(0, Math.min(255, b + shiftBlue));
            }
        };
    }
}

