/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.misc.feature;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.MapDecoration;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.quark.base.module.Feature;
import vazkii.quark.misc.recipe.MapPinningRecipe;

public class MapMarkers
extends Feature {
    public static final String TAG_ADD_PIN = "quark:needs_pin";
    boolean useRightClick;

    @Override
    public void setupConfig() {
        this.useRightClick = this.loadPropBool("Use Right Click", "If enabled, replaces the recipe to add the marker with right clicking for the same purpose", false);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        if (!this.useRightClick) {
            new MapPinningRecipe();
        }
    }

    @SubscribeEvent
    public void rightClick(PlayerInteractEvent.RightClickItem event) {
        if (this.useRightClick) {
            MapMarkers.addMarker(event.getItemStack(), event.getEntityPlayer());
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.PlayerTickEvent event) {
        if (!this.useRightClick && event.phase == TickEvent.Phase.END) {
            EntityPlayer player = event.player;
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack stack = player.field_71071_by.func_70301_a(i);
                if (!stack.func_77942_o() || !ItemNBTHelper.getBoolean((ItemStack)stack, (String)TAG_ADD_PIN, (boolean)false)) continue;
                MapMarkers.addMarker(stack, player);
                ItemNBTHelper.setBoolean((ItemStack)stack, (String)TAG_ADD_PIN, (boolean)false);
            }
        }
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    public static void addMarker(ItemStack stack, EntityPlayer player) {
        MapData data;
        if (stack.func_77973_b() == Items.field_151098_aY && (data = Items.field_151098_aY.func_77873_a(stack, player.field_70170_p)) != null) {
            MapData.func_191094_a((ItemStack)stack, (BlockPos)player.func_180425_c(), (String)("Pin" + player.func_180425_c().hashCode()), (MapDecoration.Type)MapDecoration.Type.TARGET_X);
        }
    }
}

