/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.misc.item;

import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import vazkii.arl.item.ItemMod;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.quark.base.item.IQuarkItem;

public class ItemSlimeBucket
extends ItemMod
implements IQuarkItem {
    public static final String TAG_ENTITY_DATA = "slime_nbt";
    public static final String[] VARIANTS = new String[]{"slime_bucket_normal", "slime_bucket_excited"};

    public ItemSlimeBucket() {
        super("slime_bucket", VARIANTS);
        this.func_77625_d(1);
        this.func_77637_a(CreativeTabs.field_78026_f);
        this.func_77642_a(Items.field_151133_ar);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            subItems.add((Object)new ItemStack((Item)this));
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int something, boolean somethingelse) {
        if (!world.field_72995_K) {
            int newMeta;
            int x = MathHelper.func_76128_c((double)entity.field_70165_t);
            int z = MathHelper.func_76128_c((double)entity.field_70161_v);
            boolean slime = ItemSlimeBucket.isSlimeChunk(world, x, z);
            int meta = stack.func_77952_i();
            int n = newMeta = slime ? 1 : 0;
            if (meta != newMeta) {
                stack.func_77964_b(newMeta);
            }
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        double x = (double)pos.func_177958_n() + 0.5 + (double)facing.func_82601_c();
        double y = (double)pos.func_177956_o() + 0.5 + (double)facing.func_96559_d();
        double z = (double)pos.func_177952_p() + 0.5 + (double)facing.func_82599_e();
        if (!worldIn.field_72995_K) {
            EntitySlime slime = new EntitySlime(worldIn);
            NBTTagCompound data = ItemNBTHelper.getCompound((ItemStack)playerIn.func_184586_b(hand), (String)TAG_ENTITY_DATA, (boolean)true);
            if (data != null) {
                slime.func_70020_e(data);
            } else {
                slime.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(1.0);
                slime.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
                slime.func_70606_j(slime.func_110138_aP());
            }
            slime.func_70107_b(x, y, z);
            worldIn.func_72838_d((Entity)slime);
            playerIn.func_184609_a(hand);
        }
        playerIn.func_184611_a(hand, new ItemStack(Items.field_151133_ar));
        return EnumActionResult.SUCCESS;
    }

    public String func_77653_i(ItemStack stack) {
        NBTTagCompound cmp;
        if (stack.func_77942_o() && (cmp = ItemNBTHelper.getCompound((ItemStack)stack, (String)TAG_ENTITY_DATA, (boolean)true)).func_74764_b("CustomName")) {
            return I18n.func_135052_a((String)"item.quark:slime_bucket_named.name", (Object[])new Object[]{cmp.func_74779_i("CustomName")});
        }
        return super.func_77653_i(stack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public static boolean isSlimeChunk(World world, int x, int z) {
        Chunk chunk = world.func_175726_f(new BlockPos(x, 0, z));
        return chunk.func_76617_a(987234911L).nextInt(10) == 0;
    }
}

