/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.client.core.handler;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.function.Consumer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.logging.log4j.Level;
import org.lwjgl.opengl.ARBShaderObjects;
import vazkii.psi.client.core.handler.ClientTickHandler;
import vazkii.psi.common.core.handler.ConfigHandler;

public final class ShaderHandler {
    private static final int VERT_ST = 35633;
    private static final int FRAG_ST = 35632;
    private static final int VERT = 1;
    private static final int FRAG = 2;
    private static final String VERT_EXTENSION = ".vsh";
    private static final String FRAG_EXTENSION = ".fsh";
    public static int rawColor;
    public static int psiBar;
    public static int simpleBloom;

    public static void init() {
        if (!ShaderHandler.useShaders()) {
            return;
        }
        rawColor = ShaderHandler.createProgram("/assets/psi/shaders/raw_color", 2);
        psiBar = ShaderHandler.createProgram("/assets/psi/shaders/psi_bar", 2);
        simpleBloom = ShaderHandler.createProgram("/assets/psi/shaders/simple_bloom", 2);
    }

    public static void useShader(int shader, Consumer<Integer> callback) {
        if (!ShaderHandler.useShaders()) {
            return;
        }
        ARBShaderObjects.glUseProgramObjectARB((int)shader);
        if (shader != 0) {
            int time = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"time");
            ARBShaderObjects.glUniform1iARB((int)time, (int)ClientTickHandler.ticksInGame);
            if (callback != null) {
                callback.accept(shader);
            }
        }
    }

    public static void useShader(int shader) {
        ShaderHandler.useShader(shader, null);
    }

    public static void releaseShader() {
        ShaderHandler.useShader(0);
    }

    public static boolean useShaders() {
        return ConfigHandler.useShaders && OpenGlHelper.field_148824_g;
    }

    private static int createProgram(String s, int sides) {
        boolean vert = (sides & 1) != 0;
        boolean frag = (sides & 2) != 0;
        return ShaderHandler.createProgram(vert ? s + VERT_EXTENSION : null, frag ? s + FRAG_EXTENSION : null);
    }

    private static int createProgram(String vert, String frag) {
        int vertId = 0;
        int fragId = 0;
        int program = 0;
        if (vert != null) {
            vertId = ShaderHandler.createShader(vert, 35633);
        }
        if (frag != null) {
            fragId = ShaderHandler.createShader(frag, 35632);
        }
        if ((program = ARBShaderObjects.glCreateProgramObjectARB()) == 0) {
            return 0;
        }
        if (vert != null) {
            ARBShaderObjects.glAttachObjectARB((int)program, (int)vertId);
        }
        if (frag != null) {
            ARBShaderObjects.glAttachObjectARB((int)program, (int)fragId);
        }
        ARBShaderObjects.glLinkProgramARB((int)program);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)program, (int)35714) == 0) {
            FMLLog.log((Level)Level.ERROR, (String)ShaderHandler.getLogInfo(program), (Object[])new Object[0]);
            return 0;
        }
        ARBShaderObjects.glValidateProgramARB((int)program);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)program, (int)35715) == 0) {
            FMLLog.log((Level)Level.ERROR, (String)ShaderHandler.getLogInfo(program), (Object[])new Object[0]);
            return 0;
        }
        return program;
    }

    private static int createShader(String filename, int shaderType) {
        int shader = 0;
        try {
            shader = ARBShaderObjects.glCreateShaderObjectARB((int)shaderType);
            if (shader == 0) {
                return 0;
            }
            ARBShaderObjects.glShaderSourceARB((int)shader, (CharSequence)ShaderHandler.readFileAsString(filename));
            ARBShaderObjects.glCompileShaderARB((int)shader);
            if (ARBShaderObjects.glGetObjectParameteriARB((int)shader, (int)35713) == 0) {
                throw new RuntimeException("Error creating shader: " + ShaderHandler.getLogInfo(shader));
            }
            return shader;
        }
        catch (Exception e) {
            ARBShaderObjects.glDeleteObjectARB((int)shader);
            e.printStackTrace();
            return -1;
        }
    }

    private static String getLogInfo(int obj) {
        return ARBShaderObjects.glGetInfoLogARB((int)obj, (int)ARBShaderObjects.glGetObjectParameteriARB((int)obj, (int)35716));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFileAsString(String filename) throws Exception {
        StringBuilder source;
        block28: {
            source = new StringBuilder();
            InputStream in = ShaderHandler.class.getResourceAsStream(filename);
            Exception exception = null;
            if (in == null) {
                return "";
            }
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
                Exception innerExc = null;
                try {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        source.append(line).append('\n');
                    }
                }
                catch (Exception exc) {
                    exception = exc;
                }
                finally {
                    try {
                        reader.close();
                    }
                    catch (Exception exc) {
                        if (innerExc == null) {
                            innerExc = exc;
                        }
                        exc.printStackTrace();
                    }
                }
                if (innerExc != null) {
                    throw innerExc;
                }
            }
            catch (Exception exc) {
                exception = exc;
                return exception;
            }
            finally {
                try {
                    in.close();
                }
                catch (Exception exc) {
                    if (exception == null) {
                        exception = exc;
                    }
                    exc.printStackTrace();
                }
                if (exception == null) break block28;
                throw exception;
            }
        }
        return source.toString();
    }
}

