/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.trick.block;

import net.minecraft.block.Block;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceTrick;

public class PieceTrickMoveBlock
extends PieceTrick {
    SpellParam position;
    SpellParam target;

    public PieceTrickMoveBlock(Spell spell) {
        super(spell);
    }

    @Override
    public void initParams() {
        this.position = new ParamVector("psi.spellparam.position", SpellParam.BLUE, false, false);
        this.addParam(this.position);
        this.target = new ParamVector("psi.spellparam.target", SpellParam.GREEN, false, false);
        this.addParam(this.target);
    }

    @Override
    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
        meta.addStat(EnumSpellStat.POTENCY, 10);
        meta.addStat(EnumSpellStat.COST, 15);
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        if (context.caster.func_130014_f_().field_72995_K) {
            return null;
        }
        Vector3 positionVal = (Vector3)this.getParamValue(context, this.position);
        Vector3 targetVal = (Vector3)this.getParamValue(context, this.target);
        if (positionVal == null) {
            throw new SpellRuntimeException("psi.spellerror.nullvector");
        }
        if (!context.isInRadius(positionVal)) {
            throw new SpellRuntimeException("psi.spellerror.outsideradius");
        }
        World world = context.caster.func_130014_f_();
        BlockPos pos = new BlockPos(positionVal.x, positionVal.y, positionVal.z);
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (world.func_175625_s(pos) != null || block.func_149656_h(state) != EnumPushReaction.NORMAL || !block.canSilkHarvest(world, pos, state, context.caster) || block.func_180647_a(state, context.caster, world, pos) <= 0.0f || !ForgeHooks.canHarvestBlock((Block)block, (EntityPlayer)context.caster, (IBlockAccess)world, (BlockPos)pos)) {
            return null;
        }
        if (!targetVal.isAxial() || targetVal.isZero()) {
            return null;
        }
        Vector3 axis = targetVal.normalize();
        int x = pos.func_177958_n() + (int)axis.x;
        int y = pos.func_177956_o() + (int)axis.y;
        int z = pos.func_177952_p() + (int)axis.z;
        BlockPos pos1 = new BlockPos(x, y, z);
        IBlockState state1 = world.func_180495_p(pos1);
        if (!world.func_175660_a(context.caster, pos) || !world.func_175660_a(context.caster, pos1)) {
            return null;
        }
        if (world.func_175623_d(pos1) || state1.func_177230_c().func_176200_f((IBlockAccess)world, pos1)) {
            world.func_180501_a(pos1, state, 3);
            world.func_175698_g(pos);
            world.func_175718_b(2001, pos, Block.func_149682_b((Block)block) + (block.func_176201_c(state) << 12));
        }
        return null;
    }
}

