/*
 * Decompiled with CFR 0.152.
 */
package com.Apothic0n.MoltenVents.api.biome.features.types;

import com.Apothic0n.MoltenVents.api.biome.features.configurations.MoltenVentConfiguration;
import com.mojang.serialization.Codec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;

public class MoltenVentFeature
extends Feature<MoltenVentConfiguration> {
    public MoltenVentFeature(Codec<MoltenVentConfiguration> pContext) {
        super(pContext);
    }

    public boolean m_142674_(FeaturePlaceContext<MoltenVentConfiguration> pContext) {
        MoltenVentConfiguration ventConfiguration = (MoltenVentConfiguration)pContext.m_159778_();
        RandomSource random = pContext.m_225041_();
        BlockPos origin = pContext.m_159777_();
        WorldGenLevel worldGenLevel = pContext.m_159774_();
        BlockStateProvider decorativeBlock = ventConfiguration.getDecorativeBlock();
        BlockStateProvider outerBlock = ventConfiguration.getOuterBlock();
        BlockStateProvider innerBlock = ventConfiguration.getInnerBlock();
        BlockStateProvider liquidBlock = ventConfiguration.getLiquidBlock();
        Boolean underwater = ventConfiguration.underwater;
        int depth = ventConfiguration.getDepth().m_214085_(random);
        boolean suitableEnvironment = false;
        if (depth > 80 && underwater.booleanValue()) {
            depth = 80;
        }
        if (underwater.booleanValue() && worldGenLevel.m_8055_(origin.m_6630_(2)).m_60713_(Blocks.f_49990_)) {
            suitableEnvironment = true;
        } else if (!underwater.booleanValue() && !worldGenLevel.m_8055_(origin.m_7495_()).m_60713_(Blocks.f_49990_)) {
            suitableEnvironment = true;
        }
        if (suitableEnvironment && worldGenLevel.m_8055_(origin.m_7495_()).m_280296_()) {
            this.placePartialDiagonal(worldGenLevel, random, origin.m_7494_(), outerBlock, 3, 0.8, decorativeBlock);
            this.placeDiagonal(worldGenLevel, random, origin.m_7494_(), outerBlock, 3, 3, 0.66, decorativeBlock);
            this.placePartialDiagonal(worldGenLevel, random, origin, outerBlock, 3, 0.7, decorativeBlock);
            this.placeStraight(worldGenLevel, random, origin, outerBlock, 3, 3, 1.0, decorativeBlock);
            this.placeDiagonal(worldGenLevel, random, origin, outerBlock, 0, 3, 1.6, null);
            this.placeStraight(worldGenLevel, random, origin.m_7495_(), outerBlock, 3, 3, 1.0, null);
            this.placeDiagonal(worldGenLevel, random, origin.m_7495_(), outerBlock, 0, 3, 1.6, null);
            if (depth > 10) {
                int y;
                for (y = 1; y <= depth / 2 + 1; ++y) {
                    this.placeStraight(worldGenLevel, random, origin.m_6625_(y), outerBlock, 0, 2, 0.8, null);
                    this.placeDiagonal(worldGenLevel, random, origin.m_6625_(y), outerBlock, 0, 2, 0.75, null);
                    this.placeBlock(worldGenLevel, random, origin.m_6625_(y), liquidBlock, 1.0, null);
                }
                for (y = depth / 2 + 2; y <= depth + 1; ++y) {
                    this.placeStraight(worldGenLevel, random, origin.m_6625_(y), outerBlock, 0, 1, 0.33, null);
                    this.placeDiagonal(worldGenLevel, random, origin.m_6625_(y), outerBlock, 0, 1, 0.275, null);
                    this.placeBlock(worldGenLevel, random, origin.m_6625_(y), liquidBlock, 1.0, null);
                }
            }
            if (underwater.booleanValue()) {
                worldGenLevel.m_7731_(origin, Blocks.f_49990_.m_49966_(), 3);
            } else {
                worldGenLevel.m_7731_(origin, Blocks.f_50016_.m_49966_(), 3);
            }
            worldGenLevel.m_7731_(origin.m_7495_(), innerBlock.m_213972_(random, origin.m_7495_()), 3);
            return true;
        }
        return false;
    }

    private void placeStraight(WorldGenLevel worldGenLevel, RandomSource random, BlockPos blockPos, BlockStateProvider blockStateProvider, int minRadius, int maxRadius, double probability, @Nullable BlockStateProvider decorate) {
        for (int radius = --minRadius; radius < maxRadius; ++radius) {
            this.placeBlock(worldGenLevel, random, blockPos.m_122013_(radius), blockStateProvider, probability, decorate);
            this.placeBlock(worldGenLevel, random, blockPos.m_122030_(radius), blockStateProvider, probability, decorate);
            this.placeBlock(worldGenLevel, random, blockPos.m_122020_(radius), blockStateProvider, probability, decorate);
            this.placeBlock(worldGenLevel, random, blockPos.m_122025_(radius), blockStateProvider, probability, decorate);
        }
    }

    private void placeDiagonal(WorldGenLevel worldGenLevel, RandomSource random, BlockPos blockPos, BlockStateProvider blockStateProvider, int minRadius, int maxRadius, double probability, @Nullable BlockStateProvider decorate) {
        for (int radius = --minRadius; radius < maxRadius; ++radius) {
            this.placeBlock(worldGenLevel, random, blockPos.m_122013_(radius).m_122029_(), blockStateProvider, probability, decorate);
            this.placeBlock(worldGenLevel, random, blockPos.m_122013_(radius).m_122024_(), blockStateProvider, probability, decorate);
            this.placeBlock(worldGenLevel, random, blockPos.m_122020_(radius).m_122024_(), blockStateProvider, probability, decorate);
            this.placeBlock(worldGenLevel, random, blockPos.m_122020_(radius).m_122029_(), blockStateProvider, probability, decorate);
            this.placeBlock(worldGenLevel, random, blockPos.m_122012_().m_122030_(radius), blockStateProvider, probability, decorate);
            this.placeBlock(worldGenLevel, random, blockPos.m_122012_().m_122025_(radius), blockStateProvider, probability, decorate);
            this.placeBlock(worldGenLevel, random, blockPos.m_122019_().m_122025_(radius), blockStateProvider, probability, decorate);
            this.placeBlock(worldGenLevel, random, blockPos.m_122019_().m_122030_(radius), blockStateProvider, probability, decorate);
            this.placeBlock(worldGenLevel, random, blockPos.m_122013_(radius).m_122030_(radius), blockStateProvider, probability, decorate);
            this.placeBlock(worldGenLevel, random, blockPos.m_122013_(radius).m_122025_(radius), blockStateProvider, probability, decorate);
            this.placeBlock(worldGenLevel, random, blockPos.m_122020_(radius).m_122025_(radius), blockStateProvider, probability, decorate);
            this.placeBlock(worldGenLevel, random, blockPos.m_122020_(radius).m_122030_(radius), blockStateProvider, probability, decorate);
            this.placeBlock(worldGenLevel, random, blockPos.m_122013_(radius).m_122030_(radius), blockStateProvider, probability, decorate);
            this.placeBlock(worldGenLevel, random, blockPos.m_122013_(radius).m_122025_(radius), blockStateProvider, probability, decorate);
            this.placeBlock(worldGenLevel, random, blockPos.m_122020_(radius).m_122025_(radius), blockStateProvider, probability, decorate);
            this.placeBlock(worldGenLevel, random, blockPos.m_122020_(radius).m_122030_(radius), blockStateProvider, probability, decorate);
        }
    }

    private void placePartialDiagonal(WorldGenLevel worldGenLevel, RandomSource random, BlockPos blockPos, BlockStateProvider blockStateProvider, int radius, double probability, @Nullable BlockStateProvider decorate) {
        this.placeBlock(worldGenLevel, random, blockPos.m_122013_(radius).m_122029_(), blockStateProvider, probability, decorate);
        this.placeBlock(worldGenLevel, random, blockPos.m_122013_(radius).m_122024_(), blockStateProvider, probability, decorate);
        this.placeBlock(worldGenLevel, random, blockPos.m_122020_(radius).m_122024_(), blockStateProvider, probability, decorate);
        this.placeBlock(worldGenLevel, random, blockPos.m_122020_(radius).m_122029_(), blockStateProvider, probability, decorate);
        this.placeBlock(worldGenLevel, random, blockPos.m_122012_().m_122030_(radius), blockStateProvider, probability, decorate);
        this.placeBlock(worldGenLevel, random, blockPos.m_122012_().m_122025_(radius), blockStateProvider, probability, decorate);
        this.placeBlock(worldGenLevel, random, blockPos.m_122019_().m_122025_(radius), blockStateProvider, probability, decorate);
        this.placeBlock(worldGenLevel, random, blockPos.m_122019_().m_122030_(radius), blockStateProvider, probability, decorate);
    }

    private void placeBlock(WorldGenLevel worldGenLevel, RandomSource random, BlockPos blockPos, BlockStateProvider blockStateProvider, double probability, @Nullable BlockStateProvider decorate) {
        boolean passedProbability = false;
        if (probability >= 1.0) {
            passedProbability = true;
        } else {
            int randomNumber = (int)(Math.random() * 100.0 + 1.0);
            if ((double)randomNumber < probability * 100.0) {
                passedProbability = true;
            }
        }
        if (passedProbability) {
            BlockState blockState = blockStateProvider.m_213972_(random, blockPos);
            worldGenLevel.m_7731_(blockPos, blockState, 3);
            if (decorate != null) {
                boolean passedDecorateProbability = false;
                double decorateProbability = probability / 3.0;
                if (decorateProbability >= 1.0) {
                    passedDecorateProbability = true;
                } else {
                    int randomNumber2 = (int)(Math.random() * 100.0 + 1.0);
                    if ((double)randomNumber2 < decorateProbability * 100.0) {
                        passedDecorateProbability = true;
                    }
                }
                if (passedDecorateProbability) {
                    BlockPos offsetPos = this.randomOffset(blockPos);
                    BlockState decorateBlockState = decorate.m_213972_(random, offsetPos);
                    worldGenLevel.m_7731_(offsetPos, decorateBlockState, 3);
                    if (worldGenLevel.m_8055_(offsetPos.m_7495_()).m_60795_()) {
                        worldGenLevel.m_7731_(offsetPos.m_7495_(), blockState, 3);
                    }
                }
            }
        }
    }

    private BlockPos randomOffset(BlockPos blockPos) {
        int randomNumber = (int)(Math.random() * 15.0 + 1.0);
        if (randomNumber <= 7) {
            return blockPos.m_7494_();
        }
        if (randomNumber == 8) {
            return blockPos.m_122012_();
        }
        if (randomNumber == 9) {
            return blockPos.m_122029_();
        }
        if (randomNumber == 10) {
            return blockPos.m_122019_();
        }
        if (randomNumber == 11) {
            return blockPos.m_122024_();
        }
        if (randomNumber == 12) {
            return blockPos.m_122012_().m_122029_();
        }
        if (randomNumber == 13) {
            return blockPos.m_122012_().m_122024_();
        }
        if (randomNumber == 14) {
            return blockPos.m_122019_().m_122029_();
        }
        return blockPos.m_122019_().m_122024_();
    }
}

