/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.ice_and_fire_spellbooks.items.armor;

import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import java.util.EnumMap;
import java.util.UUID;
import java.util.function.Supplier;
import net.acetheeldritchking.ice_and_fire_spellbooks.config.ArmorValueConfig;
import net.minecraft.Util;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.LazyLoadedValue;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public enum DragonArmorMaterials implements ArmorMaterial
{
    FIRE_DRAGON_PRIEST("fire_dragon_priest", 39, ArmorValueConfig.dragonsteelArmorValue, 15, SoundEvents.f_11679_, 6.0f, 0.1f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)IafItemRegistry.DRAGONSTEEL_FIRE_INGOT.get()})),
    ICE_DRAGON_PRIEST("ice_dragon_priest", 39, ArmorValueConfig.dragonsteelArmorValue, 15, SoundEvents.f_11679_, 6.0f, 0.1f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)IafItemRegistry.DRAGONSTEEL_ICE_INGOT.get()})),
    LIGHTNING_DRAGON_PRIEST("lightning_dragon_priest", 39, ArmorValueConfig.dragonsteelArmorValue, 15, SoundEvents.f_11679_, 6.0f, 0.1f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)IafItemRegistry.DRAGONSTEEL_LIGHTNING_INGOT.get()}));

    private static final int[] HEALTH_PER_SLOT;
    private final String name;
    private final int durabilityMultiplier;
    private final ArmorValueConfig.ArmorValues protectionFunctionForType;
    private final int enchantmentValue;
    private final SoundEvent sound;
    private final float toughness;
    private final float knockbackResistance;
    private final LazyLoadedValue<Ingredient> repairIngredient;
    private EnumMap<EquipmentSlot, Multimap<Attribute, AttributeModifier>> slotToAttributeMap;
    private static final UUID[] ARMOR_ATTRIBUTE_UUID_PER_SLOT;
    private static EnumMap<ArmorItem.Type, Integer> HEALTH_FUNCTION_FOR_TYPE;

    private DragonArmorMaterials(String pName, int pDurabilityMultiplier, ArmorValueConfig.ArmorValues protectionMap, int pEnchantmentValue, SoundEvent pSound, float pToughness, float pKnockbackResistance, Supplier<Ingredient> pRepairIngredient) {
        this.name = pName;
        this.durabilityMultiplier = pDurabilityMultiplier;
        this.protectionFunctionForType = protectionMap;
        this.enchantmentValue = pEnchantmentValue;
        this.sound = pSound;
        this.toughness = pToughness;
        this.knockbackResistance = pKnockbackResistance;
        this.repairIngredient = new LazyLoadedValue(pRepairIngredient);
        this.slotToAttributeMap = null;
    }

    public EnumMap<EquipmentSlot, Multimap<Attribute, AttributeModifier>> getSlotToAttributeMap() {
        if (this.slotToAttributeMap == null) {
            this.slotToAttributeMap = this.makeSlotToAttributeMap();
        }
        return this.slotToAttributeMap;
    }

    private EnumMap<EquipmentSlot, Multimap<Attribute, AttributeModifier>> makeSlotToAttributeMap() {
        return (EnumMap)Util.m_137469_(new EnumMap(EquipmentSlot.class), p_266655_ -> {
            p_266655_.put(EquipmentSlot.FEET, this.makeAttributeMap(EquipmentSlot.FEET));
            p_266655_.put(EquipmentSlot.LEGS, this.makeAttributeMap(EquipmentSlot.LEGS));
            p_266655_.put(EquipmentSlot.CHEST, this.makeAttributeMap(EquipmentSlot.CHEST));
            p_266655_.put(EquipmentSlot.HEAD, this.makeAttributeMap(EquipmentSlot.HEAD));
        });
    }

    private Multimap<Attribute, AttributeModifier> makeAttributeMap(EquipmentSlot slot) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        UUID uuid = ARMOR_ATTRIBUTE_UUID_PER_SLOT[slot.m_20749_()];
        int protection = this.protectionFunctionForType.getProtectionValues(slot);
        float toughness = this.toughness;
        float knockbackResistance = this.knockbackResistance;
        double maxMana = 150.0;
        double firePower = 0.1;
        double icePower = 0.1;
        double lightningPower = 0.1;
        if (protection != 0) {
            builder.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(uuid, "Armor modifier", (double)protection, AttributeModifier.Operation.ADDITION));
        }
        if (toughness != 0.0f) {
            builder.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(uuid, "Armor toughness", (double)toughness, AttributeModifier.Operation.ADDITION));
        }
        if (knockbackResistance > 0.0f) {
            builder.put((Object)Attributes.f_22278_, (Object)new AttributeModifier(uuid, "Armor knockback resistance", (double)knockbackResistance, AttributeModifier.Operation.ADDITION));
        }
        if (maxMana != 0.0) {
            builder.put((Object)((Attribute)AttributeRegistry.MAX_MANA.get()), (Object)new AttributeModifier(uuid, "Armor maxMana", maxMana, AttributeModifier.Operation.ADDITION));
        }
        if (firePower != 0.0 && this == FIRE_DRAGON_PRIEST) {
            builder.put((Object)((Attribute)AttributeRegistry.FIRE_SPELL_POWER.get()), (Object)new AttributeModifier(uuid, "Fire power", firePower, AttributeModifier.Operation.MULTIPLY_BASE));
        }
        if (icePower != 0.0 && this == ICE_DRAGON_PRIEST) {
            builder.put((Object)((Attribute)AttributeRegistry.ICE_SPELL_POWER.get()), (Object)new AttributeModifier(uuid, "Ice power", icePower, AttributeModifier.Operation.MULTIPLY_BASE));
        }
        if (lightningPower != 0.0 && this == LIGHTNING_DRAGON_PRIEST) {
            builder.put((Object)((Attribute)AttributeRegistry.LIGHTNING_SPELL_POWER.get()), (Object)new AttributeModifier(uuid, "Lightning power", lightningPower, AttributeModifier.Operation.MULTIPLY_BASE));
        }
        return builder.build();
    }

    public static EnumMap<ArmorItem.Type, Integer> makeArmorMap(int helmet, int chestplate, int leggings, int boots) {
        return (EnumMap)Util.m_137469_(new EnumMap(ArmorItem.Type.class), p_266655_ -> {
            p_266655_.put(ArmorItem.Type.BOOTS, boots);
            p_266655_.put(ArmorItem.Type.LEGGINGS, leggings);
            p_266655_.put(ArmorItem.Type.CHESTPLATE, chestplate);
            p_266655_.put(ArmorItem.Type.HELMET, helmet);
        });
    }

    public int getDurabilityForSlot(EquipmentSlot pSlot) {
        return HEALTH_PER_SLOT[pSlot.m_20749_()] * this.durabilityMultiplier;
    }

    public int m_266425_(ArmorItem.Type pType) {
        return HEALTH_FUNCTION_FOR_TYPE.get(pType) * this.durabilityMultiplier;
    }

    public int m_7366_(ArmorItem.Type type) {
        return -1;
    }

    public int m_6646_() {
        return this.enchantmentValue;
    }

    public SoundEvent m_7344_() {
        return this.sound;
    }

    public Ingredient m_6230_() {
        return (Ingredient)this.repairIngredient.m_13971_();
    }

    public String m_6082_() {
        return this.name;
    }

    public float m_6651_() {
        return this.toughness;
    }

    public float m_6649_() {
        return this.knockbackResistance;
    }

    static {
        HEALTH_PER_SLOT = new int[]{13, 15, 16, 11};
        ARMOR_ATTRIBUTE_UUID_PER_SLOT = new UUID[]{UUID.fromString("F7BFFA65-547A-49D2-8804-3D533070E432"), UUID.fromString("B05AF2C0-5862-4CE6-860A-522C11E1571A"), UUID.fromString("15C1FE6B-3596-412A-B6CF-4077CB37140F"), UUID.fromString("82A575D1-366A-4BBD-91F8-25DB6B804F06")};
        HEALTH_FUNCTION_FOR_TYPE = (EnumMap)Util.m_137469_(new EnumMap(ArmorItem.Type.class), p_266653_ -> {
            p_266653_.put(ArmorItem.Type.BOOTS, 13);
            p_266653_.put(ArmorItem.Type.LEGGINGS, 15);
            p_266653_.put(ArmorItem.Type.CHESTPLATE, 16);
            p_266653_.put(ArmorItem.Type.HELMET, 11);
        });
    }
}

