/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.network;

import com.teamresourceful.resourcefullib.common.network.Packet;
import com.teamresourceful.resourcefullib.common.network.base.ClientboundPacketType;
import com.teamresourceful.resourcefullib.common.network.base.Networking;
import com.teamresourceful.resourcefullib.common.network.base.ServerboundPacketType;
import com.teamresourceful.resourcefullib.common.network.forge.NetworkChannelImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Collection;
import java.util.function.BooleanSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class NetworkChannel
implements Networking {
    private final Networking networking;

    public NetworkChannel(String modid, int protocolVersion, String channel) {
        this(modid, protocolVersion, channel, false);
    }

    public NetworkChannel(String modid, int protocolVersion, String channel, boolean optional) {
        this(modid, protocolVersion, channel, () -> optional);
    }

    public NetworkChannel(String modid, int protocolVersion, String channel, BooleanSupplier optional) {
        this.networking = NetworkChannel.getNetwork(new ResourceLocation(modid, channel), protocolVersion, optional);
    }

    @Override
    public final <T extends Packet<T>> void register(ClientboundPacketType<T> type) {
        this.networking.register(type);
    }

    @Override
    public final <T extends Packet<T>> void register(ServerboundPacketType<T> type) {
        this.networking.register(type);
    }

    @Override
    public final <T extends Packet<T>> void sendToServer(T message) {
        this.networking.sendToServer(message);
    }

    @Override
    public final <T extends Packet<T>> void sendToPlayer(T message, ServerPlayer player) {
        this.networking.sendToPlayer(message, player);
    }

    public final <T extends Packet<T>> void sendToPlayer(T message, Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.sendToPlayer(message, serverPlayer);
        }
    }

    public final <T extends Packet<T>> void sendToPlayers(T message, Collection<? extends Player> players) {
        players.forEach(player -> this.sendToPlayer(message, (Player)player));
    }

    public final <T extends Packet<T>> void sendToAllPlayers(T message, MinecraftServer server) {
        this.sendToPlayers(message, server.m_6846_().m_11314_());
    }

    public final <T extends Packet<T>> void sendToPlayersInLevel(T message, Level level) {
        this.sendToPlayers(message, level.m_6907_());
    }

    public final <T extends Packet<T>> void sendToAllLoaded(T message, Level level, BlockPos pos) {
        ChunkSource chunkSource;
        LevelChunk chunk = level.m_46745_(pos);
        if (chunk != null && (chunkSource = level.m_7726_()) instanceof ServerChunkCache) {
            ServerChunkCache serverCache = (ServerChunkCache)chunkSource;
            serverCache.f_8325_.m_183262_(chunk.m_7697_(), false).forEach(player -> this.sendToPlayer(message, (ServerPlayer)player));
        }
    }

    public final <T extends Packet<T>> void sendToPlayersInRange(T message, Level level, BlockPos pos, double range) {
        for (Player player : level.m_6907_()) {
            if (!(player.m_20183_().m_123331_((Vec3i)pos) <= range)) continue;
            this.sendToPlayer(message, player);
        }
    }

    @Override
    public final boolean canSendToPlayer(ServerPlayer player) {
        return this.networking.canSendToPlayer(player);
    }

    public final boolean canSendToPlayer(Player player) {
        ServerPlayer serverPlayer;
        return player instanceof ServerPlayer && this.canSendToPlayer(serverPlayer = (ServerPlayer)player);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ApiStatus.Internal
    @ExpectPlatform.Transformed
    public static Networking getNetwork(ResourceLocation channel, int protocolVersion, BooleanSupplier optional) {
        void var2_2;
        void var1_1;
        return NetworkChannelImpl.getNetwork(channel, (int)var1_1, (BooleanSupplier)var2_2);
    }
}

