/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.client;

import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.client.ClientBuiltPool;
import fzzyhmstrs.emi_loot.client.ClientRawPool;
import fzzyhmstrs.emi_loot.client.LootReceiver;
import fzzyhmstrs.emi_loot.util.LText;
import fzzyhmstrs.emi_loot.util.TextKey;
import io.netty.handler.codec.DecoderException;
import it.unimi.dsi.fastutil.floats.Float2ObjectArrayMap;
import it.unimi.dsi.fastutil.floats.Float2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public abstract class AbstractTextKeyParsingClientLootTable<T extends LootReceiver>
implements LootReceiver {
    private final Map<List<TextKey>, ClientRawPool> rawItems;
    public List<ClientBuiltPool> builtItems;

    public AbstractTextKeyParsingClientLootTable() {
        this.rawItems = new HashMap<List<TextKey>, ClientRawPool>();
    }

    public AbstractTextKeyParsingClientLootTable(Map<List<TextKey>, ClientRawPool> map) {
        this.rawItems = map;
    }

    static ResourceLocation getIdFromBuf(FriendlyByteBuf buf) {
        String idToParse = buf.m_130277_();
        if (idToParse.contains(":")) {
            return new ResourceLocation(idToParse);
        }
        if (idToParse.startsWith("b/")) {
            return new ResourceLocation("blocks/" + idToParse.substring(2));
        }
        if (idToParse.startsWith("e/")) {
            return new ResourceLocation("entities/" + idToParse.substring(2));
        }
        if (idToParse.startsWith("c/")) {
            return new ResourceLocation("chests/" + idToParse.substring(2));
        }
        if (idToParse.startsWith("g/")) {
            return new ResourceLocation("gameplay/" + idToParse.substring(2));
        }
        if (idToParse.startsWith("a/")) {
            return new ResourceLocation("archaeology/" + idToParse.substring(2));
        }
        return new ResourceLocation(idToParse);
    }

    abstract List<Tuple<Integer, Component>> getSpecialTextKeyList(Level var1, Block var2);

    public void build(Level world, Block block) {
        HashMap<List, Object2FloatMap> builderItems = new HashMap<List, Object2FloatMap>();
        this.rawItems.forEach((list, pool) -> {
            LinkedList<Tuple<Integer, Component>> applyToAllList = new LinkedList<Tuple<Integer, Component>>(this.getSpecialTextKeyList(world, block));
            list.forEach(textKey -> {
                Component text = textKey.process(ItemStack.f_41583_, world).text();
                applyToAllList.add(new Tuple((Object)textKey.index(), (Object)text));
            });
            pool.map().forEach((poolList, poolItemMap) -> {
                LinkedList newPoolList = new LinkedList();
                Object2FloatOpenHashMap itemsToAdd = new Object2FloatOpenHashMap();
                LinkedList itemsToRemove = new LinkedList();
                poolList.forEach(arg_0 -> AbstractTextKeyParsingClientLootTable.lambda$build$4(poolItemMap, world, itemsToRemove, (Object2FloatMap)itemsToAdd, newPoolList, arg_0));
                LinkedList summedList = new LinkedList(applyToAllList);
                summedList.addAll(newPoolList);
                if (summedList.isEmpty()) {
                    summedList.add(new Tuple((Object)TextKey.getIndex("emi_loot.no_conditions"), (Object)LText.translatable("emi_loot.no_conditions")));
                }
                Object2FloatMap builderPoolMap = builderItems.getOrDefault(summedList, (Object2FloatMap)poolItemMap);
                builderPoolMap.putAll((Map)itemsToAdd);
                itemsToRemove.forEach(arg_0 -> ((Object2FloatMap)builderPoolMap).removeFloat(arg_0));
                builderItems.put(summedList, builderPoolMap);
            });
        });
        LinkedList<ClientBuiltPool> finalList = new LinkedList<ClientBuiltPool>();
        builderItems.forEach((builtList, builtMap) -> {
            Float2ObjectArrayMap consolidatedMap = new Float2ObjectArrayMap();
            builtMap.forEach((arg_0, arg_1) -> AbstractTextKeyParsingClientLootTable.lambda$build$7((Float2ObjectMap)consolidatedMap, arg_0, arg_1));
            Float2ObjectArrayMap emiConsolidatedMap = new Float2ObjectArrayMap();
            consolidatedMap.forEach((arg_0, arg_1) -> AbstractTextKeyParsingClientLootTable.lambda$build$8((Float2ObjectMap)emiConsolidatedMap, arg_0, arg_1));
            finalList.add(new ClientBuiltPool((List<Tuple<Integer, Component>>)builtList, (Float2ObjectMap<EmiIngredient>)emiConsolidatedMap));
        });
        this.builtItems = finalList;
    }

    abstract Tuple<ResourceLocation, ResourceLocation> getBufId(FriendlyByteBuf var1);

    abstract T simpleTableToReturn(Tuple<ResourceLocation, ResourceLocation> var1, FriendlyByteBuf var2);

    abstract T emptyTableToReturn();

    abstract T filledTableToReturn(Tuple<ResourceLocation, ResourceLocation> var1, Map<List<TextKey>, ClientRawPool> var2);

    @Override
    public LootReceiver fromBuf(FriendlyByteBuf buf) {
        int builderCount;
        boolean isEmpty = true;
        Tuple<ResourceLocation, ResourceLocation> ids = this.getBufId(buf);
        ResourceLocation id = (ResourceLocation)ids.m_14418_();
        if (EMILoot.DEBUG) {
            EMILoot.LOGGER.info("parsing table " + id);
        }
        if ((builderCount = buf.readShort()) == -1) {
            return this.simpleTableToReturn(ids, buf);
        }
        HashMap<List<TextKey>, ClientRawPool> itemMap = new HashMap<List<TextKey>, ClientRawPool>();
        for (int b = 0; b < builderCount; ++b) {
            LinkedList<TextKey> qualifierList = new LinkedList<TextKey>();
            int conditionSize = buf.readShort();
            for (int i = 0; i < conditionSize; ++i) {
                try {
                    TextKey key = TextKey.fromBuf(buf);
                    qualifierList.add(key);
                    continue;
                }
                catch (DecoderException e) {
                    EMILoot.LOGGER.error("Client table " + id + " had a TextKey decoding error while reading a loot condition!");
                }
            }
            int functionSize = buf.readShort();
            for (int i = 0; i < functionSize; ++i) {
                try {
                    TextKey key = TextKey.fromBuf(buf);
                    qualifierList.add(key);
                    continue;
                }
                catch (DecoderException e) {
                    EMILoot.LOGGER.error("Client table " + id + " had a TextKey decoding error while reading a loot function!");
                }
            }
            ClientRawPool pool = itemMap.getOrDefault(qualifierList, new ClientRawPool(new HashMap<List<TextKey>, Object2FloatMap<ItemStack>>()));
            int pileSize = buf.readShort();
            for (int i = 0; i < pileSize; ++i) {
                LinkedList<TextKey> pileQualifierList = new LinkedList<TextKey>();
                int pileQualifierSize = buf.readShort();
                for (int j = 0; j < pileQualifierSize; ++j) {
                    try {
                        TextKey key = TextKey.fromBuf(buf);
                        pileQualifierList.add(key);
                        continue;
                    }
                    catch (DecoderException e) {
                        EMILoot.LOGGER.error("Client table " + id + " had a TextKey decoding error while reading an item pile qualifier!");
                    }
                }
                Object2FloatMap<ItemStack> pileItemMap = pool.map().getOrDefault(pileQualifierList, (Object2FloatMap<ItemStack>)new Object2FloatOpenHashMap());
                int pileItemSize = buf.readShort();
                for (int j = 0; j < pileItemSize; ++j) {
                    ItemStack stack = buf.m_130267_();
                    float weight = buf.readFloat();
                    pileItemMap.put((Object)stack, weight);
                    isEmpty = false;
                }
                pool.map().put(pileQualifierList, pileItemMap);
            }
            itemMap.put(qualifierList, pool);
        }
        if (isEmpty) {
            return this.emptyTableToReturn();
        }
        return this.filledTableToReturn(ids, itemMap);
    }

    private static /* synthetic */ void lambda$build$8(Float2ObjectMap emiConsolidatedMap, Float consolidatedWeight, List consolidatedList) {
        LinkedList<EmiStack> emiStacks = new LinkedList<EmiStack>();
        for (ItemStack i : consolidatedList) {
            emiStacks.add(EmiStack.of((ItemStack)i));
        }
        emiConsolidatedMap.put(consolidatedWeight.floatValue(), (Object)EmiIngredient.of(emiStacks));
    }

    private static /* synthetic */ void lambda$build$7(Float2ObjectMap consolidatedMap, ItemStack stack, Float weight) {
        List consolidatedList = (List)consolidatedMap.getOrDefault(weight.floatValue(), new LinkedList());
        if (!consolidatedList.contains(stack)) {
            consolidatedList.add(stack);
        }
        consolidatedMap.put(weight.floatValue(), (Object)consolidatedList);
    }

    private static /* synthetic */ void lambda$build$4(Object2FloatMap poolItemMap, Level world, List itemsToRemove, Object2FloatMap itemsToAdd, List newPoolList, TextKey textKey) {
        poolItemMap.forEach((poolStack, weight) -> {
            List<ItemStack> stacks = textKey.process((ItemStack)poolStack, world).stacks();
            AtomicReference<Float> toAddWeight = new AtomicReference<Float>(Float.valueOf(1.0f));
            if (!stacks.contains(poolStack)) {
                itemsToRemove.add(poolStack);
                toAddWeight.set(Float.valueOf(poolItemMap.getFloat(poolStack)));
            }
            stacks.forEach(stack -> {
                if (poolItemMap.containsKey(stack)) {
                    toAddWeight.set(Float.valueOf(poolItemMap.getFloat(stack)));
                }
            });
            stacks.forEach(stack -> {
                if (!poolItemMap.containsKey(stack)) {
                    itemsToAdd.put(stack, ((Float)toAddWeight.get()).floatValue());
                }
            });
        });
        Component text = textKey.process(ItemStack.f_41583_, world).text();
        newPoolList.add(new Tuple((Object)textKey.index(), (Object)text));
    }
}

