/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.emi;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import fzzyhmstrs.emi_loot.EMILootClient;
import fzzyhmstrs.emi_loot.client.ClientBuiltPool;
import fzzyhmstrs.emi_loot.client.ClientMobLootTable;
import fzzyhmstrs.emi_loot.client.ClientResourceData;
import fzzyhmstrs.emi_loot.emi.EmiClientPlugin;
import fzzyhmstrs.emi_loot.util.EntityEmiStack;
import fzzyhmstrs.emi_loot.util.IconGroupEmiWidget;
import fzzyhmstrs.emi_loot.util.LText;
import fzzyhmstrs.emi_loot.util.WidgetRowBuilder;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class MobLootRecipe
implements EmiRecipe {
    private static final ResourceLocation ARROW_ID = new ResourceLocation("emi_loot", "textures/gui/downturn_arrow.png");
    private final ClientMobLootTable loot;
    private final EmiStack inputStack;
    private final List<EmiStack> outputStacks;
    private final Component name;
    private final EntityType<?> type;
    private final List<WidgetRowBuilder> rowBuilderList = new LinkedList<WidgetRowBuilder>();

    public MobLootRecipe(ClientMobLootTable loot) {
        EntityType type;
        this.loot = loot;
        loot.build((Level)Minecraft.m_91087_().f_91073_, Blocks.f_50016_);
        ResourceLocation mobId = loot.mobId;
        this.type = type = (EntityType)BuiltInRegistries.f_256780_.m_7745_(mobId);
        Minecraft client = Minecraft.m_91087_();
        Entity entity = type.m_20615_((Level)client.f_91073_);
        if (entity != null) {
            AABB box = entity.m_20191_();
            double len = box.m_82309_();
            if (len > 1.05) {
                len = (len + Math.sqrt(len)) / 2.0;
            }
            if (entity instanceof Slime) {
                ((Slime)entity).m_7839_(5, false);
            }
            if (entity instanceof Sheep && !Objects.equals(loot.color, "")) {
                DyeColor color = DyeColor.m_41057_((String)loot.color, (DyeColor)DyeColor.WHITE);
                MutableComponent colorName = LText.translatable("color.minecraft." + color.m_41065_());
                this.name = LText.translatable("emi_loot.color_name", colorName.getString(), entity.m_7755_().getString());
                ((Sheep)entity).m_29855_(color);
            } else {
                this.name = entity.m_7755_();
            }
            double scale = 1.05 / len * 8.0;
            if (ClientResourceData.MOB_SCALES.containsKey((Object)type)) {
                scale *= (double)ClientResourceData.MOB_SCALES.getOrDefault((Object)type, 1.0f);
            }
            this.inputStack = EntityEmiStack.ofScaled(entity, scale);
        } else {
            this.inputStack = EmiStack.EMPTY;
            this.name = LText.translatable("emi_loot.missing_entity");
        }
        LinkedList<EmiStack> list = new LinkedList<EmiStack>();
        loot.builtItems.forEach(builtPool -> {
            builtPool.stackMap().forEach((weight, stacks) -> list.addAll(stacks.getEmiStacks()));
            this.addWidgetBuilders((ClientBuiltPool)builtPool, false);
        });
        this.outputStacks = list;
    }

    private void addWidgetBuilders(ClientBuiltPool newPool, boolean recursive) {
        if (recursive || this.rowBuilderList.isEmpty()) {
            this.rowBuilderList.add(new WidgetRowBuilder(154));
        }
        boolean added = false;
        for (WidgetRowBuilder builder : this.rowBuilderList) {
            if (!builder.canAddPool(newPool)) continue;
            builder.addAndTrim(newPool);
            added = true;
            break;
        }
        if (!added) {
            Optional<ClientBuiltPool> opt = this.rowBuilderList.get(this.rowBuilderList.size() - 1).addAndTrim(newPool);
            opt.ifPresent(clientMobBuiltPool -> this.addWidgetBuilders((ClientBuiltPool)clientMobBuiltPool, true));
        }
    }

    public EmiRecipeCategory getCategory() {
        return EmiClientPlugin.MOB_CATEGORY;
    }

    @Nullable
    public ResourceLocation getId() {
        return new ResourceLocation(EMILootClient.MOD_ID, "/" + this.getCategory().id.m_135815_() + "/" + this.loot.id.m_135827_() + "/" + this.loot.id.m_135815_());
    }

    public List<EmiIngredient> getInputs() {
        Entity entity;
        EntityEmiStack entityStack;
        Object object = this.inputStack;
        if (object instanceof EntityEmiStack && (object = (entityStack = (EntityEmiStack)((Object)object)).getKey()) instanceof Entity && (entity = (Entity)object).m_142340_() != null) {
            return List.of(EmiStack.of((ItemStack)entity.m_142340_()));
        }
        return new LinkedList<EmiIngredient>();
    }

    public List<EmiIngredient> getCatalysts() {
        return super.getCatalysts();
    }

    public List<EmiStack> getOutputs() {
        return this.outputStacks;
    }

    public int getDisplayWidth() {
        return 154;
    }

    public int getDisplayHeight() {
        if (this.rowBuilderList.size() > 1 || this.rowBuilderList.get(0).getWidth() > 94) {
            return 51 + 29 * (this.rowBuilderList.size() - 1);
        }
        return 34;
    }

    public void addWidgets(WidgetHolder widgets) {
        int rowOffset = 29;
        int x = 0;
        int y = 0;
        if (!ClientResourceData.MOB_OFFSETS.containsKey(this.type)) {
            widgets.addSlot((EmiIngredient)this.inputStack, x, y).large(true);
        } else {
            int offset = ClientResourceData.MOB_OFFSETS.getOrDefault(this.type, 0);
            widgets.addTexture(EmiTexture.LARGE_SLOT, x, y);
            widgets.addDrawable(x, y, 16, 16, (matrices, mx, my, delta) -> this.inputStack.render(matrices, 5, 6 + offset, delta));
        }
        widgets.addText(this.name.m_7532_(), 30, 0, 0x404040, false);
        if (this.rowBuilderList.size() == 1 && this.rowBuilderList.get(0).getWidth() <= 94) {
            widgets.addTexture(new EmiTexture(ARROW_ID, 0, 16, 39, 15, 39, 15, 64, 32), 30, 10);
            x = 60;
            y = 11;
            WidgetRowBuilder builder = this.rowBuilderList.get(0);
            for (ClientBuiltPool pool : builder.getPoolList()) {
                IconGroupEmiWidget widget = new IconGroupEmiWidget(x, y, pool);
                widgets.add((Widget)widget);
                x += widget.getWidth() + 6;
            }
        } else {
            widgets.addTexture(new EmiTexture(ARROW_ID, 0, 0, 39, 15, 39, 15, 64, 32), 30, 10);
            y += 28;
            for (WidgetRowBuilder builder : this.rowBuilderList) {
                for (ClientBuiltPool pool : builder.getPoolList()) {
                    IconGroupEmiWidget widget = new IconGroupEmiWidget(x, y, pool);
                    widgets.add((Widget)widget);
                    x += widget.getWidth() + 6;
                }
                y += 29;
                x = 0;
            }
        }
    }

    public boolean supportsRecipeTree() {
        return false;
    }

    public boolean hideCraftable() {
        return super.hideCraftable();
    }
}

