/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.blocks.deposits.surface_scanner;

import com.drmangotea.tfmg.registry.TFMGBlocks;
import com.simibubi.create.Create;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class SurfaceScannerBlockEntity
extends KineticBlockEntity
implements IHaveGoggleInformation,
IWrenchable {
    public BlockPos deposit;
    public BlockPos checkedPosition;
    public boolean foundDeposit = false;
    public BlockPos depositPos;
    public int locatingTimer = 0;
    public boolean noDepositFound = false;
    int dotTimer = 0;
    int dotCount = 1;
    public int distanceFromDeposit = 6969;
    public LerpedFloat visualAngle = LerpedFloat.angular();
    public float angle = 0.0f;
    public LerpedFloat visualFlagAngle = LerpedFloat.angular();
    public float flagAngle = 0.0f;

    public SurfaceScannerBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public void tick() {
        super.tick();
        this.angle %= 360.0f;
        if (this.getSpeed() == 0.0f) {
            this.foundDeposit = false;
            this.noDepositFound = false;
            this.locatingTimer = 0;
            return;
        }
        if (this.deposit == null) {
            this.foundDeposit = false;
            this.distanceFromDeposit = 6969;
        }
        this.visualAngle.chase((double)this.angle, (double)0.2f, LerpedFloat.Chaser.EXP);
        this.visualAngle.tickChaser();
        this.visualFlagAngle.chase((double)this.flagAngle, (double)0.8f, LerpedFloat.Chaser.EXP);
        this.visualFlagAngle.tickChaser();
        if (!this.foundDeposit) {
            ++this.dotTimer;
            ++this.locatingTimer;
            this.distanceFromDeposit = 6969;
            if (this.locatingTimer >= 2400) {
                this.locatingTimer = 2400;
                this.noDepositFound = true;
                return;
            }
            if (this.dotTimer >= 90) {
                this.dotCount = 3;
                this.dotTimer = 0;
            } else if (this.dotTimer >= 60) {
                this.dotCount = 2;
            } else if (this.dotTimer >= 30) {
                this.dotCount = 1;
            }
        }
        if (this.foundDeposit) {
            float zDistance = this.deposit.m_123343_() - this.m_58899_().m_123343_();
            float xDistance = this.deposit.m_123341_() - this.m_58899_().m_123341_();
            int positiveXsquared = Math.abs((int)xDistance) * Math.abs((int)xDistance);
            int positiveZsquared = Math.abs((int)zDistance) * Math.abs((int)xDistance);
            this.distanceFromDeposit = (int)Math.sqrt(positiveXsquared + positiveZsquared);
            if (zDistance < 10.0f && zDistance > -10.0f && xDistance < 10.0f && xDistance > -10.0f) {
                this.flagAngle = 90.0f;
                return;
            }
            this.angle = (float)Math.toDegrees(Math.atan(xDistance / zDistance));
            if (this.m_58899_().m_123343_() < this.deposit.m_123343_()) {
                this.angle += 180.0f;
            }
            if (this.angle == 90.0f) {
                this.angle = -90.0f;
                return;
            }
            if (this.angle == -90.0f) {
                this.angle = 90.0f;
            }
            return;
        }
        for (int i = 0; i < 100; ++i) {
            int random = Create.RANDOM.nextInt(200);
            random -= 100;
            int random1 = Create.RANDOM.nextInt(200);
            random1 -= 100;
            int random2 = Create.RANDOM.nextInt(2);
            for (int x = 0; x < 2; ++x) {
                this.checkedPosition = new BlockPos(this.m_58899_().m_123341_() + random, -63 - random2, this.m_58899_().m_123343_() + random1);
            }
            BlockState checkedState = this.f_58857_.m_8055_(this.checkedPosition);
            if (!checkedState.m_60713_((Block)TFMGBlocks.OIL_DEPOSIT.get())) continue;
            this.deposit = this.checkedPosition;
            if (this.f_58857_.m_8055_(this.checkedPosition.m_7494_()) != Blocks.f_50752_.m_49966_() && this.f_58857_.m_8055_(this.checkedPosition.m_6630_(2)) != Blocks.f_50752_.m_49966_() && this.f_58857_.m_8055_(this.checkedPosition.m_6630_(3)) != Blocks.f_50752_.m_49966_() && this.f_58857_.m_8055_(this.checkedPosition.m_6630_(4)) != Blocks.f_50752_.m_49966_()) {
                this.foundDeposit = true;
            }
            this.depositPos = this.deposit;
        }
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        this.flagAngle = 0.0f;
        this.angle = 0.0f;
        this.foundDeposit = false;
        this.deposit = null;
        return InteractionResult.SUCCESS;
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        if (this.foundDeposit && this.depositPos != null) {
            compound.m_128365_("DepositPos", (Tag)NbtUtils.m_129224_((BlockPos)this.depositPos));
        }
        compound.m_128379_("FoundDeposit", this.foundDeposit);
        super.write(compound, clientPacket);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        if (this.foundDeposit) {
            this.depositPos = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("DepositPos"));
        }
        this.foundDeposit = compound.m_128471_("FoundDeposit");
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (this.getSpeed() == 0.0f) {
            Lang.translate((String)"goggles.surface_scanner.no_rotation", (Object[])new Object[0]).style(ChatFormatting.DARK_RED).forGoggles(tooltip);
            return true;
        }
        if (this.noDepositFound) {
            Lang.translate((String)"goggles.surface_scanner.no_deposit", (Object[])new Object[0]).style(ChatFormatting.RED).space().forGoggles(tooltip);
            return true;
        }
        if (this.foundDeposit) {
            Lang.translate((String)"goggles.surface_scanner.deposit_found", (Object[])new Object[0]).style(ChatFormatting.DARK_GREEN).space().forGoggles(tooltip);
            Lang.translate((String)"goggles.surface_scanner.distance", (Object[])new Object[]{this.distanceFromDeposit}).style(ChatFormatting.GREEN).forGoggles(tooltip, 1);
        } else {
            if (this.dotCount == 1) {
                Lang.translate((String)"goggles.surface_scanner.scanning_surface", (Object[])new Object[0]).style(ChatFormatting.GOLD).add(Lang.translate((String)"goggles.misc.dot_one", (Object[])new Object[0])).forGoggles(tooltip);
            }
            if (this.dotCount == 2) {
                Lang.translate((String)"goggles.surface_scanner.scanning_surface", (Object[])new Object[0]).style(ChatFormatting.GOLD).add(Lang.translate((String)"goggles.misc.dot_two", (Object[])new Object[0])).forGoggles(tooltip);
            }
            if (this.dotCount == 3) {
                Lang.translate((String)"goggles.surface_scanner.scanning_surface", (Object[])new Object[0]).style(ChatFormatting.GOLD).add(Lang.translate((String)"goggles.misc.dot_three", (Object[])new Object[0])).forGoggles(tooltip);
            }
        }
        return true;
    }
}

