/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.blocks.electricity.base;

import com.drmangotea.tfmg.base.TFMGUtils;
import com.drmangotea.tfmg.blocks.electricity.base.IElectricBlock;
import com.drmangotea.tfmg.blocks.electricity.base.TFMGForgeEnergyStorage;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;

public class ElectricBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation,
IElectricBlock {
    public int voltage = 0;
    public int current = 0;
    private boolean gotFElastTick = false;
    public int distanceFromSource = Integer.MAX_VALUE;
    private LazyOptional<IEnergyStorage> lazyEnergyHandler = LazyOptional.empty();
    public final TFMGForgeEnergyStorage energy = this.createEnergyStorage();

    public ElectricBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void tick() {
        super.tick();
        this.energy.receiveEnergy(this.feGeneration(), false);
        this.manageVoltage();
        this.sendCharge(this.f_58857_, this.m_58899_());
    }

    public TFMGForgeEnergyStorage getEnergy() {
        return this.energy;
    }

    public void onLoad() {
        super.onLoad();
        this.lazyEnergyHandler = LazyOptional.of(() -> this.energy);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyEnergyHandler.invalidate();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY && side == null) {
            return this.lazyEnergyHandler.cast();
        }
        if (cap == ForgeCapabilities.ENERGY && this.hasElectricitySlot(side)) {
            return this.lazyEnergyHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void manageVoltage() {
        if (this.voltageGeneration() > 0) {
            this.voltage = this.voltageGeneration();
            this.distanceFromSource = 0;
        }
        if (this.distanceFromSource == Integer.MAX_VALUE) {
            this.voltage = 0;
        }
        this.current = this.energy.getEnergyStored() / (this.voltage + 1);
        if ((float)this.voltage > this.maxVoltage()) {
            this.voltage = 0;
            this.explode();
            this.voltage = 0;
        }
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        return true;
    }

    @Override
    public float internalResistance() {
        return 0.0f;
    }

    @Override
    public int getVoltage() {
        return this.voltage;
    }

    @Override
    public boolean gotFElastTick(int value) {
        this.gotFElastTick = value == 3 ? this.gotFElastTick : value == 1;
        return this.gotFElastTick;
    }

    @Override
    public int getCurrent() {
        return this.current;
    }

    @Override
    public void addVoltage(float amount) {
        this.voltage = (int)amount;
    }

    public void addVoltageFromNonTFMGBlock() {
    }

    @Override
    public TFMGForgeEnergyStorage getForgeEnergy() {
        return this.energy;
    }

    @Override
    public boolean hasElectricitySlot(Direction direction) {
        return false;
    }

    @Override
    public float maxVoltage() {
        return 500.0f;
    }

    @Override
    public void explode() {
        TFMGUtils.createFireExplosion(this.f_58857_, null, this.m_58899_(), 10, 1.5f);
    }

    @Override
    public int FECapacity() {
        return 10000;
    }

    @Override
    public int getDistanceFromSource() {
        return this.distanceFromSource;
    }

    @Override
    public void setDistanceFromSource(int value) {
        this.distanceFromSource = value;
    }

    @Override
    public void sendStuff() {
        this.sendData();
        this.m_6596_();
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        this.writeElectrity(compound);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.voltage = compound.m_128451_("Voltage");
        this.current = compound.m_128451_("Current");
        this.distanceFromSource = compound.m_128451_("DistanceFromSource");
        this.energy.setEnergy(compound.m_128451_("ForgeEnergy"));
    }

    @Override
    public int feGeneration() {
        return 0;
    }

    @Override
    public int voltageGeneration() {
        return 0;
    }

    @Override
    public int transferSpeed() {
        return 3000;
    }
}

