/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.blocks.electricity.base;

import com.drmangotea.tfmg.blocks.electricity.base.ConverterBlockEntity;
import com.drmangotea.tfmg.blocks.electricity.base.TFMGForgeEnergyStorage;
import com.drmangotea.tfmg.blocks.electricity.resistors.ResistorBlockEntity;
import com.simibubi.create.Create;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;

public interface IElectricBlock {
    public float internalResistance();

    public int getVoltage();

    public boolean gotFElastTick(int var1);

    public int getCurrent();

    public int feGeneration();

    public int voltageGeneration();

    public int transferSpeed();

    public void addVoltage(float var1);

    default public float getCharge() {
        return this.getCurrent() * this.getVoltage();
    }

    default public boolean isStorage() {
        return false;
    }

    public TFMGForgeEnergyStorage getForgeEnergy();

    public boolean hasElectricitySlot(Direction var1);

    public float maxVoltage();

    public void explode();

    public int FECapacity();

    public int getDistanceFromSource();

    public void setDistanceFromSource(int var1);

    public void sendStuff();

    default public boolean canBeDisabled() {
        return false;
    }

    default public boolean hasSignal() {
        return false;
    }

    default public void sendCharge(Level level, BlockPos pos) {
        int lowestDistance = Integer.MAX_VALUE;
        boolean getsVoltageFromNonTFMGBlock = false;
        if (this.canBeDisabled() && this.hasSignal()) {
            this.setDistanceFromSource(Integer.MAX_VALUE);
            return;
        }
        for (Direction direction : Direction.values()) {
            if (!this.hasElectricitySlot(direction)) continue;
            BlockEntity be1 = level.m_7702_(pos.m_121945_(direction));
            if (be1 instanceof IElectricBlock) {
                ResistorBlockEntity resistorBE;
                IElectricBlock be2 = (IElectricBlock)be1;
                if (be2.hasElectricitySlot(direction.m_122424_())) {
                    int distance = be2.getDistanceFromSource();
                    if (!this.isStorage() && be2.isStorage() && direction == Direction.UP) {
                        distance = Integer.MAX_VALUE;
                    }
                    if (this.getVoltage() == 0 && distance > this.getDistanceFromSource()) {
                        be2.addVoltage(this.getVoltage());
                    }
                    if (!(be2 instanceof ConverterBlockEntity || this.isStorage() && direction == Direction.DOWN || !this.isStorage() && be2.isStorage() && direction == Direction.DOWN || this.getVoltage() == 0)) {
                        this.transferCharge(be2);
                        if (distance > this.getDistanceFromSource()) {
                            be2.addVoltage(this.getVoltage());
                        }
                    }
                    lowestDistance = Math.min(lowestDistance, distance);
                }
                if (!direction.m_122434_().m_122479_() || !(be2 instanceof ResistorBlockEntity) || !(resistorBE = (ResistorBlockEntity)be2).hasElectricitySlot(direction) || resistorBE.getVoltageOutput() <= 0) continue;
                lowestDistance = 0;
                this.addVoltage(resistorBE.getVoltageOutput());
                continue;
            }
            if (be1 == null || !be1.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_()).isPresent() || be1.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_()).orElse((Object)new EnergyStorage(0)) instanceof TFMGForgeEnergyStorage) continue;
            int i = ((IEnergyStorage)be1.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_()).orElse((Object)new EnergyStorage(0))).receiveEnergy(1000, true);
            int y = this.getForgeEnergy().extractEnergy(1000, true);
            int j = ((IEnergyStorage)be1.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_()).orElse((Object)new EnergyStorage(0))).receiveEnergy(Math.min(y, i), false);
            this.getForgeEnergy().extractEnergy(j, false);
        }
        if (lowestDistance != Integer.MAX_VALUE && this.voltageGeneration() == 0 && lowestDistance < this.getDistanceFromSource() && Create.RANDOM.nextInt(2) == 0) {
            this.setDistanceFromSource(lowestDistance + 1);
        }
        if (this.voltageGeneration() > 0) {
            this.setDistanceFromSource(0);
        }
        if (!level.f_46443_ && lowestDistance == this.getDistanceFromSource() + 1 && this.voltageGeneration() == 0 && !getsVoltageFromNonTFMGBlock) {
            this.setDistanceFromSource(Integer.MAX_VALUE);
        }
        if (!level.f_46443_ && this.getDistanceFromSource() < lowestDistance && this.getDistanceFromSource() > 0 && this.voltageGeneration() == 0 && !getsVoltageFromNonTFMGBlock) {
            this.setDistanceFromSource(Integer.MAX_VALUE);
        }
        if (!level.f_46443_ && lowestDistance == Integer.MAX_VALUE && this.voltageGeneration() == 0 && !getsVoltageFromNonTFMGBlock) {
            this.setDistanceFromSource(Integer.MAX_VALUE);
        }
        if (lowestDistance >= this.getDistanceFromSource() && this.getDistanceFromSource() != 0) {
            this.setDistanceFromSource(Integer.MAX_VALUE);
        }
        if (this.getDistanceFromSource() == Integer.MAX_VALUE) {
            this.addVoltage(0.0f);
        }
    }

    default public void transferCharge(IElectricBlock be) {
        int amount2;
        int amount;
        if (!this.isStorage()) {
            if (be.getDistanceFromSource() > this.getDistanceFromSource() || be.isStorage()) {
                amount = this.getForgeEnergy().extractEnergy(this.transferSpeed() * 100, true);
                amount2 = be.getForgeEnergy().receiveEnergy(this.transferSpeed() * 100, true);
                this.getForgeEnergy().extractEnergy(Math.min(amount, amount2), false);
                be.getForgeEnergy().receiveEnergy(Math.min(amount, amount2), false);
            }
            if (be.getDistanceFromSource() == this.getDistanceFromSource() && this.getForgeEnergy().getEnergyStored() > be.getForgeEnergy().getEnergyStored()) {
                int diff = Math.abs(this.getForgeEnergy().getEnergyStored() - be.getForgeEnergy().getEnergyStored());
                int amount3 = this.getForgeEnergy().extractEnergy(diff / 2, true);
                int amount22 = be.getForgeEnergy().receiveEnergy(diff / 2, true);
                this.getForgeEnergy().extractEnergy(Math.min(amount3, amount22), false);
                be.getForgeEnergy().receiveEnergy(Math.min(amount3, amount22), false);
            }
        }
        if (this.isStorage()) {
            if (be.isStorage()) {
                if (!be.isStorage() || be.isStorage() && be.getForgeEnergy().getEnergyStored() < this.getForgeEnergy().getEnergyStored()) {
                    amount = this.getForgeEnergy().extractEnergy(this.transferSpeed() * 10, true);
                    amount2 = be.getForgeEnergy().receiveEnergy(this.transferSpeed() * 10, true);
                    this.getForgeEnergy().extractEnergy(Math.min(amount, amount2), false);
                    be.getForgeEnergy().receiveEnergy(Math.min(amount, amount2), false);
                }
            } else {
                amount = this.getForgeEnergy().extractEnergy(this.transferSpeed(), true);
                amount2 = be.getForgeEnergy().receiveEnergy(this.transferSpeed(), true);
                this.getForgeEnergy().extractEnergy(Math.min(amount, amount2), false);
                be.getForgeEnergy().receiveEnergy(Math.min(amount, amount2), false);
            }
        }
    }

    default public void useEnergy(int baseValue) {
        this.getForgeEnergy().extractEnergy(baseValue / (this.voltageGeneration() + 1), false);
    }

    default public TFMGForgeEnergyStorage createEnergyStorage() {
        return new TFMGForgeEnergyStorage(this.FECapacity(), 99999){

            @Override
            public void onEnergyChanged(int energyAmount, boolean setEnergy) {
                if (setEnergy) {
                    return;
                }
                IElectricBlock.this.gotFElastTick(1);
                IElectricBlock.this.sendStuff();
            }
        };
    }

    default public void writeElectrity(CompoundTag compound) {
        compound.m_128405_("Voltage", this.getVoltage());
        compound.m_128405_("Current", this.getCurrent());
        compound.m_128405_("DistanceFromSource", this.getDistanceFromSource());
        compound.m_128405_("ForgeEnergy", this.getForgeEnergy().getEnergyStored());
    }
}

