/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.blocks.electricity.base.cables;

import com.drmangotea.tfmg.base.TFMGTools;
import com.drmangotea.tfmg.blocks.electricity.base.ElectricBlockEntity;
import com.drmangotea.tfmg.blocks.electricity.base.IElectricBlock;
import com.drmangotea.tfmg.blocks.electricity.base.IHaveCables;
import com.drmangotea.tfmg.blocks.electricity.base.TFMGForgeEnergyStorage;
import com.drmangotea.tfmg.blocks.electricity.base.WallMountBlock;
import com.drmangotea.tfmg.blocks.electricity.base.cables.CableConnectorBlock;
import com.drmangotea.tfmg.blocks.electricity.base.cables.WireConnection;
import com.drmangotea.tfmg.blocks.electricity.base.cables.WireManager;
import com.drmangotea.tfmg.blocks.electricity.resistors.ResistorBlockEntity;
import com.drmangotea.tfmg.registry.TFMGItems;
import com.simibubi.create.Create;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;

public class CableConnectorBlockEntity
extends ElectricBlockEntity {
    Player player = null;
    public ArrayList<WireConnection> wireConnections = new ArrayList();

    public CableConnectorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public float maxVoltage() {
        return 6000.0f;
    }

    @Override
    public void tick() {
        super.tick();
        this.updateBlockBelow();
        this.spreadCurrent();
        this.sendData();
        this.m_6596_();
        if (Create.RANDOM.nextBoolean()) {
            this.removeInvalidConnections();
        }
        this.changeToExtension();
    }

    public void destroy() {
        super.destroy();
        ItemEntity itemToSpawn = new ItemEntity(this.f_58857_, (double)((float)this.m_58899_().m_123341_() + 0.5f), (double)((float)this.m_58899_().m_123342_() + 0.5f), (double)((float)this.m_58899_().m_123343_() + 0.5f), new ItemStack((ItemLike)TFMGItems.COPPER_CABLE.get(), this.wireConnections.toArray().length));
        if (itemToSpawn.m_32055_().m_41613_() == 0) {
            return;
        }
        this.f_58857_.m_7967_((Entity)itemToSpawn);
    }

    public void changeToExtension() {
        BlockState state = this.f_58857_.m_8055_(this.m_58899_().m_121945_((Direction)this.m_58900_().m_61143_((Property)WallMountBlock.FACING)));
        if (state.m_60734_() == this.m_58900_().m_60734_()) {
            if (state.m_61143_((Property)WallMountBlock.FACING) == this.m_58900_().m_61143_((Property)WallMountBlock.FACING) && !((Boolean)this.m_58900_().m_61143_((Property)CableConnectorBlock.EXTENSION)).booleanValue()) {
                this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)CableConnectorBlock.EXTENSION, (Comparable)Boolean.valueOf(true)), 2);
            }
        } else if (((Boolean)this.m_58900_().m_61143_((Property)CableConnectorBlock.EXTENSION)).booleanValue()) {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)CableConnectorBlock.EXTENSION, (Comparable)Boolean.valueOf(false)), 2);
        }
    }

    public void removeInvalidConnections() {
        this.wireConnections.removeIf(connection -> !(this.f_58857_.m_8055_(connection.point1).m_60734_() instanceof IHaveCables) || !(this.f_58857_.m_8055_(connection.point2).m_60734_() instanceof IHaveCables));
    }

    @Override
    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        int value = 0;
        for (WireConnection connection : this.wireConnections) {
            connection.saveConnection(compound, ++value - 1);
        }
        compound.m_128405_("WireCount", this.wireConnections.toArray().length);
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.addConnection(WireManager.Conductor.COPPER, this.m_58899_().m_6630_(2).m_122012_(), true);
        if (this.wireConnections.isEmpty()) {
            return;
        }
        this.wireConnections = new ArrayList();
        for (int i = 0; i < compound.m_128451_("WireCount"); ++i) {
            BlockPos pos = new BlockPos(compound.m_128451_("X1" + i), compound.m_128451_("Y1" + i), compound.m_128451_("Z1" + i));
            if (pos == this.m_58899_()) {
                pos = new BlockPos(compound.m_128451_("X2" + i), compound.m_128451_("Y2" + i), compound.m_128451_("Z2" + i));
            }
            this.addConnection(WireManager.Conductor.COPPER, pos, compound.m_128471_("ShouldRender" + i));
        }
    }

    @Override
    public void sendCharge(Level level, BlockPos pos) {
        int lowestDistance = Integer.MAX_VALUE;
        boolean getsVoltageFromNonTFMGBlock = false;
        for (Direction direction : Direction.values()) {
            if (!this.hasElectricitySlot(direction)) continue;
            BlockEntity be1 = level.m_7702_(pos.m_121945_(direction));
            if (be1 instanceof IElectricBlock) {
                ResistorBlockEntity resistorBE;
                IElectricBlock be2 = (IElectricBlock)be1;
                if (be2.hasElectricitySlot(direction.m_122424_())) {
                    int distance = be2.getDistanceFromSource();
                    if (!this.isStorage() && be2.isStorage() && direction == Direction.UP) {
                        distance = Integer.MAX_VALUE;
                    }
                    if (this.getVoltage() == 0 && distance > this.getDistanceFromSource()) {
                        be2.addVoltage(this.getVoltage());
                    }
                    if (!(this.isStorage() && direction == Direction.DOWN || !this.isStorage() && be2.isStorage() && direction == Direction.DOWN || this.getVoltage() == 0)) {
                        this.transferCharge(be2);
                        if (distance > this.getDistanceFromSource()) {
                            be2.addVoltage(this.getVoltage());
                        }
                    }
                    lowestDistance = Math.min(lowestDistance, distance);
                }
                if (!direction.m_122434_().m_122479_() || !(be2 instanceof ResistorBlockEntity) || !(resistorBE = (ResistorBlockEntity)be2).hasElectricitySlot(direction) || resistorBE.getVoltageOutput() <= 0) continue;
                lowestDistance = 0;
                this.addVoltage(resistorBE.getVoltageOutput());
                continue;
            }
            if (be1 == null || !be1.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_()).isPresent() || be1.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_()).orElse((Object)new EnergyStorage(0)) instanceof TFMGForgeEnergyStorage) continue;
            int i = ((IEnergyStorage)be1.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_()).orElse((Object)new EnergyStorage(0))).receiveEnergy(1000, true);
            int y = this.getForgeEnergy().extractEnergy(1000, true);
            int j = ((IEnergyStorage)be1.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_()).orElse((Object)new EnergyStorage(0))).receiveEnergy(Math.min(y, i), false);
            this.getForgeEnergy().extractEnergy(j, false);
        }
        for (WireConnection connection : this.wireConnections) {
            BlockPos pos1 = connection.point1 == this.m_58899_() ? connection.point2 : connection.point1;
            if (!(level.m_7702_(pos1) instanceof CableConnectorBlockEntity)) continue;
            lowestDistance = Math.min(lowestDistance, ((CableConnectorBlockEntity)level.m_7702_(pos1)).getDistanceFromSource());
        }
        if (lowestDistance != Integer.MAX_VALUE && this.voltageGeneration() == 0 && lowestDistance < this.getDistanceFromSource() && Create.RANDOM.nextInt(2) == 0) {
            this.setDistanceFromSource(lowestDistance + 1);
        }
        if (this.voltageGeneration() > 0) {
            this.setDistanceFromSource(0);
        }
        if (!level.f_46443_ && lowestDistance == this.getDistanceFromSource() + 1 && this.voltageGeneration() == 0 && !getsVoltageFromNonTFMGBlock) {
            this.setDistanceFromSource(Integer.MAX_VALUE);
        }
        if (!level.f_46443_ && this.getDistanceFromSource() < lowestDistance && this.getDistanceFromSource() > 0 && this.voltageGeneration() == 0 && !getsVoltageFromNonTFMGBlock) {
            this.setDistanceFromSource(Integer.MAX_VALUE);
        }
        if (!level.f_46443_ && lowestDistance == Integer.MAX_VALUE && this.voltageGeneration() == 0 && !getsVoltageFromNonTFMGBlock) {
            this.setDistanceFromSource(Integer.MAX_VALUE);
        }
        if (lowestDistance >= this.getDistanceFromSource() && this.getDistanceFromSource() != 0) {
            this.setDistanceFromSource(Integer.MAX_VALUE);
        }
        if (this.getDistanceFromSource() == Integer.MAX_VALUE) {
            this.addVoltage(0.0f);
        }
    }

    public void spreadCurrent() {
        for (WireConnection connection : this.wireConnections) {
            BlockEntity blockEntity;
            BlockPos pos = connection.point1;
            if (connection.point1 == this.m_58899_()) {
                pos = connection.point2;
            }
            if (!((blockEntity = this.f_58857_.m_7702_(pos)) instanceof CableConnectorBlockEntity)) continue;
            CableConnectorBlockEntity be = (CableConnectorBlockEntity)blockEntity;
            this.transferCharge(be);
            if (be.getDistanceFromSource() > this.getDistanceFromSource()) {
                be.addVoltage(this.getVoltage());
            }
            BlockPos pos2 = pos == connection.point1 ? connection.point2 : connection.point1;
            CableConnectorBlockEntity be2 = this;
            if (!(this.f_58857_.m_7702_(pos2) instanceof CableConnectorBlockEntity)) continue;
            be2 = (CableConnectorBlockEntity)this.f_58857_.m_7702_(pos2);
        }
    }

    public void updateBlockBelow() {
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_121945_(((Direction)this.m_58900_().m_61143_((Property)WallMountBlock.FACING)).m_122424_()));
        if (blockEntity instanceof IElectricBlock) {
            IElectricBlock be = (IElectricBlock)blockEntity;
            be.sendStuff();
        }
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    protected AABB createRenderBoundingBox() {
        return new AABB(this.m_58899_()).m_82400_(30.0);
    }

    public boolean addConnection(WireManager.Conductor material, BlockPos pos, boolean shouldRender) {
        float lenght = TFMGTools.getDistance(this.m_58899_(), pos, false);
        if (lenght < 25.0f) {
            this.wireConnections.add(new WireConnection(material, lenght, pos, this.m_58899_(), shouldRender));
            this.sendData();
            this.m_6596_();
            return true;
        }
        this.sendData();
        this.m_6596_();
        return false;
    }

    @Override
    public boolean hasElectricitySlot(Direction direction) {
        return direction == ((Direction)this.m_58900_().m_61143_((Property)WallMountBlock.FACING)).m_122424_();
    }
}

