/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.blocks.electricity.batteries;

import com.drmangotea.tfmg.blocks.electricity.base.ElectricBlockEntity;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class BatteryBlockEntity
extends ElectricBlockEntity {
    public float powerOutput = 0.0f;
    public int capacity = 0;

    public BatteryBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void setCapacity(ItemStack stack) {
        this.energy.receiveEnergy(stack.m_41784_().m_128451_("Capacity"), false);
    }

    @Override
    public void tick() {
        super.tick();
        this.powerOutput = this.capacity > 0 ? (float)this.transferSpeed() : 0.0f;
    }

    @Override
    public int transferSpeed() {
        return 100;
    }

    @Override
    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        return true;
    }

    @Override
    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128405_("Capacity", this.capacity);
        super.write(compound, clientPacket);
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.capacity = compound.m_128451_("Capacity");
    }

    @Override
    public boolean hasElectricitySlot(Direction direction) {
        return direction == Direction.UP;
    }

    @Override
    public int FECapacity() {
        return 30000;
    }

    @Override
    public int voltageGeneration() {
        return this.energy.getEnergyStored() <= 10 ? 0 : 200;
    }
}

